/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.PasswordEncryptionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class UserService
implements IUserService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    private LoadingCache<IUser, Set<IMandator>> userExecutiveDoctorsWorkingForCache;
    private LoadingCache<IUserGroup, Set<IMandator>> groupExecutiveDoctorsWorkingForCache;
    private IAccessControlService accessControlService;

    @Activate
    public void activate() {
        this.userExecutiveDoctorsWorkingForCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new UserExecutiveDoctorsLoader());
        this.groupExecutiveDoctorsWorkingForCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new GroupExecutiveDoctorsLoader());
    }

    public boolean verifyPassword(IUser user, char[] attemptedPassword) {
        boolean ret = false;
        if (user != null) {
            PasswordEncryptionService pes = new PasswordEncryptionService();
            try {
                ret = pes.authenticate(attemptedPassword, user.getHashedPassword(), user.getSalt());
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error verifying password for user [{}].", (Object)user.getLabel(), (Object)e);
            }
        }
        return ret;
    }

    public void setPasswordForUser(IUser user, String password) {
        if (user != null) {
            PasswordEncryptionService pes = new PasswordEncryptionService();
            try {
                String salt = pes.generateSaltAsHexString();
                String hashed_pw = pes.getEncryptedPasswordAsHexString(password, salt);
                user.setSalt(salt);
                user.setHashedPassword(hashed_pw);
                this.modelService.save((Identifiable)user);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Error setting password for user [{}].", (Object)user.getLabel(), (Object)e);
            }
        }
    }

    public Set<IMandator> getExecutiveDoctorsWorkingFor(IUser user, boolean includeNonActive) {
        try {
            if (includeNonActive) {
                return (Set)this.userExecutiveDoctorsWorkingForCache.get((Object)user);
            }
            return ((Set)this.userExecutiveDoctorsWorkingForCache.get((Object)user)).stream().filter(IMandator::isActive).collect(Collectors.toSet());
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting executive doctors", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public Set<IMandator> getExecutiveDoctorsWorkingFor(IUserGroup group, boolean includeNonActive) {
        try {
            if (group != null) {
                if (includeNonActive) {
                    return (Set)this.groupExecutiveDoctorsWorkingForCache.get((Object)group);
                }
                return ((Set)this.groupExecutiveDoctorsWorkingForCache.get((Object)group)).stream().filter(IMandator::isActive).collect(Collectors.toSet());
            }
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting executive doctors", (Throwable)e);
        }
        return Collections.emptySet();
    }

    public Optional<IMandator> getDefaultExecutiveDoctorWorkingFor(IUser user) {
        if (user.getAssignedContact() != null) {
            String defaultMandatorId = (String)user.getAssignedContact().getExtInfo((Object)"StdMandant");
            if (StringUtils.isNotEmpty((CharSequence)defaultMandatorId)) {
                return this.modelService.load(defaultMandatorId, IMandator.class);
            }
            if (user.getAssignedContact().isMandator()) {
                return this.modelService.load(user.getAssignedContact().getId(), IMandator.class);
            }
        }
        return Optional.empty();
    }

    public void setDefaultExecutiveDoctorWorkingFor(IUser user, IMandator mandator) {
        if (user.getAssignedContact() != null) {
            user.getAssignedContact().setExtInfo((Object)"StdMandant", (Object)mandator.getId());
            CoreModelServiceHolder.get().save((Identifiable)user.getAssignedContact());
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Can not set executive doctors for user [" + String.valueOf(user) + "] with no assigned contact");
        }
    }

    public void addOrRemoveExecutiveDoctorWorkingFor(IUser user, IMandator mandator, boolean add) {
        HashSet<IMandator> mandators = new HashSet<IMandator>(this.getExecutiveDoctorsWorkingFor(user, true));
        if (add) {
            mandators.add(mandator);
        } else {
            mandators.remove(mandator);
        }
        List edList = mandators.stream().map(p -> p.getLabel()).collect(Collectors.toList());
        user.getAssignedContact().setExtInfo((Object)"Mandant", (Object)(edList.isEmpty() ? "" : edList.stream().map(o -> o.toString()).reduce((u, t) -> u + "," + t).get()));
        CoreModelServiceHolder.get().save((Identifiable)user.getAssignedContact());
        this.userExecutiveDoctorsWorkingForCache.invalidateAll();
    }

    public void addOrRemoveExecutiveDoctorWorkingFor(IUserGroup userGroup, IMandator mandator, boolean add) {
        HashSet<IMandator> mandators = new HashSet<IMandator>(this.getExecutiveDoctorsWorkingFor(userGroup, true));
        if (add) {
            mandators.add(mandator);
        } else {
            mandators.remove(mandator);
        }
        List edList = mandators.stream().map(p -> p.getLabel()).collect(Collectors.toList());
        userGroup.setExtInfo((Object)"Mandant", (Object)(edList.isEmpty() ? "" : edList.stream().map(o -> o.toString()).reduce((u, t) -> u + "," + t).get()));
        CoreModelServiceHolder.get().save((Identifiable)userGroup);
        this.userExecutiveDoctorsWorkingForCache.invalidateAll();
        this.groupExecutiveDoctorsWorkingForCache.invalidateAll();
    }

    public List<IUser> getUsersByAssociatedContact(IContact contact) {
        if (contact == null) {
            return Collections.emptyList();
        }
        IQuery qre = this.modelService.getQuery(IUser.class);
        qre.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.EQUALS, (Object)contact);
        qre.and((EStructuralFeature)ModelPackage.Literals.IUSER__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)true);
        return qre.execute();
    }

    public boolean verifyUsernameNotTaken(String username) {
        IQuery query = this.modelService.getQuery(IUser.class, true);
        query.and("id", IQuery.COMPARATOR.EQUALS, (Object)username);
        return query.execute().isEmpty();
    }

    public boolean verifyGroupnameNotTaken(String groupname) {
        IQuery query = this.modelService.getQuery(IUserGroup.class, true);
        query.and("id", IQuery.COMPARATOR.EQUALS, (Object)groupname);
        return query.execute().isEmpty();
    }

    public List<IUserGroup> getUserGroups(IUser user) {
        ArrayList<IUserGroup> ret = new ArrayList<IUserGroup>();
        INativeQuery nativeQuery = this.modelService.getNativeQuery("SELECT USERGROUP_ID FROM USERGROUP_USER_JOINT WHERE ID = ?1");
        Iterator result = nativeQuery.executeWithParameters(nativeQuery.getIndexedParameterMap(new Object[]{1, user.getId()})).iterator();
        IAccessControlService accessControlService = this.getAccessControlService();
        while (result.hasNext()) {
            String next = result.next().toString();
            if (accessControlService != null) {
                accessControlService.doPrivileged(() -> {
                    boolean bl = ret.add((IUserGroup)CoreModelServiceHolder.get().load(next, IUserGroup.class).get());
                });
                continue;
            }
            ret.add((IUserGroup)CoreModelServiceHolder.get().load(next, IUserGroup.class).get());
        }
        return ret;
    }

    private IAccessControlService getAccessControlService() {
        if (this.accessControlService == null) {
            this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).orElse(null);
        }
        return this.accessControlService;
    }

    public List<IRole> getUserRoles(IUser user) {
        List<IUserGroup> groups = this.getUserGroups(user);
        if (!groups.isEmpty()) {
            HashSet roles = new HashSet();
            groups.forEach(g -> {
                boolean bl = roles.addAll(g.getRoles());
            });
            return new ArrayList<IRole>(roles);
        }
        return user.getRoles();
    }

    public Set<String> setUserRoles(IUser user, Set<String> userRoles) {
        LinkedList<IRole> targetUserRoleSet = new LinkedList<IRole>();
        for (String roleId : userRoles) {
            Optional _role = this.modelService.load(roleId, IRole.class);
            if (!_role.isPresent()) continue;
            targetUserRoleSet.add((IRole)_role.get());
        }
        user.setRoles(targetUserRoleSet);
        this.modelService.save((Identifiable)user);
        return targetUserRoleSet.stream().map(r -> r.getId()).collect(Collectors.toSet());
    }

    public boolean hasRole(IUser user, String roleId) {
        return this.getUserRoles(user).stream().anyMatch(role -> roleId.equals(role.getId()));
    }

    private class GroupExecutiveDoctorsLoader
    extends CacheLoader<IUserGroup, Set<IMandator>> {
        private GroupExecutiveDoctorsLoader() {
        }

        public Set<IMandator> load(IUserGroup userGroup) throws Exception {
            String mandators = (String)userGroup.getExtInfo((Object)"Mandant");
            if (mandators == null) {
                return Collections.emptySet();
            }
            List allMandators = UserService.this.modelService.getQuery(IMandator.class).execute().stream().collect(Collectors.toList());
            List<String> mandatorsIdList = Arrays.asList(mandators.split(","));
            return allMandators.stream().filter(p -> mandatorsIdList.contains(p.getLabel())).collect(Collectors.toSet());
        }
    }

    private class UserExecutiveDoctorsLoader
    extends CacheLoader<IUser, Set<IMandator>> {
        private UserExecutiveDoctorsLoader() {
        }

        public Set<IMandator> load(IUser user) throws Exception {
            List<IUserGroup> groups = UserService.this.getUserGroups(user);
            if (!groups.isEmpty()) {
                HashSet<IMandator> ret = new HashSet<IMandator>();
                groups.forEach(gr -> ret.addAll(UserService.this.getExecutiveDoctorsWorkingFor((IUserGroup)gr, true)));
                return ret;
            }
            if (user.getAssignedContact() != null) {
                String mandators = (String)user.getAssignedContact().getExtInfo((Object)"Mandant");
                if (mandators == null) {
                    return Collections.emptySet();
                }
                List allMandators = UserService.this.modelService.getQuery(IMandator.class).execute().stream().collect(Collectors.toList());
                List<String> mandatorsIdList = Arrays.asList(mandators.split(","));
                return allMandators.stream().filter(p -> mandatorsIdList.contains(p.getLabel())).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
    }
}

