/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.ui.mediorder.MediorderEntryState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediorderPartUtil {
    public static String createMediorderEntryOutreachLabel(Object object) {
        if (object instanceof IStockEntry) {
            IStockEntry stockEntry = (IStockEntry)object;
            Double resultDays = null;
            IPatient patient = stockEntry.getStock().getOwner().asIPatient();
            List lMedication = patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
            for (IPrescription prescription : lMedication) {
                if (!prescription.getArticle().equals(stockEntry.getArticle())) continue;
                float dailyDosageAsFloat = MedicationServiceHolder.get().getDailyDosageAsFloat(prescription);
                int maximumStock = stockEntry.getMaximumStock();
                resultDays = Math.floor((float)(stockEntry.getArticle().getPackageSize() * maximumStock) / dailyDosageAsFloat);
            }
            return resultDays != null ? String.valueOf(resultDays.intValue()) + " Tage" : "";
        }
        return "?";
    }

    public static String createMediorderEntryStateLabel(Object object) {
        if (object instanceof IStockEntry) {
            IStockEntry stockEntry = (IStockEntry)object;
            return MediorderPartUtil.determineState(stockEntry).getLocaleText();
        }
        return "?";
    }

    public static MediorderEntryState determineState(IStockEntry stockEntry) {
        int minimumStock = stockEntry.getMinimumStock();
        int maximumStock = stockEntry.getMaximumStock();
        int currentStock = stockEntry.getCurrentStock();
        MediorderEntryState state = MediorderEntryState.INVALID;
        if (minimumStock > 0 && maximumStock > 0 && currentStock > 0) {
            state = currentStock > maximumStock ? MediorderEntryState.INVALID : (currentStock == minimumStock ? MediorderEntryState.IN_STOCK : MediorderEntryState.PARTIALLY_IN_STOCK);
        } else if (minimumStock > 0 && maximumStock > 0 && currentStock == 0) {
            IOrderEntry order = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(stockEntry);
            if (order != null) {
                state = minimumStock == maximumStock ? MediorderEntryState.ORDERED : MediorderEntryState.PARTIALLY_ORDERED;
                state.setOrderEntry(order);
            } else {
                state = minimumStock == maximumStock ? MediorderEntryState.REQUESTED : (minimumStock > maximumStock ? MediorderEntryState.INVALID : MediorderEntryState.PARTIALLY_REQUESTED);
            }
        } else if (minimumStock == 0 && maximumStock > 0 && currentStock == 0) {
            state = MediorderEntryState.AWAITING_REQUEST;
        }
        state.setStockEntry(stockEntry);
        return state;
    }

    public static void removeStockEntry(IStockEntry entry, IModelService coreModelService) {
        coreModelService.remove((Identifiable)entry);
        IStock stock = entry.getStock();
        if (stock.getStockEntries().isEmpty()) {
            coreModelService.remove((Identifiable)stock);
        }
    }

    public static int calculateStockState(IStock stock) {
        boolean allEnabledForPea = true;
        boolean hasInStock = false;
        boolean hasPartiallyInStock = false;
        boolean hasOtherStatus = false;
        for (IStockEntry entry : stock.getStockEntries()) {
            MediorderEntryState entryState = MediorderPartUtil.determineState(entry);
            switch (entryState) {
                case AWAITING_REQUEST: {
                    break;
                }
                case IN_STOCK: {
                    hasInStock = true;
                    break;
                }
                case PARTIALLY_IN_STOCK: {
                    hasPartiallyInStock = true;
                    allEnabledForPea = false;
                    break;
                }
                case INVALID: 
                case ORDERED: 
                case PARTIALLY_ORDERED: {
                    allEnabledForPea = false;
                    hasOtherStatus = true;
                    break;
                }
                default: {
                    allEnabledForPea = false;
                    hasOtherStatus = true;
                }
            }
        }
        if (hasPartiallyInStock) {
            return 2;
        }
        if (hasInStock && allEnabledForPea) {
            return 1;
        }
        if (hasInStock && hasOtherStatus) {
            return 2;
        }
        if (allEnabledForPea) {
            return 0;
        }
        return 3;
    }

    public static void updateStockImageState(Map<IStock, Integer> imageStockStates, IStock stock) {
        int state = MediorderPartUtil.calculateStockState(stock);
        imageStockStates.put(stock, state);
    }

    public static int getImageForStock(Map<IStock, Integer> imageStockStates, IStock stock) {
        return imageStockStates.computeIfAbsent(stock, MediorderPartUtil::calculateStockState);
    }

    public static List<IStock> calculateFilteredStocks(List<Integer> filterValues) {
        HashMap<IStock, Integer> map = new HashMap<IStock, Integer>();
        List stocks = StockServiceHolder.get().getAllPatientStock();
        for (IStock stock : stocks) {
            map.computeIfAbsent(stock, MediorderPartUtil::calculateStockState);
        }
        ArrayList<IStock> filteredList = new ArrayList<IStock>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null || !filterValues.contains(entry.getValue())) continue;
            filteredList.add((IStock)entry.getKey());
        }
        return filteredList;
    }
}

