/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile;

import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.multifile.IMultiFileParser;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class MultiFileParser
implements IMultiFileParser {
    private boolean testMode = false;
    private String myLab;

    public MultiFileParser(String myLab) {
        this.myLab = myLab;
    }

    @Override
    public Result<Object> importFromFile(File hl7File, IFileImportStrategyFactory importStrategyFactory, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = VirtualFilesystemServiceHolder.get().of(hl7File);
            return this.importFromHandle(fileHandle, importStrategyFactory, hl7parser, persistenceHandler);
        }
        catch (IOException e) {
            return new Result(Result.SEVERITY.ERROR, null);
        }
    }

    @Override
    public Result<Object> importFromDirectory(File directory, IFileImportStrategyFactory importStrategyFactory, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = VirtualFilesystemServiceHolder.get().of(directory);
            return this.importFromHandle(fileHandle, importStrategyFactory, hl7parser, persistenceHandler);
        }
        catch (IOException e) {
            return new Result((Object)e);
        }
    }

    protected IVirtualFilesystemService.IVirtualFilesystemHandle[] sortListHandles(IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandles) {
        Arrays.parallelSort(iVirtualFilesystemHandles, new Comparator<IVirtualFilesystemService.IVirtualFilesystemHandle>(){

            @Override
            public int compare(IVirtualFilesystemService.IVirtualFilesystemHandle left, IVirtualFilesystemService.IVirtualFilesystemHandle right) {
                return left.getName().compareTo(right.getName());
            }
        });
        return iVirtualFilesystemHandles;
    }

    @Override
    public Result<Object> importFromHandle(IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle, IFileImportStrategyFactory importStrategyFactory, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        boolean isDirectory = false;
        try {
            isDirectory = fileHandle.isDirectory();
        }
        catch (IOException e) {
            return new Result((Object)e);
        }
        if (isDirectory) {
            Result results = new Result();
            try {
                IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles;
                IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = listHandles = this.sortListHandles(fileHandle.listHandles());
                int n = listHandles.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualFilesystemService.IVirtualFilesystemHandle childHandle = iVirtualFilesystemHandleArray[n2];
                    if ("hl7".equalsIgnoreCase(childHandle.getExtension())) {
                        Result<Object> importFromHandle = this.importFromHandle(childHandle, importStrategyFactory, hl7parser, persistenceHandler);
                        results.add(importFromHandle);
                    }
                    ++n2;
                }
                return results;
            }
            catch (IOException e) {
                return new Result((Object)e);
            }
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("labname", this.myLab);
        Map<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> strategyMap = null;
        try {
            strategyMap = importStrategyFactory.createImportStrategyMap(fileHandle);
        }
        catch (IllegalStateException ise) {
            return new Result(Result.SEVERITY.ERROR, 1, Messages.MultiFileParser_InvalidFile, (Object)fileHandle, true);
        }
        List<IVirtualFilesystemService.IVirtualFilesystemHandle> keys = this.sortStrategyList(fileHandle, strategyMap);
        Result results = new Result();
        for (IVirtualFilesystemService.IVirtualFilesystemHandle file : keys) {
            IFileImportStrategy importStrategy = strategyMap.get(file);
            importStrategy.setTestMode(this.testMode);
            try {
                results.add(importStrategy.execute(file, context, hl7parser, persistenceHandler));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error executing import", (Throwable)e);
                return new Result((Object)e);
            }
        }
        return results;
    }

    private List<IVirtualFilesystemService.IVirtualFilesystemHandle> sortStrategyList(IVirtualFilesystemService.IVirtualFilesystemHandle hl7File, Map<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> strategyMap) {
        ArrayList<IVirtualFilesystemService.IVirtualFilesystemHandle> keys = new ArrayList<IVirtualFilesystemService.IVirtualFilesystemHandle>(strategyMap.keySet());
        keys.remove(hl7File);
        keys.add(0, hl7File);
        return keys;
    }

    public void setTestMode(boolean testing) {
        this.testMode = true;
    }

    public boolean inTestMode() {
        return this.testMode;
    }
}

