/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.PatFilterImpl;
import ch.elexis.data.Brief;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.elexis.scripting.CSVWriter;
import ch.elexis.scripting.ScriptingException;
import ch.rgw.io.FileTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.FileDialog;

public class BriefExport {
    Sticker sticker = null;
    PatFilterImpl pf = new PatFilterImpl();

    public String doExport(String filename, String stickerName) {
        if (stickerName != null) {
            List ls = new Query(Sticker.class, "Name", stickerName).execute();
            if (ls != null && !ls.isEmpty()) {
                this.sticker = (Sticker)ls.get(0);
            } else {
                return "Sticker " + stickerName + " nicht gefunden.";
            }
        }
        if (filename == null) {
            FileDialog fd = new FileDialog(UiDesk.getTopShell(), 8192);
            fd.setFilterExtensions(new String[]{"*.csv"});
            fd.setFilterNames(new String[]{"Comma Separated Values (CVS)"});
            fd.setOverwrite(true);
            filename = fd.open();
        }
        if (filename != null) {
            List briefe = new Query(Brief.class).execute();
            File csv = new File(filename);
            File parent = csv.getParentFile();
            File dir = new File(parent, FileTool.getNakedFilename((String)filename));
            dir.mkdirs();
            try {
                CSVWriter writer = new CSVWriter(new FileWriter(csv));
                String[] header = new String[]{"Betreff", "Datum", "Adressat", "Mimetype", "Typ", "Patient", "Pfad"};
                String[] fields = new String[]{"Betreff", "Datum", "DestID", "MimeType", "Typ", "PatientID", "PatientID"};
                writer.writeNext(header);
                for (Brief brief : briefe) {
                    String subdirname;
                    Person pers = brief.getPatient();
                    if (pers == null || !pers.istPatient() || this.sticker != null && this.pf.accept(Patient.load((String)pers.getId()), (PersistentObject)this.sticker) != 1 || (subdirname = pers.get("PatientNr")) == null) continue;
                    File subdir = new File(dir, subdirname);
                    subdir.mkdirs();
                    String[] line = new String[fields.length];
                    brief.get(fields, line);
                    byte[] bin = brief.loadBinary();
                    if (bin == null) continue;
                    File f = new File(subdir, brief.getId() + ".odt");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(bin);
                    fos.close();
                    line[line.length - 1] = dir.getName() + File.separator + subdir.getName() + File.separator + f.getName();
                    writer.writeNext(line);
                }
                writer.close();
                return "Export ok";
            }
            catch (Exception ex) {
                ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, "Fehler beim Export: " + ex.getMessage(), ex);
                throw new ScriptingException((IStatus)status);
            }
        }
        return "Abgebrochen";
    }
}

