/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.services.internal.TypedModifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class Context
implements IContext {
    private ConcurrentHashMap<String, Object> context = new ConcurrentHashMap();
    private IContextService service;
    private Context parent;
    private IEclipseContext eclipseContext;
    private TypedModifier typedModifier;

    public Context(IContextService service) {
        this(null, "root", service);
    }

    public Context(Context parent, String name, IContextService service) {
        this.parent = parent;
        this.service = service;
        this.typedModifier = new TypedModifier(this);
    }

    public <T> Optional<T> getTyped(Class<T> clazz) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(clazz.getName()));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getTyped(clazz);
        }
        return ret;
    }

    public void setTyped(Object object) {
        this.setTyped(object, false);
    }

    protected void setTyped(Object object, boolean ignoreModifier) {
        if (object != null) {
            Optional<Class<?>> modelInterface = this.getModelInterface(object);
            if (modelInterface.isPresent()) {
                if (object.equals(this.context.get(modelInterface.get().getName()))) {
                    return;
                }
                this.context.put(modelInterface.get().getName(), object);
            } else {
                this.context.put(object.getClass().getName(), object);
            }
            if (this.eclipseContext != null) {
                if (modelInterface.isPresent()) {
                    this.eclipseContext.set(modelInterface.get().getName(), object);
                } else {
                    this.eclipseContext.set(object.getClass().getName(), object);
                }
            }
            if (this.typedModifier != null && !ignoreModifier) {
                this.typedModifier.modifyFor(object);
            }
        } else {
            throw new IllegalArgumentException("object must not be null, use #removeTyped");
        }
    }

    private Optional<Class<?>> getModelInterface(Object object) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = object.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (interfaze.getName().startsWith("ch.elexis.core.model") && !interfaze.getName().contains("Identifiable")) {
                return Optional.of(interfaze);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public void removeTyped(Class<?> clazz) {
        this.removeTyped(clazz, false);
    }

    protected void removeTyped(Class<?> clazz, boolean ignoreModifier) {
        this.context.remove(clazz.getName());
        if (this.eclipseContext != null) {
            this.eclipseContext.remove(clazz.getName());
        }
        if (this.typedModifier != null && !ignoreModifier) {
            this.typedModifier.modifyRemove(clazz);
        }
    }

    public Optional<?> getNamed(String name) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(name));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getNamed(name);
        }
        if (ret.isPresent() && ret.get() instanceof Supplier) {
            return Optional.ofNullable(((Supplier)ret.get()).get());
        }
        return ret;
    }

    public void setNamed(String name, Object object) {
        if (object == null) {
            this.context.remove(name);
        } else {
            if (object.equals(this.context.get(name))) {
                return;
            }
            if (this.context.get(name) instanceof Consumer) {
                ((Consumer)this.context.get(name)).accept(object);
            } else {
                this.context.put(name, object);
            }
        }
        if (this.eclipseContext != null) {
            this.eclipseContext.set(name, object);
        }
    }

    public void setParent(Context parent) {
        this.parent = parent;
    }

    public void setEclipseContext(IEclipseContext applicationContext) {
        this.eclipseContext = applicationContext;
        this.setTyped(applicationContext);
        this.context.forEach((k, v) -> {
            if (k instanceof String && v != null) {
                this.eclipseContext.set(k, v);
            }
        });
    }

    public String getStationIdentifier() {
        return this.getNamed("ch.elexis.core.services.icontext.stationidentifier").get().toString();
    }

    public IContextService getService() {
        return this.service;
    }
}

