/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.processor;

import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=info/elexis/ui/accesscontrol/update", "event.topics=info/elexis/ui/accesscontrol/reset", "event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class AccessControlUiEventHandler
implements EventHandler {
    @Reference
    private IAccessControlService accessControlService;
    private boolean startUpComplete = false;
    private MApplication mApplication;
    @Inject
    private EModelService eModelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private UISynchronize uiSynchronize;
    private Map<String, List<String>> viewAccessControlMap;
    private Set<MPartDescriptor> removedDescriptors = new HashSet<MPartDescriptor>();

    private void updateModel() {
        LoggerFactory.getLogger(this.getClass()).info("UPDATE MODEL " + String.valueOf(this.mApplication) + " / " + String.valueOf(this.eModelService));
        this.updateDescriptors();
        this.updateParts();
        this.updatePlaceholders();
        this.updatePartStacks();
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/e4/ui/LifeCycle/appStartupComplete".equals(event.getTopic())) {
            Object property = event.getProperty("org.eclipse.e4.data");
            if (property instanceof MApplication) {
                this.mApplication = (MApplication)property;
            }
            CoreUiUtil.injectServices((Object)this);
            this.startUpComplete = true;
            this.uiSynchronize.asyncExec(() -> this.updateModel());
        }
        if (this.startUpComplete) {
            if (event.getTopic().endsWith("ui/accesscontrol/reset")) {
                this.uiSynchronize.asyncExec(() -> {
                    LoggerFactory.getLogger(this.getClass()).info("RESET for event [" + String.valueOf(event) + "]");
                    if (this.mApplication != null && this.eModelService != null) {
                        this.resetModel();
                    }
                });
            }
            if (event.getTopic().endsWith("ui/accesscontrol/update")) {
                this.uiSynchronize.asyncExec(() -> {
                    LoggerFactory.getLogger(this.getClass()).info("UPDATE for event [" + String.valueOf(event) + "]");
                    if (this.mApplication != null && this.eModelService != null) {
                        this.updateModel();
                    }
                });
            }
        }
    }

    private void resetModel() {
        LoggerFactory.getLogger(this.getClass()).info("RESET MODEL " + String.valueOf(this.mApplication) + " / " + String.valueOf(this.eModelService));
        if (this.removedDescriptors != null && !this.removedDescriptors.isEmpty()) {
            this.mApplication.getDescriptors().addAll(this.removedDescriptors);
            this.removedDescriptors = new HashSet<MPartDescriptor>();
        }
    }

    private List<MPartDescriptor> updateDescriptors() {
        ArrayList<MPartDescriptor> ret = new ArrayList<MPartDescriptor>();
        for (MPartDescriptor foundPartDescriptor : new ArrayList(this.mApplication.getDescriptors())) {
            List<String> acStrings = this.getAccessControlStrings((MApplicationElement)foundPartDescriptor);
            if (acStrings == null || acStrings.isEmpty()) continue;
            List<EvaluatableACE> aces = this.getAccessControlEntries(acStrings);
            for (EvaluatableACE ace : aces) {
                if (this.accessControlService.evaluate(ace)) continue;
                while (this.mApplication.getDescriptors().remove(foundPartDescriptor)) {
                }
                this.removedDescriptors.add(foundPartDescriptor);
            }
        }
        return ret;
    }

    private void updatePartStacks() {
        MPerspective activePerspective = GlobalActions.getActivePerspective(this.eModelService);
        List foundpartStacks = this.eModelService.findElements((MUIElement)activePerspective, null, MPartStack.class, null);
        for (MPartStack partStack : foundpartStacks) {
            MStackElement selectedPart = (MStackElement)partStack.getSelectedElement();
            if (selectedPart != null && selectedPart.isVisible() && selectedPart.isToBeRendered()) {
                this.sendStackSelectedElement((MStackElement)partStack.getSelectedElement(), partStack);
                continue;
            }
            for (MStackElement part : partStack.getChildren()) {
                if (!part.isVisible() || !part.isToBeRendered()) continue;
                this.sendStackSelectedElement(part, partStack);
            }
        }
    }

    private void sendStackSelectedElement(MStackElement mStackElement, MPartStack partStack) {
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        argMap.put("ChangedElement", partStack);
        argMap.put("OldValue", null);
        argMap.put("NewValue", partStack.getSelectedElement());
        this.eventBroker.send("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/SET", argMap);
    }

    private void updatePlaceholders() {
        List foundPlaceholders = this.eModelService.findElements((MUIElement)this.mApplication, null, MPlaceholder.class, null);
        for (MPlaceholder placeholder : foundPlaceholders) {
            List<String> acStrings = this.getAccessControlStrings((MApplicationElement)placeholder);
            if (acStrings == null || acStrings.isEmpty()) continue;
            List<EvaluatableACE> aces = this.getAccessControlEntries(acStrings);
            for (EvaluatableACE ace : aces) {
                if (!this.accessControlService.evaluate(ace)) {
                    placeholder.setVisible(false);
                    placeholder.getTags().add("AccessControlUiEventHandler:hidden");
                    continue;
                }
                if (!placeholder.getTags().contains("AccessControlUiEventHandler:hidden")) continue;
                placeholder.setVisible(true);
                placeholder.getTags().remove("AccessControlUiEventHandler:hidden");
            }
        }
    }

    private void updateParts() {
        List foundParts = this.eModelService.findElements((MUIElement)this.mApplication, null, MPart.class, null);
        for (MPart mPart : foundParts) {
            List<String> acStrings = this.getAccessControlStrings((MApplicationElement)mPart);
            if (acStrings == null || acStrings.isEmpty()) continue;
            List<EvaluatableACE> aces = this.getAccessControlEntries(acStrings);
            for (EvaluatableACE ace : aces) {
                if (!this.accessControlService.evaluate(ace)) {
                    mPart.setVisible(false);
                    mPart.getTags().add("AccessControlUiEventHandler:hidden");
                    continue;
                }
                if (!mPart.getTags().contains("AccessControlUiEventHandler:hidden")) continue;
                mPart.setVisible(true);
                mPart.getTags().remove("AccessControlUiEventHandler:hidden");
            }
        }
    }

    private List<String> getViewAccessControlStrings(String viewId) {
        if (this.viewAccessControlMap == null) {
            this.viewAccessControlMap = new HashMap<String, List<String>>();
            IExtensionRegistry exr = Platform.getExtensionRegistry();
            IExtensionPoint exp = exr.getExtensionPoint("ch.elexis.core.ui.AccessControl");
            if (exp != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = exp.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elems;
                    IExtension ex = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                    int n3 = elems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement el = iConfigurationElementArray[n4];
                        if ("view".equals(el.getName())) {
                            String elementViewId = el.getAttribute("id");
                            String elementObject = el.getAttribute("object");
                            String elementRole = el.getAttribute("role");
                            if (StringUtils.isNotBlank((CharSequence)elementObject) || StringUtils.isNotBlank((CharSequence)elementRole)) {
                                ArrayList<CallSite> acStrings = new ArrayList<CallSite>();
                                if (StringUtils.isNotBlank((CharSequence)elementObject)) {
                                    acStrings.add((CallSite)((Object)("object:" + elementObject.trim())));
                                }
                                if (StringUtils.isNotBlank((CharSequence)elementRole)) {
                                    acStrings.add((CallSite)((Object)("role:" + elementRole.trim())));
                                }
                                this.viewAccessControlMap.put(elementViewId, acStrings);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.viewAccessControlMap.get(viewId);
    }

    private List<String> getAccessControlStrings(MApplicationElement partDescriptor) {
        List<String> ret = this.getAccessControlTags(partDescriptor.getTags());
        if (ret.isEmpty()) {
            ret = this.getViewAccessControlStrings(partDescriptor.getElementId());
        }
        return ret;
    }

    private List<String> getAccessControlTags(List<String> tags) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String tag : tags) {
            if (!tag.startsWith("accesscontrol:")) continue;
            ret.add(tag.substring("accesscontrol:".length()));
        }
        return ret;
    }

    private List<EvaluatableACE> getAccessControlEntries(List<String> acStrings) {
        ArrayList<EvaluatableACE> ret = new ArrayList<EvaluatableACE>();
        for (String acString : acStrings) {
            String acObjTag;
            String[] objParts;
            if (!acString.startsWith("object:") || (objParts = (acObjTag = acString.substring("object:".length())).split(",")) == null || objParts.length <= 0) continue;
            String[] stringArray = objParts;
            int n = objParts.length;
            int n2 = 0;
            while (n2 < n) {
                String objPart = stringArray[n2];
                ret.add((EvaluatableACE)new ObjectEvaluatableACE(objPart.trim(), Right.VIEW));
                ++n2;
            }
        }
        return ret;
    }
}

