/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.services.holder.UserServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.coolbar.MandantSelectionContributionItem;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.databinding.SavingUpdateValueStrategy;
import ch.elexis.core.ui.dialogs.ChangePasswordDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.inputs.PrefAccessDenied;
import ch.elexis.core.ui.util.BooleanNotConverter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.LoggerFactory;

public class UserManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IUnlockable {
    private TableViewer tableViewerUsers;
    private List<IUserGroup> userGroups = Collections.emptyList();
    private WritableValue<IUser> wvUser = new WritableValue(null, IUser.class);
    private WritableValue<IContact> wvUserContact = new WritableValue(null, IContact.class);
    private Button btnIsExecutiveDoctor;
    private Label lblRespPhysColor;
    private Group grpAccounting;
    public static final String CHANGE_LINK = "<a>\u00e4ndern</a>";
    private Link linkContact;
    private CheckboxTableViewer checkboxTableViewerAssociation;
    private CheckboxTableViewer checkboxTableViewerRoles;
    private Link linkChangePassword;
    private Button btnUserIsAdmin;
    private Button btnMandatorIsInactive;
    private Color lblRespPhysColorDefColor;
    private Link linkRechnungssteller;
    private RestrictedAction addUserAction;
    private RestrictedAction deleteUserAction;
    private RestrictedAction lockUserAction;
    private Button btnUserIsLocked;
    private Label userInfoLabel;
    private boolean isShowOnlyActive = true;
    private Composite compositeAssociation;

    public UserManagementPreferencePage() {
        this.setTitle("Benutzerverwaltung");
        this.noDefaultAndApplyButton();
    }

    public Control createContents(Composite parent) {
        if (!AccessControlServiceHolder.get().evaluate(EvACE.of(IUser.class, (Right)Right.CREATE).and(Right.UPDATE).and(Right.DELETE))) {
            return new PrefAccessDenied(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        MenuManager popManager = new MenuManager();
        this.addUserAction = new RestrictedAction((EvaluatableACE)EvACE.of(IUser.class, (Right)Right.CREATE), Messages.Core_Add_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            @Override
            public void doRun() {
                IInputValidator iiv = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() < 3) {
                            return "Mindestens 3 Zeichen";
                        }
                        boolean allLettersOrDigits = newText.chars().allMatch(x -> Character.isLetterOrDigit(x));
                        if (!allLettersOrDigits) {
                            return "Nur Buchstaben und Zahlen erlaubt";
                        }
                        boolean isFree = UserServiceHolder.get().verifyUsernameNotTaken(newText);
                        if (!isFree) {
                            return "Benuterzname vergeben (evtl. f\u00fcr gel\u00f6schten Benutzer)";
                        }
                        return null;
                    }
                };
                InputDialog id = new InputDialog(Hub.getActiveShell(), "Benutzernamen festlegen", "Benutzernamen festlegen - dieser kann nicht mehr ge\u00e4ndert, sowie zuk\u00fcnftig anderweitig verwendet werden.", null, iiv);
                int retVal = id.open();
                if (retVal == 0) {
                    IUser newUser = (IUser)new IUserBuilder(CoreModelServiceHolder.get(), id.getValue(), null).buildAndSave();
                    UserManagementPreferencePage.this.updateUserList();
                    UserManagementPreferencePage.this.tableViewerUsers.setSelection((ISelection)new StructuredSelection((Object)newUser));
                }
            }
        };
        popManager.add((IAction)this.addUserAction);
        this.deleteUserAction = new LockedRestrictedAction<IUser>((EvaluatableACE)EvACE.of(IUser.class, (Right)Right.DELETE), Messages.Core_Delete){

            @Override
            public IUser getTargetedObject() {
                if (UserManagementPreferencePage.this.tableViewerUsers == null) {
                    return null;
                }
                StructuredSelection ss = (StructuredSelection)UserManagementPreferencePage.this.tableViewerUsers.getSelection();
                return ss != null ? (IUser)ss.getFirstElement() : null;
            }

            @Override
            public void doRun(IUser user) {
                IUser currentUser = ContextServiceHolder.get().getActiveUser().orElse(null);
                if (currentUser != null) {
                    if (currentUser.getId().equals(user.getId())) {
                        MessageDialog.openWarning((Shell)UserManagementPreferencePage.this.getShell(), (String)"Warnung", (String)"Dieser Benutzer ist gerade eingeloggt und kann daher nicht entfernt werden!");
                    } else {
                        CoreModelServiceHolder.get().delete((Deleteable)user);
                        UserManagementPreferencePage.this.updateUserList();
                        UserManagementPreferencePage.this.wvUser.setValue(null);
                        UserManagementPreferencePage.this.wvUserContact.setValue(null);
                    }
                }
            }
        };
        popManager.add((IAction)this.deleteUserAction);
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            this.lockUserAction = new RestrictedAction((EvaluatableACE)EvACE.of(IUser.class, (Right)Right.UPDATE), Messages.Leistungscodes_editItem){

                @Override
                public void doRun() {
                    StructuredSelection ss = (StructuredSelection)UserManagementPreferencePage.this.tableViewerUsers.getSelection();
                    IUser u = (IUser)ss.getFirstElement();
                    LockResponse acquireLock = LocalLockServiceHolder.get().acquireLock((Object)u);
                    if (acquireLock.isOk()) {
                        UserManagementPreferencePage.this.setUnlocked(true);
                    }
                }

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_LOCK_OPEN.getImageDescriptor();
                }
            };
            popManager.add((IAction)this.lockUserAction);
        }
        popManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserManagementPreferencePage.this.addUserAction.reflectRight();
                UserManagementPreferencePage.this.deleteUserAction.reflectRight();
                if (UserManagementPreferencePage.this.lockUserAction != null) {
                    UserManagementPreferencePage.this.lockUserAction.reflectRight();
                }
            }
        });
        SashForm sash = new SashForm(container, 256);
        sash.setLayout((Layout)new GridLayout(2, false));
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite compositeLeft = new Composite((Composite)sash, 0);
        compositeLeft.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeLeft = new GridLayout(1, false);
        gl_compositeLeft.marginWidth = 0;
        gl_compositeLeft.marginHeight = 0;
        compositeLeft.setLayout((Layout)gl_compositeLeft);
        Composite compositeButtons = new Composite(compositeLeft, 0);
        GridLayout gridLayoutButtons = new GridLayout(3, false);
        gridLayoutButtons.marginWidth = 0;
        gridLayoutButtons.marginHeight = 0;
        gridLayoutButtons.horizontalSpacing = 0;
        compositeButtons.setLayout((Layout)gridLayoutButtons);
        compositeButtons.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnAdd = new Button(compositeButtons, 0x800000);
        btnAdd.setImage(Images.IMG_NEW.getImage());
        GridData gd_btnAdd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_btnAdd.widthHint = 30;
        btnAdd.setLayoutData((Object)gd_btnAdd);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementPreferencePage.this.addUserAction.doRun();
            }
        });
        final Button btnToggleUserFilter = new Button(compositeButtons, 8);
        btnToggleUserFilter.setImage(Images.IMG_EYE_WO_SHADOW.getImage());
        btnToggleUserFilter.setText("Alle User");
        GridData gd_btnToggleUserFilter = new GridData(4, 0x1000000, true, false, 2, 1);
        btnToggleUserFilter.setLayoutData((Object)gd_btnToggleUserFilter);
        btnToggleUserFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementPreferencePage.this.isShowOnlyActive = !UserManagementPreferencePage.this.isShowOnlyActive;
                UserManagementPreferencePage.this.updateUserList();
                UserManagementPreferencePage.this.updateAssociations();
                btnToggleUserFilter.setText(UserManagementPreferencePage.this.isShowOnlyActive ? "Alle User" : "Aktive User");
                btnToggleUserFilter.setImage(UserManagementPreferencePage.this.isShowOnlyActive ? Images.IMG_EYE_WO_SHADOW.getImage() : Images.IMG_REMOVEITEM.getImage());
                UserManagementPreferencePage.this.resetAll();
            }
        });
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            final Button btnLock = new Button(compositeButtons, 0x800002);
            btnLock.setSelection(LocalLockServiceHolder.get().isLocked(this.wvUser.getValue()));
            btnLock.setImage(Images.IMG_LOCK_OPEN.getImage());
            btnLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                    if (LocalLockServiceHolder.get().isLocked((Object)user)) {
                        LocalLockServiceHolder.get().releaseLock((Object)user);
                    } else {
                        UserManagementPreferencePage.this.lockUserAction.doRun();
                    }
                    boolean locked = LocalLockServiceHolder.get().isLocked(UserManagementPreferencePage.this.wvUser.getValue());
                    btnLock.setSelection(locked);
                    UserManagementPreferencePage.this.setUnlocked(locked);
                }
            });
        }
        Composite compositeSelectorTable = new Composite(compositeLeft, 0);
        compositeSelectorTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_compositeSelectorTable = new TableColumnLayout();
        compositeSelectorTable.setLayout((Layout)tcl_compositeSelectorTable);
        Composite compositeEdit = new Composite((Composite)sash, 0);
        GridLayout gl_compositeEdit = new GridLayout(2, false);
        gl_compositeEdit.horizontalSpacing = 0;
        gl_compositeEdit.verticalSpacing = 0;
        gl_compositeEdit.marginWidth = 0;
        gl_compositeEdit.marginHeight = 0;
        compositeEdit.setLayout((Layout)gl_compositeEdit);
        compositeEdit.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.userInfoLabel = new Label(compositeEdit, 0);
        this.userInfoLabel.setFont(SWTResourceManager.getFont(".AppleSystemUIFont", 14, 1));
        this.userInfoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(compositeEdit, 0);
        this.tableViewerUsers = new TableViewer(compositeSelectorTable, 67584);
        this.tableViewerUsers.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tableUsers = this.tableViewerUsers.getTable();
        tableUsers.setLinesVisible(true);
        this.tableViewerUsers.addSelectionChangedListener(e -> {
            this.releaseLockIfRequired();
            StructuredSelection ss = (StructuredSelection)e.getSelection();
            this.wvUser.setValue(ss == null ? null : (IUser)ss.getFirstElement());
            this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
            compositeEdit.layout(true, true);
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewerUsers, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tcl_compositeSelectorTable.setColumnData((Widget)tblclmnName, (ColumnLayoutData)new ColumnWeightData(100));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new AnwenderCellLabelProvider());
        Menu menu = popManager.createContextMenu((Control)tableUsers);
        tableUsers.setMenu(menu);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        Group grpSysAccess = new Group(compositeEdit, 0);
        grpSysAccess.setText("Systemzugang");
        grpSysAccess.setLayout((Layout)new GridLayout(3, true));
        grpSysAccess.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.linkChangePassword = new Link((Composite)grpSysAccess, 0);
        this.linkChangePassword.setText("<a>Passwort \u00e4ndern</a>");
        this.linkChangePassword.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.linkChangePassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                new ChangePasswordDialog(UiDesk.getTopShell(), user).open();
            }
        });
        this.btnUserIsAdmin = new Button((Composite)grpSysAccess, 32);
        this.btnUserIsAdmin.setToolTipText("Administratoren unterliegen keinerlei Beschr\u00e4nkungen.");
        this.btnUserIsAdmin.setText("Administrator");
        this.btnUserIsLocked = new Button((Composite)grpSysAccess, 32);
        this.btnUserIsLocked.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnUserIsLocked.setToolTipText("Sperrt die M\u00f6glichkeit sich am System anzumelden.");
        this.btnUserIsLocked.setText("Zugang sperren");
        this.grpAccounting = new Group(compositeEdit, 0);
        this.grpAccounting.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        this.grpAccounting.setText("Verrechnung");
        GridLayout gl_grpAccounting = new GridLayout(1, false);
        gl_grpAccounting.marginHeight = 5;
        this.grpAccounting.setLayout((Layout)gl_grpAccounting);
        Composite compositeContact = new Composite((Composite)this.grpAccounting, 0);
        GridLayout gl_compositeContact = new GridLayout(2, false);
        gl_compositeContact.horizontalSpacing = 0;
        gl_compositeContact.verticalSpacing = 0;
        gl_compositeContact.marginWidth = 0;
        gl_compositeContact.marginHeight = 0;
        compositeContact.setLayout((Layout)gl_compositeContact);
        compositeContact.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label lblKontakt = new Label(compositeContact, 0);
        lblKontakt.setText("Kontakt: ");
        this.linkContact = new Link(compositeContact, 0);
        this.linkContact.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.linkContact.setText("nicht gesetzt <a>\u00e4ndern</a>");
        this.linkContact.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Person.class, "Kontakt ausw\u00e4hlen", "Bitte selektieren Sie den zugeordneten Kontakt", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    IPerson p = (IPerson)NoPoUtil.loadAsIdentifiable((PersistentObject)((Person)ks.getSelection()), IPerson.class).get();
                    p.setUser(true);
                    user.setAssignedContact((IContact)p);
                    UserManagementPreferencePage.this.linkContact.setText(p.getLabel() + " <a>\u00e4ndern</a>");
                    CoreModelServiceHolder.get().save((Identifiable)p);
                    CoreModelServiceHolder.get().save((Identifiable)user);
                }
            }
        });
        Composite compositeIsRespPhys = new Composite((Composite)this.grpAccounting, 2048);
        compositeIsRespPhys.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeIsRespPhys = new GridLayout(2, false);
        gl_compositeIsRespPhys.marginHeight = 0;
        compositeIsRespPhys.setLayout((Layout)gl_compositeIsRespPhys);
        this.lblRespPhysColor = new Label(compositeIsRespPhys, 0);
        this.lblRespPhysColor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblRespPhysColor.setText("zugeordnete Farbe");
        this.lblRespPhysColorDefColor = this.lblRespPhysColor.getBackground();
        this.lblRespPhysColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Optional mandator;
                if (!UserManagementPreferencePage.this.btnIsExecutiveDoctor.getSelection()) {
                    return;
                }
                ColorDialog cd = new ColorDialog(UiDesk.getTopShell());
                cd.setRGB(UserManagementPreferencePage.this.lblRespPhysColor.getBackground().getRGB());
                cd.setText(Messages.UserManagementPreferencePage_MandatorColorSelectTitle);
                RGB rgb = cd.open();
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user.getAssignedContact() != null && (mandator = CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class)).isPresent()) {
                    UiMandant.setColorForMandator(Mandant.load((String)((IMandator)mandator.get()).getId()), rgb);
                    UserManagementPreferencePage.this.lblRespPhysColor.setBackground(UiMandant.getColorForMandator(Mandant.load((String)((IMandator)mandator.get()).getId())));
                }
                UserManagementPreferencePage.this.updateUserList();
            }
        });
        Label lblRechnungssteller = new Label(compositeIsRespPhys, 0);
        lblRechnungssteller.setText("Rechnungssteller:");
        this.linkRechnungssteller = new Link(compositeIsRespPhys, 0);
        this.linkRechnungssteller.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.linkRechnungssteller.setText("nicht gesetzt <a>\u00e4ndern</a>");
        this.linkRechnungssteller.setToolTipText("Set the invoice contact for this mandator");
        this.linkRechnungssteller.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                Optional mandator = Optional.empty();
                if (user.getAssignedContact() != null) {
                    mandator = CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class);
                }
                if (!mandator.isPresent()) {
                    MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)"Fehler", (String)"Der selektierte Kontakt ist kein Mandant.");
                    return;
                }
                KontaktSelektor ks = new KontaktSelektor(UiDesk.getTopShell(), Kontakt.class, "Rechnungs-Kontakt ausw\u00e4hlen", "Bitte selektieren Sie den dem Mandant zugeordneten Rechnungs-Kontakt", new String[0]);
                int ret = ks.open();
                if (ret == 0) {
                    Kontakt kontakt = (Kontakt)ks.getSelection();
                    if (kontakt == null) {
                        return;
                    }
                    ((IMandator)mandator.get()).setBiller((IContact)NoPoUtil.loadAsIdentifiable((PersistentObject)kontakt, IContact.class).get());
                    CoreModelServiceHolder.get().save((Identifiable)mandator.get());
                    UserManagementPreferencePage.this.linkRechnungssteller.setText(((IMandator)mandator.get()).getBiller().getLabel() + " <a>\u00e4ndern</a>");
                }
            }
        });
        Composite compositeMandator = new Composite((Composite)this.grpAccounting, 0);
        GridLayout gl_compositeMandator = new GridLayout(2, true);
        gl_compositeMandator.verticalSpacing = 0;
        gl_compositeMandator.horizontalSpacing = 0;
        gl_compositeMandator.marginHeight = 0;
        gl_compositeMandator.marginWidth = 0;
        compositeMandator.setLayout((Layout)gl_compositeMandator);
        compositeMandator.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnIsExecutiveDoctor = new Button(compositeMandator, 32);
        this.btnIsExecutiveDoctor.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnIsExecutiveDoctor.setText("ist verantwortlicher Arzt");
        this.btnIsExecutiveDoctor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserManagementPreferencePage.this.btnIsExecutiveDoctor.getSelection()) {
                    IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                    if (user == null) {
                        return;
                    }
                    IContact ac = user.getAssignedContact();
                    if (ac == null) {
                        return;
                    }
                    Optional mandator = CoreModelServiceHolder.get().load(ac.getId(), IMandator.class);
                    if (!mandator.isPresent()) {
                        boolean changeIt = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Kontakt ist kein Mandant", (String)"Der selektierte Kontakt ist kein Mandant. Wollen Sie diesen Kontakt in einen Mandanten \u00e4ndern?");
                        if (changeIt) {
                            ac.setMandator(true);
                            CoreModelServiceHolder.get().save((Identifiable)ac);
                        }
                        UserManagementPreferencePage.this.btnIsExecutiveDoctor.setSelection(changeIt);
                    }
                }
                UserManagementPreferencePage.this.btnMandatorIsInactive.setEnabled(UserManagementPreferencePage.this.btnIsExecutiveDoctor.getSelection());
            }
        });
        this.btnMandatorIsInactive = new Button(compositeMandator, 32);
        this.btnMandatorIsInactive.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnMandatorIsInactive.setText("ehemalig (Verrechn. sperren)");
        this.btnMandatorIsInactive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user == null) {
                    return;
                }
                Optional mandator = Optional.empty();
                if (user.getAssignedContact() != null) {
                    mandator = CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class);
                }
                if (!mandator.isPresent()) {
                    UserManagementPreferencePage.this.btnMandatorIsInactive.setSelection(false);
                    return;
                }
                if (UserManagementPreferencePage.this.btnMandatorIsInactive.getSelection() && SWTHelper.askYesNo("Mandanten deaktivieren", ((IMandator)mandator.get()).getDescription1() + " " + ((IMandator)mandator.get()).getDescription2() + " wirklich deaktivieren?")) {
                    UserManagementPreferencePage.this.btnMandatorIsInactive.setEnabled(true);
                } else {
                    UserManagementPreferencePage.this.btnMandatorIsInactive.setSelection(false);
                }
                ((IMandator)mandator.get()).setActive(!UserManagementPreferencePage.this.btnMandatorIsInactive.getSelection());
                CoreModelServiceHolder.get().save((Identifiable)mandator.get());
            }
        });
        Composite compositeAccounting = new Composite((Composite)this.grpAccounting, 0);
        compositeAccounting.setLayout((Layout)new GridLayout(2, true));
        compositeAccounting.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Group grpAssociation = new Group(compositeAccounting, 0);
        grpAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpAssociation.setText("t\u00e4tig f\u00fcr");
        GridLayout gl_grp = new GridLayout(2, false);
        gl_grp.marginHeight = 0;
        grpAssociation.setLayout((Layout)gl_grp);
        this.compositeAssociation = new Composite((Composite)grpAssociation, 0);
        this.compositeAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tcl_compositeAssociation = new TableColumnLayout();
        this.compositeAssociation.setLayout((Layout)tcl_compositeAssociation);
        this.checkboxTableViewerAssociation = CheckboxTableViewer.newCheckList((Composite)this.compositeAssociation, (int)67584);
        this.checkboxTableViewerAssociation.addCheckStateListener(e -> {
            IMandator m = (IMandator)e.getElement();
            if (m == null) {
                return;
            }
            IUser user = (IUser)this.wvUser.getValue();
            if (user.getAssignedContact() != null) {
                UserServiceHolder.get().addOrRemoveExecutiveDoctorWorkingFor(user, m, e.getChecked());
            } else {
                SWTHelper.showError("No contact assigned", "There is no contact assigned to user " + user.getLabel());
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IUser user;
                Object selected;
                IStructuredSelection selection = UserManagementPreferencePage.this.checkboxTableViewerAssociation.getStructuredSelection();
                if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IMandator && (user = (IUser)UserManagementPreferencePage.this.wvUser.getValue()) != null && user.getAssignedContact() != null) {
                    IMandator stdWorkingFor = UserServiceHolder.get().getDefaultExecutiveDoctorWorkingFor(user).orElse(null);
                    if (stdWorkingFor != null && stdWorkingFor.equals(selected)) {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Std. Mandant entfernen";
                            }

                            public void run() {
                                UserServiceHolder.get().setDefaultExecutiveDoctorWorkingFor(user, null);
                                (this).UserManagementPreferencePage.this.checkboxTableViewerAssociation.refresh();
                            }
                        });
                    } else {
                        manager.add((IAction)new Action(){

                            public String getText() {
                                return "Std. Mandant setzen";
                            }

                            public void run() {
                                UserServiceHolder.get().setDefaultExecutiveDoctorWorkingFor(user, (IMandator)selected);
                                (this).UserManagementPreferencePage.this.checkboxTableViewerAssociation.refresh();
                            }
                        });
                    }
                }
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.checkboxTableViewerAssociation.getTable());
        this.checkboxTableViewerAssociation.getTable().setMenu(contextMenu);
        Group grpRoles = new Group(compositeAccounting, 0);
        grpRoles.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpRoles.setText("Rollenzuordnung");
        GridLayout gl_grpRoles = new GridLayout(2, false);
        gl_grpRoles.marginHeight = 0;
        grpRoles.setLayout((Layout)gl_grpRoles);
        Composite compositeRoles = new Composite((Composite)grpRoles, 0);
        compositeRoles.setLayout((Layout)new FillLayout(256));
        compositeRoles.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        MenuManager rolePopManager = new MenuManager();
        rolePopManager.add((IAction)new Action(){

            public void run() {
                final List existingRoleIds = CoreModelServiceHolder.get().getQuery(IRole.class).execute().stream().map(r -> r.getId()).collect(Collectors.toList());
                InputDialog dialog = new InputDialog(UserManagementPreferencePage.this.getShell(), "Neue Rolle", "Rollen Name", null, new IInputValidator(){

                    public String isValid(String newText) {
                        if (StringUtils.isBlank((CharSequence)newText)) {
                            return "Rollen Name kann nicht leer sein.";
                        }
                        if (existingRoleIds.contains(newText)) {
                            return "Rollen mit Name existiert bereits.";
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0) {
                    IRole role = (IRole)CoreModelServiceHolder.get().create(IRole.class);
                    role.setId(dialog.getValue());
                    role.setSystemRole(false);
                    CoreModelServiceHolder.get().save((Identifiable)role);
                    UserManagementPreferencePage.this.updateRoles();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public String getText() {
                return "Neue Rolle";
            }
        });
        rolePopManager.add((IAction)new Action(){

            public void run() {
                IRole role = (IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement();
                for (IUser user : CoreModelServiceHolder.get().getQuery(IUser.class).execute()) {
                    if (!user.getRoles().contains(role)) continue;
                    user.getRoles().remove(role);
                    CoreModelServiceHolder.get().save((Identifiable)user);
                }
                CoreModelServiceHolder.get().remove((Identifiable)role);
                UserManagementPreferencePage.this.updateRoles();
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public String getText() {
                return "Rolle entfernen";
            }

            public boolean isEnabled() {
                if (UserManagementPreferencePage.this.checkboxTableViewerRoles != null && UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection() != null && !UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().isEmpty()) {
                    return !((IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement()).isSystemRole();
                }
                return false;
            }
        });
        rolePopManager.add((IAction)new Action(){

            public void run() {
                File file;
                FileDialog dialog = new FileDialog(UserManagementPreferencePage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.json"});
                if (dialog.open() != null && (file = new File(dialog.getFilterPath() + File.separator + dialog.getFileName())).exists()) {
                    try {
                        String jsonContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                        Optional acl = AccessControlServiceHolder.get().readAccessControlList((InputStream)new ByteArrayInputStream(jsonContent.getBytes("UTF-8")));
                        if (acl.isPresent()) {
                            IRole role = (IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement();
                            role.setExtInfo((Object)"json", (Object)jsonContent);
                            CoreModelServiceHolder.get().save((Identifiable)role);
                            UserManagementPreferencePage.this.updateRoles();
                        } else {
                            MessageDialog.openError((Shell)UserManagementPreferencePage.this.getShell(), (String)"Fehler", (String)"Fehlerhafter Berechtigungs Definition");
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error reading json file", (Throwable)e);
                    }
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_IMPORT.getImageDescriptor();
            }

            public String getText() {
                return "Berechtigungen importieren";
            }

            public boolean isEnabled() {
                if (UserManagementPreferencePage.this.checkboxTableViewerRoles != null && UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection() != null && !UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().isEmpty()) {
                    return !((IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement()).isSystemRole();
                }
                return false;
            }
        });
        rolePopManager.add((IAction)new Action(){

            public void run() {
                IRole role = (IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement();
                String jsonString = (String)role.getExtInfo((Object)"json");
                if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                    FileDialog dialog = new FileDialog(UserManagementPreferencePage.this.getShell(), 8192);
                    if (dialog.open() != null) {
                        File file = new File(dialog.getFilterPath() + File.separator + dialog.getFileName());
                        try {
                            FileUtils.writeStringToFile((File)file, (String)jsonString, (String)"UTF-8");
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing json file", (Throwable)e);
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)UserManagementPreferencePage.this.getShell(), (String)"Fehler", (String)"Die Rolle hat keine Berechtigungs Definition");
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EXPORT.getImageDescriptor();
            }

            public String getText() {
                return "Berechtigungen exportieren";
            }

            public boolean isEnabled() {
                if (UserManagementPreferencePage.this.checkboxTableViewerRoles != null && UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection() != null && !UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().isEmpty()) {
                    return !((IRole)UserManagementPreferencePage.this.checkboxTableViewerRoles.getStructuredSelection().getFirstElement()).isSystemRole();
                }
                return false;
            }
        });
        this.checkboxTableViewerRoles = CheckboxTableViewer.newCheckList((Composite)compositeRoles, (int)67584);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        this.checkboxTableViewerRoles.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerRoles.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                StringBuilder sb = new StringBuilder();
                IRole r = (IRole)element;
                sb.append(r.getId());
                if (!r.isSystemRole()) {
                    sb.append(" *");
                    String jsonString = (String)r.getExtInfo((Object)"json");
                    if (StringUtils.isEmpty((CharSequence)jsonString)) {
                        sb.append(" (leer)");
                    }
                }
                return sb.toString();
            }
        });
        this.checkboxTableViewerRoles.addCheckStateListener(e -> {
            IRole r = (IRole)e.getElement();
            if (r == null) {
                return;
            }
            IUser user = (IUser)this.wvUser.getValue();
            if (e.getChecked()) {
                user.addRole(r);
            } else {
                user.removeRole(r);
            }
            CoreModelServiceHolder.get().save((Identifiable)user);
        });
        Menu roleContextmenu = rolePopManager.createContextMenu(this.checkboxTableViewerRoles.getControl());
        this.checkboxTableViewerRoles.getControl().setMenu(roleContextmenu);
        rolePopManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] iContributionItemArray = manager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.update();
                    ++n2;
                }
            }
        });
        this.checkboxTableViewerAssociation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerAssociation.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                IMandator stdWorkingFor = null;
                IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
                if (user != null && user.getAssignedContact() != null) {
                    stdWorkingFor = UserServiceHolder.get().getDefaultExecutiveDoctorWorkingFor(user).orElse(null);
                }
                IMandator m = (IMandator)element;
                StringBuilder sb = new StringBuilder();
                if (m.equals(stdWorkingFor)) {
                    sb.append("* ");
                }
                sb.append(m.getDescription1() + " " + m.getDescription2());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{m.getDescription3()})) {
                    sb.append(" (").append(m.getDescription3()).append(")");
                }
                return sb.toString();
            }
        });
        this.checkboxTableViewerAssociation.setComparator((ViewerComparator)new MandantViewerComparator((Viewer)this.checkboxTableViewerAssociation));
        this.updateRoles();
        this.updateAssociations();
        this.initDataBindings();
        this.wvUser.addValueChangeListener((IValueChangeListener)new ValueChangedAdapter());
        this.updateUserList();
        this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
        sash.setWeights(new int[]{1, 5});
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void updateUserList() {
        List users = CoreModelServiceHolder.get().getQuery(IUser.class).execute();
        if (this.isShowOnlyActive) {
            users = users.stream().filter(IUser::isActive).collect(Collectors.toList());
        }
        users.sort(Comparator.comparing(Identifiable::getLabel));
        this.tableViewerUsers.setInput(users);
    }

    private void checkUserGroups() {
        List<CheckboxTableViewer> tableViewers = List.of(this.checkboxTableViewerAssociation, this.checkboxTableViewerRoles);
        boolean hasUserGroups = !this.userGroups.isEmpty();
        tableViewers.forEach(tableViewer -> {
            Table table = tableViewer.getTable();
            if (hasUserGroups) {
                this.setMessage("Der Benutzer ist in Gruppe(n) " + this.userGroups.stream().map(ug -> ug.getGroupname()).collect(Collectors.joining(",")) + ". Es werden die Mandanten und Rollen der Gruppe verwendet.", 2);
                table.getParent().setEnabled(false);
                table.setBackground(table.getDisplay().getSystemColor(38));
                table.setForeground(table.getDisplay().getSystemColor(16));
            } else {
                this.setMessage(null, 2);
                table.getParent().setEnabled(true);
                table.setBackground(table.getDisplay().getSystemColor(1));
                table.setForeground(table.getDisplay().getSystemColor(2));
            }
        });
    }

    private void updateRoles() {
        List roles = CoreModelServiceHolder.get().getQuery(IRole.class).execute();
        this.checkboxTableViewerRoles.setInput((Object)roles);
    }

    private void resetAll() {
        this.tableViewerUsers.setSelection((ISelection)StructuredSelection.EMPTY);
        this.wvUser.setValue(null);
        this.wvUserContact.setValue(null);
        this.updateRoles();
        this.updateAssociations();
        this.checkboxTableViewerRoles.setCheckedElements((Object[])new IRole[0]);
        this.checkboxTableViewerAssociation.setCheckedElements((Object[])new IMandator[0]);
        this.btnIsExecutiveDoctor.setSelection(false);
        this.btnUserIsLocked.setSelection(false);
        Link[] linkArray = new Link[]{this.linkContact, this.linkRechnungssteller};
        int n = linkArray.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            link.setText("");
            ++n2;
        }
        this.lblRespPhysColor.setBackground(this.lblRespPhysColorDefColor);
        this.userInfoLabel.setText("");
    }

    private void updateAssociations() {
        this.checkboxTableViewerAssociation.setInput((Object)CoreModelServiceHolder.get().getQuery(IMandator.class).execute());
        this.checkboxTableViewerAssociation.setCheckedElements((Object[])new IMandator[0]);
        List allMandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        if (this.isShowOnlyActive) {
            List activeUsers = CoreModelServiceHolder.get().getQuery(IUser.class).and((EStructuralFeature)ModelPackage.Literals.IMANDATOR__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)true).execute();
            allMandators = activeUsers.stream().map(IUser::getAssignedContact).filter(Objects::nonNull).map(contact -> CoreModelServiceHolder.get().load(contact.getId(), IMandator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        this.checkboxTableViewerAssociation.setInput(null);
        this.checkboxTableViewerAssociation.setInput((Object)allMandators);
        this.checkboxTableViewerAssociation.refresh();
        this.compositeAssociation.redraw();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeSelectionBtnIsAdminObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnUserIsAdmin);
        IObservableValue wvAdminObserveDetailValue = PojoProperties.value(IUser.class, (String)"administrator", Boolean.class).observeDetail(this.wvUser);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnIsAdminObserveWidget, wvAdminObserveDetailValue, new SavingUpdateValueStrategy(CoreModelServiceHolder.get(), (IObservableValue<?>)this.wvUser), null);
        ISWTObservableValue observeSelectionBtnIsActiveObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnUserIsLocked);
        IObservableValue wvActiveObserveDetailValue = PojoProperties.value(IUser.class, (String)"active", Boolean.class).observeDetail(this.wvUser);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnIsActiveObserveWidget, wvActiveObserveDetailValue, new SavingUpdateValueStrategy(CoreModelServiceHolder.get(), (IObservableValue<?>)this.wvUser).setConverter((IConverter)new BooleanNotConverter()), new UpdateValueStrategy().setConverter((IConverter)new BooleanNotConverter()));
        return bindingContext;
    }

    protected void performApply() {
        this.releaseLockIfRequired();
        super.performApply();
    }

    public boolean performOk() {
        this.releaseLockIfRequired();
        return super.performOk();
    }

    public boolean performCancel() {
        this.releaseLockIfRequired();
        return super.performCancel();
    }

    private void releaseLockIfRequired() {
        IUser user = (IUser)this.wvUser.getValue();
        if (user != null && LocalLockServiceHolder.get().isLocked((Object)user)) {
            LocalLockServiceHolder.get().releaseLock((Object)user);
        }
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.btnIsExecutiveDoctor.setEnabled(unlocked);
        this.linkChangePassword.setEnabled(unlocked);
        this.linkContact.setEnabled(unlocked);
        this.linkRechnungssteller.setEnabled(unlocked);
        this.btnUserIsAdmin.setEnabled(unlocked);
        this.btnUserIsLocked.setEnabled(unlocked);
        this.checkboxTableViewerAssociation.getTable().setEnabled(unlocked);
        this.checkboxTableViewerRoles.getTable().setEnabled(unlocked);
        this.lblRespPhysColor.setEnabled(unlocked);
    }

    private class AnwenderCellLabelProvider
    extends CellLabelProvider {
        private AnwenderCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            IUser user = (IUser)cell.getElement();
            cell.setText(user.getLabel());
            IContact ac = user.getAssignedContact();
            if (ac != null) {
                Optional mandator = CoreModelServiceHolder.get().load(ac.getId(), IMandator.class);
                if (mandator.isPresent()) {
                    Color mc = UiMandant.getColorForMandator(Mandant.load((String)((IMandator)mandator.get()).getId()));
                    cell.setImage(MandantSelectionContributionItem.getBoxSWTColorImage(mc));
                } else {
                    cell.setImage(Images.IMG_EMPTY_TRANSPARENT.getImage());
                }
            }
            if (user.isAdministrator()) {
                cell.setForeground(UiDesk.getColor("rot"));
                cell.setImage(Images.IMG_AUSRUFEZ.getImage());
            }
        }
    }

    public class MandantViewerComparator
    extends ViewerComparator {
        public MandantViewerComparator(Viewer viewer) {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IMandator m1 = (IMandator)o1;
            IMandator m2 = (IMandator)o2;
            return m1.getDescription1().compareToIgnoreCase(m2.getDescription1());
        }
    }

    private class ValueChangedAdapter
    implements IValueChangeListener<IUser> {
        private ValueChangedAdapter() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Optional mandator;
            IUser user = (IUser)UserManagementPreferencePage.this.wvUser.getValue();
            if (user == null) {
                UserManagementPreferencePage.this.wvUserContact.setValue(null);
                return;
            }
            UserManagementPreferencePage.this.setErrorMessage(null);
            IContact anw = user.getAssignedContact();
            UserManagementPreferencePage.this.wvUserContact.setValue((Object)anw);
            String text = anw != null ? anw.getLabel() : "Nicht gesetzt";
            UserManagementPreferencePage.this.linkContact.setText(text + " <a>\u00e4ndern</a>");
            UserManagementPreferencePage.this.userInfoLabel.setText(text + " [" + user.getId() + "]");
            UserManagementPreferencePage.this.updateRoles();
            Object[] assignedRoles = UserServiceHolder.get().getUserRoles(user).toArray();
            UserManagementPreferencePage.this.checkboxTableViewerRoles.setCheckedElements(assignedRoles);
            UserManagementPreferencePage.this.updateAssociations();
            UserManagementPreferencePage.this.userGroups = UserServiceHolder.get().getUserGroups(user);
            UserManagementPreferencePage.this.checkUserGroups();
            if (anw != null) {
                mandator = CoreModelServiceHolder.get().load(anw.getId(), IMandator.class);
                if (mandator.isPresent()) {
                    UserManagementPreferencePage.this.btnMandatorIsInactive.setSelection(!((IMandator)mandator.get()).isActive());
                }
                UserManagementPreferencePage.this.btnIsExecutiveDoctor.setSelection(mandator.isPresent());
                UserManagementPreferencePage.this.btnMandatorIsInactive.setEnabled(mandator.isPresent());
            }
            UserManagementPreferencePage.this.linkRechnungssteller.setText("- <a>\u00e4ndern</a>");
            UserManagementPreferencePage.this.lblRespPhysColor.setBackground(UserManagementPreferencePage.this.lblRespPhysColorDefColor);
            if (anw != null) {
                UserManagementPreferencePage.this.checkboxTableViewerAssociation.setCheckedElements(UserServiceHolder.get().getExecutiveDoctorsWorkingFor(user, true).toArray());
                mandator = CoreModelServiceHolder.get().load(anw.getId(), IMandator.class);
                if (mandator.isPresent()) {
                    Color color = UiMandant.getColorForMandator(Mandant.load((String)((IMandator)mandator.get()).getId()));
                    UserManagementPreferencePage.this.lblRespPhysColor.setBackground(color);
                    IContact rs = ((IMandator)mandator.get()).getBiller();
                    String rst = rs != null ? rs.getLabel() : "Nicht gesetzt";
                    UserManagementPreferencePage.this.linkRechnungssteller.setText(rst + " <a>\u00e4ndern</a>");
                }
            }
        }
    }
}

