/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.exchange.Messages;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ServiceBlockElement;
import ch.elexis.core.ui.exchange.elements.ServiceBlocksElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import java.io.FileOutputStream;
import org.eclipse.swt.widgets.FileDialog;
import org.jdom2.Content;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BlockExporter
extends XChangeExporter {
    ServiceBlocksElement lbs;

    @Override
    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return clazz.equals(Leistungsblock.class);
    }

    @Override
    public void finalizeExport() throws XChangeException {
        FileDialog fd = new FileDialog(UiDesk.getTopShell(), 8192);
        fd.setText(Messages.BlockContainer_Blockbeschreibung);
        fd.setFilterExtensions(new String[]{"*.xchange"});
        fd.setFilterNames(new String[]{Messages.BlockContainer_xchangefiles});
        String filename = fd.open();
        if (filename != null) {
            Format format = Format.getPrettyFormat();
            format.setEncoding("utf-8");
            XMLOutputter xmlo = new XMLOutputter(format);
            String xmlAspect = xmlo.outputString(this.getDocument());
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                fos.write(xmlAspect.getBytes());
                fos.close();
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                throw new XChangeException("Output failed " + ex.getMessage());
            }
        }
    }

    @Override
    public XChangeElement store(Object output) throws XChangeException {
        if (this.lbs == null) {
            this.lbs = (ServiceBlocksElement)new ServiceBlocksElement().asExporter(this);
            this.getContainer().getRoot().addContent((Content)this.lbs.getElement());
        }
        if (output instanceof Leistungsblock) {
            ServiceBlockElement sbe = new ServiceBlockElement().asExporter(this, (Leistungsblock)output);
            this.lbs.add(sbe);
            return sbe;
        }
        throw new XChangeException("Can't handle object type " + output.getClass().getName());
    }
}

