/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.dialogs.controls.ReminderVisibilityAndPopupComposite;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.Reminder;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ReminderDetailDialog
extends TitleAreaDialog {
    private static final String TX_ALL = Messages.Core_All;
    private Reminder reminder = null;
    private Patient patient = null;
    private Priority priority = Priority.MEDIUM;
    private ProcessStatus processStatus = ProcessStatus.OPEN;
    private Type actionType = Type.COMMON;
    private TimeTool dateDue = null;
    private List responsibles = Collections.singletonList(CoreHub.getLoggedInContact());
    private Text txtSubject;
    private Text txtDescription;
    private DatePickerCombo dateDuePicker;
    private Label lblRelatedPatient;
    private Button[] btnProcessStatus = new Button[4];
    private ComboViewer cvActionType;
    private Button btnNotPatientRelated;
    private ListViewer lvResponsible;
    private ReminderVisibilityAndPopupComposite rvapc;
    private ComboViewer cvPriority;
    private Button btnHasDueDate;
    private Composite dueComposite;
    private TimeTool defaultDate = null;

    public ReminderDetailDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2288);
    }

    public ReminderDetailDialog(Shell parentShell, Reminder reminder) {
        this(parentShell);
        this.reminder = reminder;
    }

    public ReminderDetailDialog(Shell parentShell, TimeTool defaultDate) {
        this(parentShell);
        this.defaultDate = defaultDate;
    }

    public void create() {
        super.create();
        Object shelltitle = Messages.EditReminderDialog_reminderShellTitle;
        if (this.reminder == null) {
            this.setTitle(Messages.EditReminderDialog_createReminder);
        } else {
            this.setTitle(Messages.EditReminderDialog_editReminder);
            Anwender o = this.reminder.getCreator();
            shelltitle = o == null ? (String)shelltitle + Messages.EditReminderDialog_unknown : (String)shelltitle + " (" + o.getLabel() + ")";
        }
        this.getShell().setText((String)shelltitle);
        this.setMessage(Messages.EditReminderDialog_enterDataForReminder);
        this.setTitleImage(Images.lookupImage((String)"tick_banner.png", (ImageSize)ImageSize._75x66_TitleDialogIconSize));
    }

    private void setViewerUserInput() {
        ArrayList<String> inputList = new ArrayList<String>();
        inputList.add(TX_ALL);
        inputList.addAll(this.getUsers());
        this.lvResponsible.setInput(inputList);
        this.lvResponsible.refresh();
    }

    private void setViewerGroupInput() {
        this.lvResponsible.setInput(this.getUserGroups());
        this.lvResponsible.refresh();
    }

    private List<IUserGroup> getUserGroups() {
        List userGroups = CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute();
        userGroups.sort((u1, u2) -> u1.getLabel().compareTo(u2.getLabel()));
        return userGroups;
    }

    private List<Anwender> getUsers() {
        IQuery userQuery = CoreModelServiceHolder.get().getQuery(IUser.class);
        userQuery.and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null);
        List users = userQuery.execute();
        return users.stream().filter(u -> this.isActive((IUser)u)).map(u -> Anwender.load((String)u.getAssignedContact().getId())).collect(Collectors.toList());
    }

    private boolean isActive(IUser user) {
        IMandator mandator;
        if (user == null || user.getAssignedContact() == null) {
            return false;
        }
        if (!user.isActive()) {
            return false;
        }
        return user.getAssignedContact() == null || !user.getAssignedContact().isMandator() || (mandator = (IMandator)CoreModelServiceHolder.get().load(user.getAssignedContact().getId(), IMandator.class).orElse(null)) == null || mandator.isActive();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite compositeResponsible = new Composite(container, 0);
        compositeResponsible.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        compositeResponsible.setBounds(0, 0, 64, 64);
        GridLayout gl_compositeResponsible = new GridLayout(1, false);
        gl_compositeResponsible.horizontalSpacing = 0;
        gl_compositeResponsible.marginTop = 2;
        gl_compositeResponsible.marginWidth = 0;
        gl_compositeResponsible.marginHeight = 0;
        compositeResponsible.setLayout((Layout)gl_compositeResponsible);
        Label lblResponsible = new Label(compositeResponsible, 0);
        lblResponsible.setText(Messages.EditReminderDialog_assigTo);
        final Button groupBtn = new Button(compositeResponsible, 32);
        groupBtn.setText(" Gruppe");
        groupBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (groupBtn.getSelection()) {
                    ReminderDetailDialog.this.setViewerGroupInput();
                } else {
                    ReminderDetailDialog.this.setViewerUserInput();
                }
            }
        });
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent = 4;
        groupBtn.setLayoutData((Object)gd);
        this.lvResponsible = new ListViewer(compositeResponsible, 2562);
        GridData gd_listResponsible = new GridData(4, 4, true, true, 1, 1);
        gd_listResponsible.heightHint = 150;
        gd_listResponsible.verticalIndent = 5;
        this.lvResponsible.getList().setLayoutData((Object)gd_listResponsible);
        this.lvResponsible.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lvResponsible.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Anwender) {
                    Anwender anw = (Anwender)element;
                    return anw.getLabel();
                }
                if (element instanceof IUserGroup) {
                    return ((IUserGroup)element).getGroupname();
                }
                return element.toString();
            }
        });
        this.lvResponsible.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof String) {
                    return -1;
                }
                if (e2 instanceof String) {
                    return 1;
                }
                if (e1 instanceof Anwender && e2 instanceof Anwender) {
                    String label1 = ((Anwender)e1).getLabel();
                    String label2 = ((Anwender)e2).getLabel();
                    return label1.toLowerCase().compareTo(label2.toLowerCase());
                }
                if (e1 instanceof IUserGroup && e2 instanceof IUserGroup) {
                    IUserGroup ug1 = (IUserGroup)e1;
                    IUserGroup ug2 = (IUserGroup)e2;
                    return String.CASE_INSENSITIVE_ORDER.compare(ug1.getGroupname(), ug2.getGroupname());
                }
                return 0;
            }
        });
        this.lvResponsible.addSelectionChangedListener(sc -> {
            this.responsibles = ((StructuredSelection)sc.getSelection()).toList();
            ArrayList<String> responisbleIds = new ArrayList<String>();
            for (Object responsible : this.responsibles) {
                if (responsible instanceof Anwender) {
                    responisbleIds.add(((Anwender)responsible).getId());
                    continue;
                }
                if (responsible instanceof IUserGroup) {
                    List users = ((IUserGroup)responsible).getUsers();
                    for (IUser user : users) {
                        if (user.getAssignedContact() == null) continue;
                        responisbleIds.add(user.getAssignedContact().getId());
                    }
                    continue;
                }
                responisbleIds.add(responsible.toString());
            }
            boolean defaultResponsibleSelf = ConfigServiceHolder.getUser((String)"reminder/defaultResponsibleSelf", (boolean)false);
            if (!defaultResponsibleSelf) {
                ConfigServiceHolder.setUserAsList((String)"reminder/defaultSelectedResponsibles", responisbleIds);
            }
        });
        this.setViewerUserInput();
        Composite compositeMessage = new Composite(container, 0);
        GridLayout gl_compositeMessage = new GridLayout(1, false);
        gl_compositeMessage.marginWidth = 0;
        gl_compositeMessage.marginHeight = 0;
        compositeMessage.setLayout((Layout)gl_compositeMessage);
        compositeMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compositeMessage.setBounds(0, 0, 64, 64);
        Composite compositeMessageHead = new Composite(compositeMessage, 0);
        compositeMessageHead.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeMessageHead.setBounds(0, 0, 64, 64);
        GridLayout gl_compositeMessageHead = new GridLayout(2, false);
        gl_compositeMessageHead.marginWidth = 0;
        gl_compositeMessageHead.marginHeight = 0;
        compositeMessageHead.setLayout((Layout)gl_compositeMessageHead);
        this.lblRelatedPatient = new Label(compositeMessageHead, 0);
        this.lblRelatedPatient.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNotPatientRelated = new Button(compositeMessageHead, 32);
        this.btnNotPatientRelated.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnNotPatientRelated.setText(Messages.EditReminderDialog_noPatient);
        this.btnNotPatientRelated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReminderDetailDialog.this.btnNotPatientRelated.getSelection()) {
                    ReminderDetailDialog.this.lblRelatedPatient.setText(Messages.EditReminderDialog_noPatient);
                    ReminderDetailDialog.this.patient = null;
                } else {
                    ReminderDetailDialog.this.patient = ElexisEventDispatcher.getSelectedPatient();
                    if (ReminderDetailDialog.this.patient == null) {
                        ReminderDetailDialog.this.lblRelatedPatient.setText(Messages.Core_No_patient_selected);
                        ReminderDetailDialog.this.btnNotPatientRelated.setSelection(true);
                    }
                }
                ReminderDetailDialog.this.rvapc.setConfiguredVisibility(null, ReminderDetailDialog.this.patient != null);
                ReminderDetailDialog.this.updateModelToTarget();
                super.widgetSelected(e);
            }
        });
        this.txtSubject = new Text(compositeMessage, 2048);
        this.txtSubject.setMessage(Messages.Core_Subject);
        this.txtSubject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSubject.setTextLimit(160);
        this.txtSubject.setFocus();
        this.txtDescription = new Text(compositeMessage, 2112);
        this.txtDescription.setMessage(Messages.Core_Description);
        this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtDescription.setBounds(0, 0, 64, 19);
        Composite composite = new Composite(compositeMessage, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.verticalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.rvapc = new ReminderVisibilityAndPopupComposite(composite, 0);
        this.rvapc.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(composite, 0);
        Group compositeState = new Group(container, 32);
        compositeState.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        RowLayout rl_compState = new RowLayout(256);
        rl_compState.marginTop = 0;
        rl_compState.marginBottom = 0;
        compositeState.setLayout((Layout)rl_compState);
        SelectionAdapter processStatusListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReminderDetailDialog.this.processStatus = (ProcessStatus)((Button)e.widget).getData();
            }
        };
        Button btnOpen = new Button((Composite)compositeState, 16);
        btnOpen.setText(ProcessStatus.OPEN.getLocaleText());
        btnOpen.setData((Object)ProcessStatus.OPEN);
        btnOpen.addSelectionListener((SelectionListener)processStatusListener);
        this.btnProcessStatus[0] = btnOpen;
        Button btnInProgress = new Button((Composite)compositeState, 16);
        btnInProgress.setText(ProcessStatus.IN_PROGRESS.getLocaleText());
        btnInProgress.setData((Object)ProcessStatus.IN_PROGRESS);
        btnInProgress.addSelectionListener((SelectionListener)processStatusListener);
        this.btnProcessStatus[1] = btnInProgress;
        Button btnClosed = new Button((Composite)compositeState, 16);
        btnClosed.setText(ProcessStatus.CLOSED.getLocaleText());
        btnClosed.setData((Object)ProcessStatus.CLOSED);
        btnClosed.addSelectionListener((SelectionListener)processStatusListener);
        this.btnProcessStatus[2] = btnClosed;
        Button btnOnHold = new Button((Composite)compositeState, 16);
        btnOnHold.setText(ProcessStatus.ON_HOLD.getLocaleText());
        btnOnHold.setData((Object)ProcessStatus.ON_HOLD);
        btnOnHold.addSelectionListener((SelectionListener)processStatusListener);
        this.btnProcessStatus[3] = btnOnHold;
        Label separator = new Label((Composite)compositeState, 514);
        separator.setLayoutData((Object)new RowData(25, 20));
        this.dueComposite = new Composite((Composite)compositeState, 0);
        GridLayout gl_dueComposite = new GridLayout(2, false);
        gl_dueComposite.horizontalSpacing = 0;
        gl_dueComposite.marginWidth = 0;
        gl_dueComposite.verticalSpacing = 0;
        gl_dueComposite.marginHeight = 0;
        this.dueComposite.setLayout((Layout)gl_dueComposite);
        this.dateDue = this.defaultDate != null ? this.defaultDate : new TimeTool();
        this.btnHasDueDate = new Button(this.dueComposite, 32);
        this.btnHasDueDate.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnHasDueDate.setText(Messages.EditReminderDialog_dueOn);
        this.btnHasDueDate.setSelection(true);
        this.btnHasDueDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReminderDetailDialog.this.btnHasDueDate.getSelection()) {
                    ReminderDetailDialog.this.dateDue = new TimeTool();
                    ReminderDetailDialog.this.dateDuePicker.setDate(ReminderDetailDialog.this.dateDue.getTime());
                } else {
                    ReminderDetailDialog.this.dateDuePicker.setDate(null);
                    ReminderDetailDialog.this.dateDue = null;
                }
                ReminderDetailDialog.this.dateDuePicker.setEnabled(ReminderDetailDialog.this.btnHasDueDate.getSelection());
                ReminderDetailDialog.this.updateModelToTarget();
            }
        });
        this.dateDuePicker = new DatePickerCombo(this.dueComposite, 2048);
        this.dateDuePicker.setLayoutData(new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.dateDuePicker.setEnabled(true);
        this.dateDuePicker.setDate(this.dateDue.getTime());
        this.dateDuePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReminderDetailDialog.this.dateDue = new TimeTool(ReminderDetailDialog.this.dateDuePicker.getDate().getTime());
            }
        });
        Label separator2 = new Label((Composite)compositeState, 514);
        separator2.setLayoutData((Object)new RowData(25, 20));
        this.cvPriority = new ComboViewer((Composite)compositeState, 4);
        this.cvPriority.getCombo().setLayoutData((Object)new RowData(130, -1));
        this.cvPriority.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvPriority.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Priority prio = (Priority)element;
                return prio.getLocaleText();
            }
        });
        this.cvPriority.setInput((Object)Priority.values());
        this.cvPriority.addSelectionChangedListener(s -> {
            this.priority = (Priority)((StructuredSelection)s.getSelection()).getFirstElement();
        });
        Composite compositeSettings = new Composite(container, 2048);
        compositeSettings.setLayout((Layout)new GridLayout(2, false));
        compositeSettings.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label labelAction = new Label(compositeSettings, 0);
        labelAction.setText(Messages.ReminderDetailDialog_labelAction_text);
        this.cvActionType = new ComboViewer(compositeSettings, 0);
        Combo comboActionType = this.cvActionType.getCombo();
        comboActionType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvActionType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvActionType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Type at = (Type)element;
                return at.getLocaleText();
            }
        });
        this.cvActionType.setInput((Object)Type.values());
        this.cvActionType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReminderDetailDialog.this.actionType = (Type)((StructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.initialize();
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private void initialize() {
        if (this.reminder == null) {
            this.patient = ElexisEventDispatcher.getSelectedPatient();
        } else {
            this.patient = this.reminder.getKontakt();
            this.dateDue = this.reminder.getDateDue();
            this.priority = this.reminder.getPriority();
            this.processStatus = this.reminder.getProcessStatus();
            if (ProcessStatus.DUE == this.processStatus || ProcessStatus.OVERDUE == this.processStatus) {
                this.processStatus = ProcessStatus.OPEN;
                if (this.dateDue == null) {
                    this.dateDue = new TimeTool();
                    this.dateDue.addDays(-14);
                }
            }
            this.actionType = this.reminder.getActionType();
            String[] strings = this.reminder.get(false, new String[]{"subject", "Message"});
            if (strings[0].length() == 0 && strings[1].length() > 0) {
                this.txtSubject.setText(strings[1]);
            } else {
                this.txtSubject.setText(this.reminder.getSubject());
            }
            this.txtDescription.setText(strings[1]);
            this.btnNotPatientRelated.setSelection(!this.reminder.isPatientRelated());
        }
        if (this.reminder != null) {
            this.rvapc.setConfiguredVisibility(this.reminder.getVisibility(), this.reminder.isPatientRelated() && this.patient != null);
        } else {
            this.rvapc.setConfiguredVisibility(null, this.patient != null);
        }
        this.updateModelToTarget();
    }

    private void updateModelToTarget() {
        if (this.reminder != null) {
            List resp = this.reminder.getResponsibles();
            this.responsibles = resp == null ? Collections.singletonList(TX_ALL) : resp;
        } else {
            boolean defaultResponsibleSelf = ConfigServiceHolder.getUser((String)"reminder/defaultResponsibleSelf", (boolean)false);
            if (defaultResponsibleSelf) {
                this.responsibles = Collections.singletonList(CoreHub.getLoggedInContact());
            } else {
                List defResponsibles = ConfigServiceHolder.getUserAsList((String)"reminder/defaultSelectedResponsibles");
                if (defResponsibles.isEmpty()) {
                    this.responsibles = Collections.singletonList(TX_ALL);
                } else {
                    ArrayList<String> defaultResponsibles = new ArrayList<String>();
                    Iterator iterator = defResponsibles.iterator();
                    while (iterator.hasNext()) {
                        String value;
                        String entry = value = (String)iterator.next();
                        if (!TX_ALL.equals(value)) {
                            entry = Anwender.load((String)value.toString());
                        }
                        defaultResponsibles.add(entry);
                    }
                    this.responsibles = defaultResponsibles;
                }
            }
        }
        this.lvResponsible.setSelection((ISelection)new StructuredSelection(this.responsibles));
        this.cvActionType.setSelection((ISelection)new StructuredSelection((Object)this.actionType));
        this.cvPriority.setSelection((ISelection)new StructuredSelection((Object)this.priority));
        this.dateDuePicker.setEnabled(this.dateDue != null);
        this.dateDuePicker.setDate(this.dateDue != null ? this.dateDue.getTime() : null);
        this.btnHasDueDate.setSelection(this.dateDue != null);
        if (this.patient != null) {
            if (this.reminder != null && this.reminder.getCreator() != null && this.patient.getId().equals(this.reminder.getCreator().getId())) {
                this.lblRelatedPatient.setText(Messages.EditReminderDialog_noPatient);
            } else {
                this.lblRelatedPatient.setText(this.patient.getLabel());
                this.lblRelatedPatient.setBackground(SWTResourceManager.getColor(0, 0, 0));
                this.lblRelatedPatient.setForeground(SWTResourceManager.getColor(255, 255, 255));
            }
        }
        this.btnNotPatientRelated.setSelection(this.patient == null);
        int dueState = Reminder.determineDueState((TimeTool)this.dateDue);
        if (dueState > 0) {
            this.btnHasDueDate.setBackground(UiDesk.getColor("rot"));
        } else {
            this.btnHasDueDate.setBackground(null);
        }
        int i = 0;
        while (i < this.btnProcessStatus.length) {
            this.btnProcessStatus[i].setSelection(this.btnProcessStatus[i].getData() == this.processStatus);
            if (dueState > 0) {
                if (this.btnProcessStatus[i].getData() == this.processStatus) {
                    this.btnProcessStatus[i].setForeground(UiDesk.getColor("rot"));
                } else {
                    this.btnProcessStatus[i].setForeground(UiDesk.getColor("schwarz"));
                }
            } else {
                this.btnProcessStatus[i].setForeground(UiDesk.getColor("schwarz"));
            }
            ++i;
        }
    }

    protected void okPressed() {
        if (this.txtSubject.getText().length() > 2) {
            this.setErrorMessage(null);
            this.performOk();
        } else {
            this.setErrorMessage("Es muss ein Betreff gesetzt sein.");
        }
    }

    private void performOk() {
        String due = null;
        if (this.btnHasDueDate.getSelection()) {
            due = this.dateDue.toString(4);
        }
        if (this.reminder == null) {
            this.reminder = new Reminder(null, due, Visibility.ALWAYS, "", "");
        }
        String contactId = this.btnNotPatientRelated.getSelection() ? this.reminder.getCreator().getId() : this.patient.getId();
        Visibility visibility = this.rvapc.getConfiguredVisibility();
        String[] fields = new String[]{"subject", "Message", "priority", "Status", "IdentID", "Typ", "Due", "actionType"};
        this.reminder.set(fields, new String[]{this.txtSubject.getText(), this.txtDescription.getText(), Integer.toString(this.priority.numericValue()), Integer.toString(this.processStatus.numericValue()), contactId, Integer.toString(visibility.numericValue()), due, Integer.toString(this.actionType.numericValue())});
        StructuredSelection ss = (StructuredSelection)this.lvResponsible.getSelection();
        this.reminder.setResponsible(this.getResponsible((IStructuredSelection)ss));
        super.okPressed();
    }

    private List<Anwender> getResponsible(IStructuredSelection selection) {
        if (!selection.toList().contains(TX_ALL)) {
            ArrayList<Anwender> ret = new ArrayList<Anwender>();
            for (Object selected : selection.toList()) {
                if (selected instanceof Anwender) {
                    ret.add((Anwender)selected);
                    continue;
                }
                if (!(selected instanceof IUserGroup)) continue;
                List users = ((IUserGroup)selected).getUsers();
                for (IUser user : users) {
                    if (user.getAssignedContact() == null) continue;
                    ret.add(Anwender.load((String)user.getAssignedContact().getId()));
                }
            }
            return ret;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public Reminder getReminder() {
        return this.reminder;
    }
}

