/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.MailTextTemplate;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.dialogs.AttachmentsComposite;
import ch.elexis.core.mail.ui.dialogs.MailAddressContentProposalProvider;
import ch.elexis.core.mail.ui.handlers.OutboxUtil;
import ch.elexis.core.mail.ui.preference.SerializableFile;
import ch.elexis.core.mail.ui.preference.SerializableFileUtil;
import ch.elexis.core.model.IBlobSecondary;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.documents.composites.DocumentsSelectionComposite;
import ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.data.Kontakt;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SendMailDialog
extends TitleAreaDialog {
    @Inject
    private ITextReplacementService textReplacement;
    private ComboViewer accountsViewer;
    private MailAccount account;
    private Text toText;
    private String toString = "";
    private Text ccText;
    private String ccString = "";
    private Text subjectText;
    private String subjectString = "";
    private Text textText;
    private String textString = "";
    private AttachmentsComposite attachments;
    private DocumentsSelectionComposite attachmentsSelection;
    private Button confidentialCheckbox;
    private String accountId;
    private String attachmentsString;
    private String documentsString;
    private boolean disableOutbox;
    private ComboViewer templatesViewer;
    private boolean doSend = true;
    private LocalDateTime sentTime;

    public SendMailDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        if (MailClientComponent.getMailClient() != null) {
            this.setTitle("E-Mail versenden");
        } else {
            this.setTitle("E-Mail versand nicht m\u00f6glich");
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        if (MailClientComponent.getMailClient() != null) {
            String defaultTemplateId;
            IMandator selectedMandant;
            Label lbl = new Label(container, 0);
            lbl.setText("Von");
            this.accountsViewer = new ComboViewer(container);
            this.accountsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.accountsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.accountsViewer.setInput(this.getSendMailAccounts());
            this.accountsViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (this.accountId != null) {
                this.accountsViewer.setSelection((ISelection)new StructuredSelection((Object)this.accountId));
            }
            lbl = new Label(container, 0);
            lbl.setText("An");
            this.toText = new Text(container, 2048);
            this.toText.setText(this.toString);
            this.toText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final ContentProposalAdapter toAddressProposalAdapter = new ContentProposalAdapter((Control)this.toText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new MailAddressContentProposalProvider(), null, null);
            this.toText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000002) {
                        toAddressProposalAdapter.openProposalPopup();
                    }
                    super.keyPressed(e);
                }
            });
            toAddressProposalAdapter.setProposalAcceptanceStyle(3);
            toAddressProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    if (proposal instanceof IdentifiableContentProposal) {
                        IdentifiableContentProposal identifiableContentProposal = (IdentifiableContentProposal)proposal;
                        IContact contact = (IContact)identifiableContentProposal.getIdentifiable();
                        int index = MailAddressContentProposalProvider.getLastAddressIndex(SendMailDialog.this.toText.getText());
                        StringBuilder sb = new StringBuilder();
                        if (index != 0) {
                            sb.append(SendMailDialog.this.toText.getText().substring(0, index)).append(", ").append(contact.getEmail());
                        } else {
                            sb.append(contact.getEmail());
                        }
                        SendMailDialog.this.toText.setText(sb.toString());
                        SendMailDialog.this.toText.setSelection(SendMailDialog.this.toText.getText().length());
                        SendMailDialog.this.attachments.setPostfix(SendMailDialog.this.toText.getText());
                        Display.getDefault().asyncExec(() -> toAddressProposalAdapter.closeProposalPopup());
                    }
                }
            });
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action("email zu Kontakt"){

                public void run() {
                    KontaktSelektor selector = new KontaktSelektor(SendMailDialog.this.getShell(), Kontakt.class, "Kontakt auswahl", "Kontakt f\u00fcr die E-Mail Adresse ausw\u00e4hlen", Kontakt.DEFAULT_SORT);
                    if (selector.open() == 0) {
                        Kontakt selected = (Kontakt)selector.getSelection();
                        selected.set("E-Mail", SendMailDialog.this.toText.getSelectionText());
                    }
                }

                public boolean isEnabled() {
                    String text = SendMailDialog.this.toText.getSelectionText();
                    return text != null && !text.isEmpty() && text.contains("@");
                }
            });
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    IContributionItem[] items;
                    IContributionItem[] iContributionItemArray = items = manager.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem iContributionItem = iContributionItemArray[n2];
                        iContributionItem.update();
                        ++n2;
                    }
                }
            });
            this.toText.setMenu(menuManager.createContextMenu((Control)this.toText));
            lbl = new Label(container, 0);
            lbl.setText("Cc");
            this.ccText = new Text(container, 2048);
            this.ccText.setText(this.ccString);
            this.ccText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final ContentProposalAdapter ccAddressProposalAdapter = new ContentProposalAdapter((Control)this.ccText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new MailAddressContentProposalProvider(), null, null);
            this.ccText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000002) {
                        ccAddressProposalAdapter.openProposalPopup();
                    }
                    super.keyPressed(e);
                }
            });
            ccAddressProposalAdapter.setProposalAcceptanceStyle(3);
            ccAddressProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    IdentifiableContentProposal identifiableContentProposal = (IdentifiableContentProposal)proposal;
                    IContact contact = (IContact)identifiableContentProposal.getIdentifiable();
                    int index = MailAddressContentProposalProvider.getLastAddressIndex(SendMailDialog.this.ccText.getText());
                    StringBuilder sb = new StringBuilder();
                    if (index != 0) {
                        sb.append(SendMailDialog.this.ccText.getText().substring(0, index)).append(", ").append(contact.getEmail());
                    } else {
                        sb.append(contact.getEmail());
                    }
                    SendMailDialog.this.ccText.setText(sb.toString());
                    SendMailDialog.this.ccText.setSelection(SendMailDialog.this.ccText.getText().length());
                    Display.getDefault().asyncExec(() -> ccAddressProposalAdapter.closeProposalPopup());
                }
            });
            menuManager = new MenuManager();
            menuManager.add((IAction)new Action("email zu Kontakt"){

                public void run() {
                    KontaktSelektor selector = new KontaktSelektor(SendMailDialog.this.getShell(), Kontakt.class, "Kontakt auswahl", "Kontakt f\u00fcr die E-Mail Adresse ausw\u00e4hlen", Kontakt.DEFAULT_SORT);
                    if (selector.open() == 0) {
                        Kontakt selected = (Kontakt)selector.getSelection();
                        selected.set("E-Mail", SendMailDialog.this.ccText.getSelectionText());
                    }
                }

                public boolean isEnabled() {
                    String text = SendMailDialog.this.ccText.getSelectionText();
                    return text != null && !text.isEmpty() && text.contains("@");
                }
            });
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    IContributionItem[] items;
                    IContributionItem[] iContributionItemArray = items = manager.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem iContributionItem = iContributionItemArray[n2];
                        iContributionItem.update();
                        ++n2;
                    }
                }
            });
            this.ccText.setMenu(menuManager.createContextMenu((Control)this.ccText));
            lbl = new Label(container, 0);
            lbl.setText("Betreff");
            this.subjectText = new Text(container, 2048);
            this.subjectText.setText(this.subjectString);
            this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lbl = new Label(container, 0);
            lbl.setText("Vertraulich");
            this.confidentialCheckbox = new Button(container, 32);
            this.getConfidentialCheckbox().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lbl = new Label(container, 0);
            lbl.setText("Vorlage");
            this.templatesViewer = new ComboViewer(container);
            this.templatesViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.templatesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.templatesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ITextTemplate) {
                        return ((ITextTemplate)element).getName() + (String)(((ITextTemplate)element).getMandator() != null ? " (" + ((ITextTemplate)element).getMandator().getLabel() + ")" : "");
                    }
                    return super.getText(element);
                }
            });
            ArrayList<String> templatesInput = new ArrayList<String>();
            templatesInput.add("Keine Vorlage");
            templatesInput.addAll(MailTextTemplate.load());
            this.templatesViewer.setInput(templatesInput);
            this.templatesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getStructuredSelection() != null && event.getStructuredSelection().getFirstElement() instanceof ITextTemplate) {
                        ITextTemplate selectedTemplate = (ITextTemplate)event.getStructuredSelection().getFirstElement();
                        SendMailDialog.this.setTemplateAttachments(selectedTemplate);
                        SendMailDialog.this.textText.setText(SendMailDialog.this.textReplacement.performReplacement(ContextServiceHolder.get().getRootContext(), selectedTemplate.getTemplate()));
                        if (selectedTemplate.getExtInfo((Object)"subject") != null) {
                            SendMailDialog.this.subjectText.setText((String)selectedTemplate.getExtInfo((Object)"subject") + " " + SendMailDialog.this.subjectString);
                        }
                    } else {
                        SendMailDialog.this.textText.setText("");
                    }
                    SendMailDialog.this.updateLayout();
                }
            });
            lbl = new Label(container, 0);
            lbl.setText("Text");
            this.textText = new Text(container, 2562);
            GridData gd = new GridData(4, 4, true, true);
            this.textText.setLayoutData((Object)gd);
            this.textText.setText(this.textString);
            this.attachments = new AttachmentsComposite(container, 0);
            this.attachments.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
            this.attachments.setAttachments(this.attachmentsString);
            this.attachments.setDocuments(this.documentsString);
            this.attachments.setPostfix(this.toString);
            lbl = new Label(container, 258);
            lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            lbl = new Label(container, 0);
            lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            lbl.setText("Dokument zum anh\u00e4ngen doppelklicken");
            final Text searchField = new Text(container, 2048);
            searchField.setMessage("Suche...");
            searchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            searchField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String searchText = searchField.getText();
                    SendMailDialog.this.attachmentsSelection.setFilter(searchText);
                }
            });
            this.attachmentsSelection = new DocumentsSelectionComposite(container, 0);
            this.attachmentsSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.attachmentsSelection.setPatient((IPatient)ContextServiceHolder.get().getActivePatient().orElse(null));
            this.attachmentsSelection.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty()) {
                        SendMailDialog.this.attachments.addDocument((IDocument)((IStructuredSelection)event.getSelection()).getFirstElement());
                    }
                }
            });
            if (!this.doSend) {
                lbl.setVisible(false);
                this.templatesViewer.getCombo().setVisible(false);
                this.attachments.setVisible(false);
                this.attachmentsSelection.setVisible(false);
            }
            if (this.accountId == null && (selectedMandant = (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null)) != null) {
                List list = MailClientComponent.getMailClient().getAccountsLocal();
                Optional<String> mandantAccount = list.stream().filter(aid -> MailClientComponent.getMailClient().getAccount(aid).isPresent()).filter(aid -> ((MailAccount)MailClientComponent.getMailClient().getAccount(aid).get()).isForMandant(selectedMandant.getId())).findFirst();
                if (!mandantAccount.isPresent()) {
                    List list2 = MailClientComponent.getMailClient().getAccounts();
                    mandantAccount = list2.stream().filter(aid -> MailClientComponent.getMailClient().getAccount(aid).isPresent()).filter(aid -> ((MailAccount)MailClientComponent.getMailClient().getAccount(aid).get()).isForMandant(selectedMandant.getId())).findFirst();
                }
                if (mandantAccount.isPresent()) {
                    this.accountsViewer.setSelection((ISelection)new StructuredSelection((Object)mandantAccount.get()));
                }
            }
            if ((defaultTemplateId = ConfigServiceHolder.get().get("mail/template/default", null)) != null && StringUtils.isEmpty((CharSequence)this.textText.getText())) {
                for (Object e : templatesInput) {
                    if (!(e instanceof ITextTemplate) || !((ITextTemplate)e).getId().equals(defaultTemplateId)) continue;
                    Display.getDefault().asyncExec(() -> this.templatesViewer.setSelection((ISelection)new StructuredSelection(object)));
                }
            }
            if (this.sentTime != null) {
                this.accountsViewer.getCombo().setEnabled(false);
                this.toText.setEditable(false);
                this.ccText.setEditable(false);
                this.subjectText.setEditable(false);
                this.templatesViewer.getCombo().setEnabled(false);
                this.textText.setEditable(false);
                this.attachments.setEnabled(false);
            }
        }
        this.updateLayout();
        return area;
    }

    public void setAttachments(String attachments) {
        this.attachments.setAttachments(attachments);
        this.getShell().layout(true, true);
    }

    public void setDocuments(String documents) {
        this.attachments.setDocuments(documents);
        this.getShell().layout(true, true);
    }

    public void setTo(String to) {
        if (to != null && !to.isEmpty()) {
            this.toString = to;
        }
    }

    public void setSubject(String subject) {
        if (subject != null && !subject.isEmpty()) {
            this.subjectString = subject;
        }
    }

    public void setText(String text) {
        if (text != null && !text.isEmpty()) {
            this.textString = text;
        }
        this.updateLayout();
    }

    public void doSend(boolean doSend) {
        this.doSend = doSend;
    }

    private List<String> getSendMailAccounts() {
        ArrayList<String> ret = new ArrayList<String>();
        List accounts = MailClientComponent.getMailClient().getAccountsLocal();
        ret.addAll(accounts.stream().filter(aid -> MailClientComponent.getMailClient().getAccount(aid).isPresent()).filter(aid -> ((MailAccount)MailClientComponent.getMailClient().getAccount(aid).get()).getType() == MailAccount.TYPE.SMTP).collect(Collectors.toList()));
        accounts = MailClientComponent.getMailClient().getAccounts();
        ret.addAll(accounts.stream().filter(aid -> MailClientComponent.getMailClient().getAccount(aid).isPresent()).filter(aid -> ((MailAccount)MailClientComponent.getMailClient().getAccount(aid).get()).getType() == MailAccount.TYPE.SMTP).collect(Collectors.toList()));
        return ret;
    }

    protected void okPressed() {
        String validation = this.getValidation();
        if (validation != null) {
            this.setErrorMessage(validation);
            return;
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button outboxBtn = this.createButton(parent, -1, "Outbox", false);
        super.createButtonsForButtonBar(parent);
        if (this.getButton(0) != null) {
            Button okButton = this.getButton(0);
            if (this.doSend) {
                okButton.setText("Senden");
            } else {
                okButton.setText(IDialogConstants.OK_LABEL);
            }
            if (this.sentTime != null) {
                this.setTitle("E-Mail Anzeige");
                this.setMessage("Diese E-Mail wurde versendet am " + this.sentTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                Control[] controlArray = parent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control instanceof Button) {
                        Button button = (Button)control;
                        ((GridData)button.getLayoutData()).exclude = true;
                        button.setVisible(false);
                    }
                    ++n2;
                }
            }
        }
        outboxBtn.setEnabled(!this.disableOutbox && OutboxUtil.isOutboxAvailable());
        outboxBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String validation = SendMailDialog.this.getValidation();
                if (validation != null) {
                    SendMailDialog.this.setErrorMessage(validation);
                    return;
                }
                SendMailDialog.this.setErrorMessage(null);
                this.createOutboxElement();
            }

            private void createOutboxElement() {
                MailMessage message = new MailMessage().to(SendMailDialog.this.getTo()).cc(SendMailDialog.this.getCc()).subject(SendMailDialog.this.getSubject()).text(SendMailDialog.this.getText());
                message.setAttachments(SendMailDialog.this.attachments.getAttachments());
                message.setDocuments(SendMailDialog.this.attachments.getDocuments());
                Optional descriptor = TaskUtil.createSendMailTaskDescriptor((String)SendMailDialog.this.account.getId(), (MailMessage)message);
                if (descriptor.isPresent()) {
                    OutboxUtil.getOrCreateElement((ITaskDescriptor)descriptor.get(), false);
                }
                SendMailDialog.this.cancelPressed();
            }
        });
        parent.layout();
    }

    private void setTemplateAttachments(ITextTemplate selectedTemplate) {
        IBlobSecondary textTemplate = CoreModelServiceHolder.get().load("TEXTTEMPLATE_" + selectedTemplate.getId(), IBlobSecondary.class).orElse(null);
        if (textTemplate != null) {
            byte[] DBArrayList = textTemplate.getContent();
            Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            ArrayList<String> attachmentPaths = new ArrayList<String>();
            try {
                List<SerializableFile> deserializedContent = SerializableFileUtil.deserializeData(DBArrayList);
                for (SerializableFile serializableFile : deserializedContent) {
                    Path tempFile = tempDir.resolve(serializableFile.getName());
                    if (!Files.exists(tempFile, new LinkOption[0])) {
                        Files.write(tempFile, serializableFile.getData(), new OpenOption[0]);
                        tempFile.toFile().deleteOnExit();
                    }
                    attachmentPaths.add(tempFile.toString());
                }
                this.attachments.setAttachments(String.join((CharSequence)":::", attachmentPaths));
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private String getValidation() {
        this.subjectString = this.getConfidentialCheckbox() != null && this.getConfidentialCheckbox().getSelection() ? this.subjectText.getText() + " (Vertraulich)" : this.subjectText.getText();
        StructuredSelection accountSelection = (StructuredSelection)this.accountsViewer.getSelection();
        if (accountSelection == null || accountSelection.isEmpty()) {
            return "Kein Konto ausgew\u00e4hlt.";
        }
        String accountId = (String)accountSelection.getFirstElement();
        Optional optionalAccount = MailClientComponent.getMailClient().getAccount(accountId);
        if (!optionalAccount.isPresent()) {
            return "Kein Konto ausgew\u00e4hlt.";
        }
        this.account = (MailAccount)optionalAccount.get();
        String to = this.toText.getText();
        if (to == null || to.isEmpty()) {
            return "Keine an E-Mail Adresse.";
        }
        this.toString = to;
        this.ccString = this.ccText.getText();
        this.textString = this.textText.getText();
        return null;
    }

    public String getTo() {
        return this.toString;
    }

    public String getCc() {
        return this.ccString;
    }

    public void setCc(String cc) {
        this.ccString = cc;
    }

    public String getSubject() {
        return this.subjectString;
    }

    public String getText() {
        return this.textString;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public MailAccount getAccount() {
        return this.account;
    }

    public String getAttachmentsString() {
        return this.attachments.getAttachments();
    }

    public String getDocumentsString() {
        return this.attachments.getDocuments();
    }

    public void setMailMessage(MailMessage message) {
        this.setTo(StringUtils.defaultString((String)message.getTo()));
        this.setCc(StringUtils.defaultString((String)message.getCc()));
        this.setSubject(StringUtils.defaultString((String)message.getSubject()));
        this.setText(StringUtils.defaultString((String)message.getText()));
        this.attachmentsString = message.getAttachmentsString();
        this.documentsString = message.getDocumentsString();
        this.updateLayout();
    }

    private void updateLayout() {
        if (this.textText != null && !this.textText.isDisposed()) {
            String[] lines;
            GridData gd = (GridData)this.textText.getLayoutData();
            String text = this.textText.getText();
            boolean defaultSet = false;
            if (StringUtils.isNotBlank((CharSequence)text) && (lines = text.split("\n")).length > 12) {
                defaultSet = true;
                gd.heightHint = -1;
            }
            if (!defaultSet) {
                gd.heightHint = 250;
            }
            if (this.getShell() != null && !this.getShell().isDisposed()) {
                this.getShell().layout();
            }
        }
    }

    public void disableOutbox() {
        this.disableOutbox = true;
    }

    public void setDocumentsString(String documents) {
        this.documentsString = documents;
    }

    public void setAttachmentsString(String attachments) {
        this.attachmentsString = attachments;
    }

    public void sent(LocalDateTime sentTime) {
        this.sentTime = sentTime;
    }

    public Boolean doSend() {
        return this.doSend;
    }

    public Button getConfidentialCheckbox() {
        return this.confidentialCheckbox;
    }
}

