/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.tester;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.TreeSelection;

public class DocumentsPropertyTester
extends PropertyTester {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("isMimeType".equals(property) && args != null && args.length == 1 && args[0] instanceof String) {
            if (receiver instanceof TreeSelection) {
                receiver = ((TreeSelection)receiver).getFirstElement();
            }
            if (!(receiver instanceof List)) return this.testIsMimeType(receiver, (String)args[0]);
            Iterator iterator = ((List)receiver).iterator();
            if (!iterator.hasNext()) return false;
            Object object = iterator.next();
            return this.testIsMimeType(object, (String)args[0]);
        }
        if (!"isExternFile".equals(property)) return false;
        if (receiver instanceof TreeSelection) {
            receiver = ((TreeSelection)receiver).getFirstElement();
        }
        if (!(receiver instanceof List)) return this.testIsExternFile(receiver);
        Iterator iterator = ((List)receiver).iterator();
        if (!iterator.hasNext()) return false;
        Object object = iterator.next();
        return this.testIsExternFile(object);
    }

    private boolean testIsMimeType(Object receiver, String mime) {
        if (receiver instanceof IDocument) {
            IDocument document = (IDocument)receiver;
            return document.getMimeType().toLowerCase().endsWith(mime);
        }
        return false;
    }

    private boolean testIsExternFile(Object receiver) {
        if (receiver instanceof IDocument) {
            IDocument document = (IDocument)receiver;
            if ("ch.elexis.data.store.brief".equals(document.getStoreId())) {
                return ConfigServiceHolder.getGlobal((String)"briefe/Textmodul_Extern_File", (boolean)false);
            }
            if ("ch.elexis.data.store.omnivore".equals(document.getStoreId())) {
                return this.isOmnivoreStoreInFilesystem();
            }
        }
        return false;
    }

    private boolean isOmnivoreStoreInFilesystem() {
        if (ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/store_in_fs_global", (boolean)false)) {
            return ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
        }
        return ConfigServiceHolder.getLocal((String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
    }
}

