/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.operations;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.officelayer.document.IDocumentService;
import ag.ion.noa.frame.ILayoutManager;
import ag.ion.noa4e.ui.operations.Messages;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.uno.UnoRuntime;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class LoadDocumentOperation
implements IRunnableWithProgress {
    private IOfficeApplication officeApplication = null;
    private IFrame frame = null;
    private IDocumentDescriptor documentDescriptor = null;
    private String documentType = null;
    private URL url = null;
    private InputStream inputStream = null;
    private boolean isSubTask = false;
    private boolean updateProgressMonitor = true;
    private boolean useStream = false;
    private InternalThread internalThread = null;

    public LoadDocumentOperation(IOfficeApplication officeApplication, IFrame frame, URL url, IDocumentDescriptor documentDescriptor) throws IllegalArgumentException {
        this(null, officeApplication, frame, url, documentDescriptor);
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, IFrame frame, URL url, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        this.officeApplication = officeApplication;
        this.frame = frame;
        this.url = url;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, URL url, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        this.officeApplication = officeApplication;
        this.url = url;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(String documentType, IOfficeApplication officeApplication, IFrame frame, InputStream inputStream, IDocumentDescriptor documentDescriptor) {
        assert (officeApplication != null);
        assert (inputStream != null);
        this.officeApplication = officeApplication;
        this.frame = frame;
        this.inputStream = inputStream;
        this.documentDescriptor = documentDescriptor;
        this.documentType = documentType;
    }

    public LoadDocumentOperation(IOfficeApplication officeApplication, InputStream inputStream, IDocumentDescriptor documentDescriptor) {
        this(null, officeApplication, null, inputStream, documentDescriptor);
    }

    public void setIsSubTask(boolean isSubTask) {
        this.isSubTask = isSubTask;
    }

    public void setUpdateProgressMonitor(boolean updateProgressMonitor) {
        this.updateProgressMonitor = updateProgressMonitor;
    }

    public void setUseStream(boolean useStream) {
        this.useStream = useStream;
    }

    public Exception getException() {
        return this.internalThread.getException();
    }

    public IDocument getDocument() {
        if (this.documentType == null) {
            return this.internalThread.getDocument();
        }
        IDocument document = this.internalThread.getDocument();
        if (document != null && document.getDocumentType().equals(this.documentType)) {
            return document;
        }
        return null;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        System.out.println("LoadDocumentOperation: run begins");
        System.out.println("LoadDocumentOperation: run 1");
        this.internalThread = new InternalThread();
        if (this.isSubTask) {
            if (this.updateProgressMonitor) {
                progressMonitor.subTask(Messages.LoadDocumentOperation_monitor_loading_document);
            }
        } else if (this.updateProgressMonitor) {
            progressMonitor.beginTask(Messages.LoadDocumentOperation_monitor_loading_document, 50);
        }
        System.out.println("LoadDocumentOperation: run 2");
        this.internalThread.start();
        System.out.println("LoadDocumentOperation: run 2.1");
        int cyclesWaitedForInternalThreadToComplete = 0;
        while (!this.internalThread.done()) {
            System.out.println("LoadDocumentOperation: run 2.2 sleep(500) begins");
            Thread.sleep(500L);
            System.out.println("LoadDocumentOperation: run 2.3 sleep(500) ends");
            if (!this.isSubTask) {
                progressMonitor.worked(1);
            }
            System.out.println("LoadDocumentOperation: run 2.4");
            if (progressMonitor.isCanceled()) {
                try {
                    System.out.println("LoadDocumentOperation: run 2.5");
                    this.internalThread.stop();
                }
                catch (Throwable throwable) {
                    System.out.println("LoadDocumentOperation: run 2.6");
                }
                System.out.println("LoadDocumentOperation: run 2.7");
                progressMonitor.done();
                System.out.println("LoadDocumentOperation: run 2.8 about to throw InterruptException()...");
                throw new InterruptedException(Messages.LoadDocumentOperation_exception_message_operation_interrupted);
            }
            if (++cyclesWaitedForInternalThreadToComplete <= 40) continue;
            cyclesWaitedForInternalThreadToComplete = 0;
            System.out.println("LoadDocumentOperation: ERROR: internalThread timed out; will now be destroyed.");
            System.out.println("WARNING: This functionality should NOT be used except for debugging - see intenalThread.destroy() help .");
            System.out.println("WARNING: Destroying the internalThread is not guaranteed to return Elexis into a responsive state.");
            System.out.println("WARNING: Neither can we guarantee that the document that was about to be opened will appear correctly.");
            System.out.println("WARNING: That said, however, it DID succeed in some tests (4/5), and made the desired document");
            System.out.println("WARNING: appear with LibreOffice in its desired frame, and even the problematic floating dialog windows");
            System.out.println("WARNING: in addition to that - for either the table properties, or the externally opened F11 Formatvorlagen.");
            System.out.println("WARNING: 201202252133js");
            Thread.sleep(500L);
        }
        System.out.println("LoadDocumentOperation: run 3 TO DO: Thread.sleep(3000) [WARNING: REMOVED SLEEP()], otherwise OO 3.x might crash (says comment in code)");
        System.out.println("LoadDocumentOperation: run 4 sleep ends");
        if (!this.isSubTask) {
            progressMonitor.done();
        }
        System.out.println("LoadDocumentOperation: run 5 done");
    }

    private class InternalThread
    extends Thread {
        private Exception exception = null;
        private IDocument document = null;
        private boolean done = false;

        private InternalThread() {
        }

        @Override
        public void run() {
            System.out.println("LoadDocumentOperation: InternalThread: run: begins");
            try {
                System.out.println("LoadDocumentOperation: InternalThread: run: Trying to do work...");
                if (LoadDocumentOperation.this.useStream || LoadDocumentOperation.this.inputStream != null) {
                    System.out.println("LoadDocumentOperation: InternalThread: run: useStream || inputStream != null");
                    InputStream inputStream = null;
                    inputStream = LoadDocumentOperation.this.inputStream != null ? LoadDocumentOperation.this.inputStream : LoadDocumentOperation.this.url.openStream();
                    this.document = LoadDocumentOperation.this.frame != null ? LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(LoadDocumentOperation.this.frame, inputStream, LoadDocumentOperation.this.documentDescriptor) : LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(inputStream, LoadDocumentOperation.this.documentDescriptor);
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                } else {
                    System.out.println("LoadDocumentOperation: InternalThread: run: NOT (useStream || inputStream != null)");
                    System.out.println("LoadDocumentOperation: InternalThread: run: Status before loadDocument()...");
                    if (LoadDocumentOperation.this.officeApplication == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication=" + LoadDocumentOperation.this.officeApplication.toString());
                    }
                    if (LoadDocumentOperation.this.url == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: url==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: url=" + LoadDocumentOperation.this.url.toString());
                    }
                    if (LoadDocumentOperation.this.frame == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: frame=" + LoadDocumentOperation.this.frame.toString());
                    }
                    if (LoadDocumentOperation.this.documentDescriptor == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: documentDescriptor=" + LoadDocumentOperation.this.documentDescriptor.toString());
                    }
                    System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication.getDesktopService()=" + LoadDocumentOperation.this.officeApplication.getDesktopService());
                    System.out.println("LoadDocumentOperation: InternalThread: run: officeApplication.getDesktopService().getFramesCount()=" + LoadDocumentOperation.this.officeApplication.getDesktopService().getFramesCount());
                    if (LoadDocumentOperation.this.frame != null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: MOVE THE disableDispatch and layoutManager stuff to a better place!");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: (Or maybe not - LayoutManager stuff only effective after the docLoad?)");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: (Maybe due to some \"Load settings with document...\" option, though.)");
                        System.out.println("LoadDocumentOperation: InternalThread: run: TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:NewDoc");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:CloseDoc");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Quit");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:HyperlinkDialog");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:EditHyperlink");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:InsertDraw");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Navigator");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:Gallery");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:ViewDataSourceBrowser");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:DesignerDialog");
                        LoadDocumentOperation.this.frame.disableDispatch(".uno:AutoPilotMenu");
                        LoadDocumentOperation.this.frame.updateDispatches();
                        ILayoutManager layoutManager = LoadDocumentOperation.this.frame.getLayoutManager();
                        layoutManager.hideAll();
                        XFrame xFrame = LoadDocumentOperation.this.frame.getXFrame();
                        XPropertySet xPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFrame);
                        XLayoutManager xLayoutManager = (XLayoutManager)UnoRuntime.queryInterface(XLayoutManager.class, (Object)xPropSet.getPropertyValue("LayoutManager"));
                        xLayoutManager.dockAllWindows((short)5);
                        xLayoutManager.dockAllWindows((short)3);
                        xLayoutManager.dockAllWindows((short)1);
                        xLayoutManager.dockAllWindows((short)2);
                        xLayoutManager.dockAllWindows((short)4);
                        xLayoutManager.dockAllWindows((short)6);
                        xLayoutManager.dockAllWindows((short)0);
                        System.out.println("LoadDocumentOperation: PRE");
                        IDocumentService documentService = LoadDocumentOperation.this.officeApplication.getDocumentService();
                        if (documentService == null) {
                            System.out.println("LoadDocumentOperation: officeApplication.getDocumentService()==null");
                        } else {
                            System.out.println("LoadDocumentOperation: officeApplication.getDocumentService()=" + LoadDocumentOperation.this.officeApplication.getDocumentService());
                            this.document = documentService.loadDocument(LoadDocumentOperation.this.frame, LoadDocumentOperation.this.url.toString(), LoadDocumentOperation.this.documentDescriptor);
                        }
                        System.out.println("LoadDocumentOperation: POST");
                        layoutManager.hideAll();
                        layoutManager.showElement("private:resource/menubar/menubar");
                        layoutManager.showElement("private:resource/statusbar/statusbar");
                        layoutManager.showElement("private:resource/toolbar/standardbar");
                        layoutManager.showElement("private:resource/toolbar/textobjectbar");
                        xLayoutManager.dockAllWindows((short)5);
                        xLayoutManager.dockAllWindows((short)3);
                        xLayoutManager.dockAllWindows((short)1);
                        xLayoutManager.dockAllWindows((short)2);
                        xLayoutManager.dockAllWindows((short)4);
                        xLayoutManager.dockAllWindows((short)6);
                        xLayoutManager.dockAllWindows((short)0);
                    } else {
                        this.document = LoadDocumentOperation.this.officeApplication.getDocumentService().loadDocument(LoadDocumentOperation.this.url.toString(), LoadDocumentOperation.this.documentDescriptor);
                    }
                    System.out.println("LoadDocumentOperation: InternalThread: run: Status after loadDocument()...");
                    if (this.document == null) {
                        System.out.println("LoadDocumentOperation: InternalThread: run: document==null");
                    } else {
                        System.out.println("LoadDocumentOperation: InternalThread: run: document=" + this.document.toString());
                    }
                }
                System.out.println("LoadDocumentOperation: InternalThread: run: ...work has been done.");
                this.done = true;
            }
            catch (Exception exception) {
                System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: Caught exception!");
                this.exception = exception;
            }
            catch (ThreadDeath threadDeath) {
                System.out.println("LoadDocumentOperation: InternalThread: run: WARNING: Caught threadDeath!");
            }
            System.out.println("LoadDocumentOperation: InternalThread: run: ends");
        }

        public Exception getException() {
            return this.exception;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean done() {
            if (this.exception != null) {
                return true;
            }
            return this.done;
        }
    }
}

