/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.internal.ui.preferences;

import ag.ion.bion.officelayer.application.IApplicationAssistant;
import ag.ion.bion.officelayer.application.IApplicationProperties;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import ag.ion.bion.workbench.office.editor.core.EditorCorePlugin;
import ag.ion.noa4e.internal.ui.preferences.Messages;
import ag.ion.noa4e.ui.NOAUIPlugin;
import ag.ion.noa4e.ui.wizards.application.LocalApplicationWizard;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LocalOfficeApplicationPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "ag.ion.noa4e.ui.preferences.LocalOfficeApplicationPreferencePage";
    public static final String PREFS_PREVENT_TERMINATION = "openoffice/preventTermination";
    private Text textHome = null;
    private Button buttonPreventTermination = null;
    private Table tableApplicationProperties = null;

    public void init(IWorkbench workbench) {
        System.out.println("LOAPP: init");
        this.setDescription(Messages.LocalOfficeApplicationPreferencesPage_description_configure_application);
    }

    protected Control createContents(Composite parent) {
        int tableWidth;
        System.out.println("LOAPP: createContents");
        FormToolkit formToolkit = NOAUIPlugin.getFormToolkit();
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label labelHome = formToolkit.createLabel(composite, Messages.LocalOfficeApplicationPreferencesPage_label_application_home);
        labelHome.setBackground(composite.getBackground());
        this.textHome = formToolkit.createText(composite, "");
        this.textHome.setEditable(false);
        this.textHome.setFont(composite.getFont());
        GridData gridData = new GridData(4, 0, true, false);
        this.textHome.setLayoutData((Object)gridData);
        final Link linkDefine = new Link(composite, 0);
        linkDefine.setText("<a>" + Messages.LocalOfficeApplicationPreferencesPage_link_define_text + "</a>");
        linkDefine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                System.out.println("LOAPP: createContents: widgetSelected: 1 start");
                LocalApplicationWizard localApplicationWizard = new LocalApplicationWizard();
                System.out.println("LOAPP: createContents: widgetSelected: 2");
                String oldHome = LocalOfficeApplicationPreferencesPage.this.textHome.getText();
                System.out.println("LOAPP: createContents: widgetSelected: 3");
                if (oldHome.length() != 0) {
                    localApplicationWizard.setHomePath(oldHome);
                }
                System.out.println("LOAPP: createContents: widgetSelected: 4");
                WizardDialog wizardDialog = new WizardDialog(linkDefine.getShell(), (IWizard)localApplicationWizard);
                System.out.println("LOAPP: createContents: widgetSelected: 5");
                if (wizardDialog.open() == 0) {
                    System.out.println("LOAPP: createContents: widgetSelected: 6");
                    String home = localApplicationWizard.getSelectedHomePath();
                    System.out.println("LOAPP: createContents: widgetSelected: 7");
                    if (home != null) {
                        LocalOfficeApplicationPreferencesPage.this.textHome.setText(home);
                    }
                    LocalOfficeApplicationPreferencesPage.this.initApplicationProperties(LocalOfficeApplicationPreferencesPage.this.tableApplicationProperties);
                    System.out.println("LOAPP: createContents: widgetSelected: 8");
                }
                System.out.println("LOAPP: createContents: widgetSelected: 9 end");
            }
        });
        Label labelNull = formToolkit.createLabel(composite, "");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        labelNull.setLayoutData((Object)gridData);
        Label labelProperties = formToolkit.createLabel(composite, Messages.LocalOfficeApplicationPreferencesPage_label_application_properties_text);
        labelProperties.setBackground(composite.getBackground());
        labelProperties.setFont(JFaceResources.getFontRegistry().getBold(labelProperties.getFont().toString()));
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        labelProperties.setLayoutData((Object)gridData);
        this.tableApplicationProperties = formToolkit.createTable(composite, 8);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        gridData.widthHint = tableWidth = (int)((double)this.tableApplicationProperties.getDisplay().getClientArea().width * 0.3);
        this.tableApplicationProperties.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        this.tableApplicationProperties.setLayout((Layout)tableLayout);
        TableColumn columnProduct = new TableColumn(this.tableApplicationProperties, 0);
        columnProduct.setText(Messages.LocalOfficeApplicationPreferencesPage_column_name_text);
        int columnProductWidth = (int)((double)tableWidth * 0.4);
        columnProduct.setWidth(columnProductWidth);
        TableColumn columnHome = new TableColumn(this.tableApplicationProperties, 0);
        columnHome.setText(Messages.LocalOfficeApplicationPreferencesPage_column_value_text);
        columnHome.setWidth(tableWidth - columnProductWidth);
        this.tableApplicationProperties.setLinesVisible(true);
        this.tableApplicationProperties.setHeaderVisible(true);
        this.buttonPreventTermination = formToolkit.createButton(composite, Messages.LocalOfficeApplicationPreferencesPage_prevent_termination_lable, 32);
        this.buttonPreventTermination.setBackground(composite.getBackground());
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.buttonPreventTermination.setLayoutData((Object)gridData);
        formToolkit.paintBordersFor(composite);
        this.initPreferenceValues();
        this.initApplicationProperties(this.tableApplicationProperties);
        return composite;
    }

    public boolean performOk() {
        System.out.println("LOAPP: performOK - Adopted to Elexis by GW/JS");
        System.out.println("LOAPP: allocating preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg)");
        System.out.println("LOAPP: instead of using = NOAUIPlugin.getDefault().getPreferenceStore()");
        SettingsPreferenceStore preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg);
        preferenceStore.setValue(PREFS_PREVENT_TERMINATION, this.buttonPreventTermination.getSelection());
        String oldPath = preferenceStore.getString("briefe/OOBasis");
        preferenceStore.setValue("briefe/OOBasis", this.textHome.getText());
        System.out.println("LOAPP: Please note: There is a reference to NOAUIPlugin.getDefault()...");
        System.out.println("LOAPP: still left in this code; I (js) don't know whether this might be null and hence not work.");
        super.performOk();
        if ((oldPath.length() != 0 || !oldPath.equals(this.textHome.getText())) && EditorCorePlugin.getDefault().getManagedLocalOfficeApplication().isActive() && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.LocalOfficeApplicationPreferencesPage_dialog_restart_workbench_title, (String)Messages.LocalOfficeApplicationPreferencesPage_dialog_restart_workbench_message)) {
            NOAUIPlugin.getDefault().getWorkbench().restart();
        }
        return true;
    }

    private void initApplicationProperties(Table table) {
        System.out.println("LOAPP: initApplicationProperties");
        try {
            IApplicationProperties applicationProperties;
            TableItem[] tableItems = table.getItems();
            int i = 0;
            int n = tableItems.length;
            while (i < n) {
                tableItems[i].dispose();
                ++i;
            }
            IApplicationAssistant applicationAssistant = OfficeApplicationRuntime.getApplicationAssistant(EditorCorePlugin.getDefault().getLibrariesLocation());
            ILazyApplicationInfo applicationInfo = applicationAssistant.findLocalApplicationInfo(this.textHome.getText());
            if (applicationInfo != null && (applicationProperties = applicationInfo.getProperties()) != null) {
                String[] names = applicationProperties.getPropertyNames();
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(names));
                names = treeSet.toArray(new String[treeSet.size()]);
                int i2 = 0;
                int n2 = names.length;
                while (i2 < n2) {
                    String name = names[i2];
                    String value = applicationProperties.getPropertyValue(name);
                    if (value != null && value.length() != 0) {
                        TableItem tableItem = new TableItem(table, 0);
                        tableItem.setText(0, name);
                        tableItem.setText(1, value);
                    }
                    ++i2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initPreferenceValues() {
        System.out.println("LOAPP: initPreferenceValues - adopted for Elexis by GW/JS");
        System.out.println("LOAPP: allocating preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg)");
        System.out.println("LOAPP: instead of using = NOAUIPlugin.getDefault().getPreferenceStore()");
        SettingsPreferenceStore preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg);
        String officeHomePath = preferenceStore.getString("briefe/OOBasis");
        boolean preventTermination = preferenceStore.getBoolean(PREFS_PREVENT_TERMINATION);
        this.textHome.setText(officeHomePath);
        this.buttonPreventTermination.setSelection(preventTermination);
    }

    public boolean isValid() {
        System.out.println("LOAPP: isValid - always just returns true");
        return true;
    }
}

