/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.search;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.search.ISearchResult;
import com.sun.star.container.XIndexAccess;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;

public class SearchResult
implements ISearchResult {
    private IDocument document = null;
    private XIndexAccess xIndexAccess = null;
    private XInterface xInterface = null;

    public SearchResult(IDocument document) {
        Assert.isNotNull(document, IDocument.class, this);
        this.document = document;
    }

    public SearchResult(IDocument document, XIndexAccess xIndexAccess) {
        this(document);
        Assert.isNotNull(xIndexAccess, XIndexAccess.class, this);
        this.xIndexAccess = xIndexAccess;
    }

    public SearchResult(IDocument document, XInterface xInterface) {
        this(document);
        Assert.isNotNull(xInterface, XInterface.class, this);
        this.xInterface = xInterface;
    }

    @Override
    public boolean isEmpty() {
        if (this.xIndexAccess == null && this.xInterface == null) {
            return true;
        }
        if (this.xIndexAccess != null) {
            return this.xIndexAccess.getCount() == 0;
        }
        return false;
    }

    @Override
    public ITextRange[] getTextRanges() {
        if (this.xInterface != null) {
            XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)this.xInterface);
            return new ITextRange[]{new TextRange(this.document, textRange)};
        }
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        int i = 0;
        int n = this.xIndexAccess.getCount();
        while (i < n) {
            try {
                Any any = (Any)this.xIndexAccess.getByIndex(i);
                XTextRange textRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)any);
                if (textRange != null) {
                    list.add(new TextRange(this.document, textRange));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return list.toArray(new ITextRange[list.size()]);
    }
}

