/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.internal.text.table.TextTableCellReference;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellReferencesService;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCell;
import java.util.ArrayList;

public class ETextTableCellReferencesService
extends TextTableCellReferencesService {
    private ETextTable textTable = null;

    public ETextTableCellReferencesService(TextTableFormulaExpression textTableFormulaExpression, ETextTable textTable) throws IllegalArgumentException {
        super(textTableFormulaExpression);
        if (textTable == null) {
            throw new IllegalArgumentException("The submitted table is not valid.");
        }
        this.textTable = textTable;
    }

    @Override
    public void applyModifications() throws TextException {
        this.updateFormula();
        this.textTableFormulaExpression.setExpression(this.textTableFormulaModel.getExpression());
    }

    private void updateFormula() throws TextException {
        TextTableCellReference[] textTableCellReferences = this.textTableFormulaModel.getCellReferences();
        boolean startIndex = false;
        boolean endIndex = false;
        int i = 0;
        while (i < textTableCellReferences.length) {
            ArrayList<TextTableCellReference> newTextTableCellReferences = new ArrayList<TextTableCellReference>();
            int startColumnIndex = textTableCellReferences[i].getStartColumnIndex();
            int startRowIndex = textTableCellReferences[i].getStartRowIndex();
            int endColumnIndex = textTableCellReferences[i].getEndColumnIndex();
            int endRowIndex = textTableCellReferences[i].getEndRowIndex();
            IETextTableCell startCell = this.textTable.getCell(startRowIndex, startColumnIndex);
            IETextTableCell endCell = this.textTable.getCell(endRowIndex, endColumnIndex);
            String formula = "";
            TextTableCellReference textTableCellReference = null;
            int startTableIndex = this.textTable.getTextTableIndex(startCell.getTableCell().getTextTable());
            int endTableIndex = this.textTable.getTextTableIndex(endCell.getTableCell().getTextTable());
            ITextTable table = this.textTable.getTextTable(startTableIndex);
            if (!startCell.getName().getName().equals(endCell.getName().getName())) {
                if (startTableIndex != endTableIndex) {
                    formula = String.valueOf(table.getName()) + "." + startCell.getTableCell().getName().getName() + ":" + table.getCell(endColumnIndex, table.getRowCount() - 1).getName().getName();
                    textTableCellReference = new TextTableCellReference(formula);
                    newTextTableCellReferences.add(textTableCellReference);
                    int j = startTableIndex + 1;
                    while (j < endTableIndex) {
                        table = this.textTable.getTextTable(j);
                        formula = String.valueOf(table.getName()) + "." + TextTableCellNameHelper.getColumnCharacter(startCell.getName().getColumnIndex()) + "1" + ":" + table.getCell(endColumnIndex, table.getRowCount() - 1).getName().getName();
                        textTableCellReference = new TextTableCellReference(formula);
                        newTextTableCellReferences.add(textTableCellReference);
                        ++j;
                    }
                    table = this.textTable.getTextTable(endTableIndex);
                    formula = String.valueOf(table.getName()) + "." + TextTableCellNameHelper.getColumnCharacter(startCell.getName().getColumnIndex()) + "1" + ":" + endCell.getTableCell().getName().getName();
                } else {
                    formula = String.valueOf(table.getName()) + "." + startCell.getTableCell().getName().getName() + ":" + endCell.getTableCell().getName().getName();
                }
            } else {
                formula = String.valueOf(table.getName()) + "." + startCell.getTableCell().getName().getName();
            }
            textTableCellReference = new TextTableCellReference(formula);
            newTextTableCellReferences.add(textTableCellReference);
            TextTableCellReference[] references = new TextTableCellReference[newTextTableCellReferences.size()];
            references = newTextTableCellReferences.toArray(references);
            this.textTableFormulaModel.replaceCellReference(textTableCellReferences[i], references);
            ++i;
        }
    }
}

