/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextField;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.text.ITextFieldMaster;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.noa.NOAException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XDependentTextField;
import com.sun.star.uno.UnoRuntime;

public class TextFieldMaster
implements ITextFieldMaster {
    private static final ITextField[] EMPTY_TEXTFIELD_ARRAY = new ITextField[0];
    private ITextDocument textDocument = null;
    private XPropertySet xPropertySet = null;

    public TextFieldMaster(ITextDocument textDocument, XPropertySet xPropertySet) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("The submitted text document is not valid.");
        }
        this.textDocument = textDocument;
        if (xPropertySet == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org interface is not valid.");
        }
        this.xPropertySet = xPropertySet;
    }

    @Override
    public String getName() {
        try {
            Object object = this.xPropertySet.getPropertyValue("Name");
            if (object != null) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getContent() {
        try {
            Object object = this.xPropertySet.getPropertyValue("Content");
            if (object != null) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setContent(String content) throws TextException {
        try {
            this.xPropertySet.setPropertyValue("Content", (Object)content);
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField[] getTextFields() throws TextException {
        try {
            Object object = this.xPropertySet.getPropertyValue("DependentTextFields");
            if (object == null) {
                return EMPTY_TEXTFIELD_ARRAY;
            }
            XDependentTextField[] dependentTextFields = (XDependentTextField[])object;
            ITextField[] textFields = new ITextField[dependentTextFields.length];
            int i = 0;
            int n = dependentTextFields.length;
            while (i < n) {
                textFields[i] = new TextField(this.textDocument, dependentTextFields[i]);
                ++i;
            }
            return textFields;
        }
        catch (Exception exception) {
            throw new TextException(exception);
        }
    }

    @Override
    public ITextField constructNewTextField() throws NOAException {
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.textDocument.getXTextDocument());
            Object textField = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.User");
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface(XDependentTextField.class, (Object)textField);
            xDependentTextField.attachTextFieldMaster(this.xPropertySet);
            return new TextField(this.textDocument, xDependentTextField);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void remove() {
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xPropertySet);
        if (xComponent != null) {
            xComponent.dispose();
        }
    }
}

