/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.Paragraph;
import ag.ion.bion.officelayer.internal.text.TextField;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.ITextContentEnumeration;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextField;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class TextContentEnumeration
implements ITextContentEnumeration {
    private ITextDocument textDocument = null;
    private XTextRange xTextRange = null;

    public TextContentEnumeration(ITextDocument textDocument, XTextRange xTextRange) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted text document is not valid.");
        }
        if (xTextRange == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XTextRange interface is not valid.");
        }
        this.xTextRange = xTextRange;
        this.textDocument = textDocument;
    }

    @Override
    public ITextField[] getTextFields() {
        ArrayList<TextField> arrayList = new ArrayList<TextField>();
        XTextCursor textCursor = this.xTextRange.getText().createTextCursorByRange(this.xTextRange.getStart());
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.xTextRange.getText());
        try {
            while (xTextRangeCompare.compareRegionEnds(textCursor.getStart(), this.xTextRange.getEnd()) != -1) {
                XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textCursor);
                Any any = (Any)propertySet.getPropertyValue("TextField");
                XTextField xTextField = (XTextField)any.getObject();
                if (xTextField != null) {
                    arrayList.add(new TextField(this.textDocument, xTextField));
                }
                if (textCursor.goRight((short)1, false)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception propertySet) {
            // empty catch block
        }
        ITextField[] textFields = new ITextField[arrayList.size()];
        return arrayList.toArray(textFields);
    }

    @Override
    public IParagraph[] getParagraphs() {
        ArrayList<Paragraph> arrayList = new ArrayList<Paragraph>();
        XEnumerationAccess contentEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)this.xTextRange);
        XEnumeration enumeration = contentEnumerationAccess.createEnumeration();
        try {
            while (enumeration.hasMoreElements()) {
                Any any = (Any)enumeration.nextElement();
                XTextContent xTextContent = (XTextContent)any.getObject();
                arrayList.add(new Paragraph(this.textDocument, xTextContent));
            }
        }
        catch (Exception any) {
            // empty catch block
        }
        IParagraph[] paragraphs = new IParagraph[arrayList.size()];
        return arrayList.toArray(paragraphs);
    }
}

