/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.document;

import ag.ion.bion.officelayer.application.connection.IOfficeConnection;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.DocumentDescriptor;
import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.officelayer.document.IDocumentService;
import ag.ion.bion.officelayer.internal.document.ByteArrayXInputStreamAdapter;
import ag.ion.bion.officelayer.internal.document.DocumentDescriptorTransformer;
import ag.ion.bion.officelayer.internal.document.DocumentLoader;
import ag.ion.bion.officelayer.internal.document.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import ag.ion.noa.NOAException;
import ag.ion.noa.db.IDatabaseDocument;
import ag.ion.noa.document.URLAdapter;
import ag.ion.noa.internal.db.DatabaseDocument;
import ag.ion.noa.service.IServiceProvider;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XComponent;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import java.io.InputStream;
import java.util.ArrayList;

public class DocumentService
implements IDocumentService {
    private static final String WRITER_FACTORY_URL = "private:factory/swriter";
    private static final String CALC_FACTORY_URL = "private:factory/scalc";
    private static final String IMPRESS_FACTORY_URL = "private:factory/simpress";
    private static final String DRAW_FACTORY_URL = "private:factory/sdraw";
    private static final String MATH_FACTORY_URL = "private:factory/smath";
    private static final String WEB_FACTORY_URL = "private:factory/swriter/web";
    private static final String GLOBAL_FACTORY_URL = "private:factory/swriter/GlobalDocument";
    private IOfficeConnection officeConnection = null;
    private IServiceProvider serviceProvider = null;
    private XComponentLoader xComponentLoader = null;

    public DocumentService(IOfficeConnection officeConnection, IServiceProvider serviceProvider) throws IllegalArgumentException {
        if (officeConnection == null) {
            throw new IllegalArgumentException("The submitted office connection is not valid.");
        }
        this.officeConnection = officeConnection;
        this.serviceProvider = serviceProvider;
    }

    @Override
    public IDocument constructNewDocument(String documentType, IDocumentDescriptor documentDescriptor) throws NOAException {
        return this.constructNewDocument(null, documentType, documentDescriptor);
    }

    @Override
    public IDocument constructNewDocument(IFrame frame, String documentType, IDocumentDescriptor documentDescriptor) throws NOAException {
        try {
            PropertyValue[] props;
            if (this.xComponentLoader == null) {
                this.xComponentLoader = this.constructComponentLoader();
            }
            DocumentService.checkMaxOpenDocuments(this.serviceProvider);
            String factoryURL = WRITER_FACTORY_URL;
            if (documentType != null) {
                if (documentType.equals("Calc Document")) {
                    factoryURL = CALC_FACTORY_URL;
                } else if (documentType.equals("Draw Document")) {
                    factoryURL = DRAW_FACTORY_URL;
                } else if (documentType.equals("Impress Document")) {
                    factoryURL = IMPRESS_FACTORY_URL;
                } else if (documentType.equals("Math Document")) {
                    factoryURL = MATH_FACTORY_URL;
                } else if (documentType.equals("Web Document")) {
                    factoryURL = WEB_FACTORY_URL;
                } else if (documentType.equals("Global Document")) {
                    factoryURL = GLOBAL_FACTORY_URL;
                } else if (documentType.equals("Base Document")) {
                    return this.constructDatabaseDocument();
                }
            }
            XComponent xComponent = null;
            xComponent = frame != null ? this.xComponentLoader.loadComponentFromURL(factoryURL, frame.getXFrame().getName(), 23, props) : this.xComponentLoader.loadComponentFromURL(factoryURL, "_blank", 0, props);
            IDocument document = DocumentLoader.getDocument(xComponent, this.serviceProvider, props = DocumentDescriptorTransformer.documentDescriptor2PropertyValues(documentDescriptor));
            if (document == null) {
                throw new DocumentException("The new document can not be constructed.");
            }
            return document;
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public IDocument constructNewHiddenDocument(String documentType) throws NOAException {
        return this.constructNewDocument(documentType, DocumentDescriptor.DEFAULT_HIDDEN);
    }

    @Override
    public IDocument loadDocument(String url) throws DocumentException {
        try {
            url = URLAdapter.adaptURL(url);
            IDocument document = DocumentLoader.loadDocument(this.serviceProvider, url);
            if (document != null) {
                return document;
            }
            throw new DocumentException(Messages.getString("DocumentService_exception_url_invalid"));
        }
        catch (Throwable throwable) {
            DocumentException documentException = new DocumentException(throwable.getMessage());
            documentException.initCause(throwable);
            throw documentException;
        }
    }

    @Override
    public IDocument loadDocument(String url, IDocumentDescriptor documentDescriptor) throws NOAException {
        try {
            PropertyValue[] propertyValues = DocumentDescriptorTransformer.documentDescriptor2PropertyValues(documentDescriptor);
            url = URLAdapter.adaptURL(url);
            IDocument document = DocumentLoader.loadDocument(this.serviceProvider, url, propertyValues);
            if (document != null) {
                return document;
            }
            throw new NOAException(Messages.getString("DocumentService_exception_url_invalid"));
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public IDocument loadDocument(InputStream inputStream, IDocumentDescriptor documentDescriptor) throws DocumentException {
        return this.loadDocument(null, null, inputStream, documentDescriptor);
    }

    @Override
    public IDocument loadDocument(IFrame frame, InputStream inputStream, IDocumentDescriptor documentDescriptor) throws DocumentException {
        return this.loadDocument(null, frame, inputStream, documentDescriptor);
    }

    @Override
    public IDocument loadDocument(IOfficeProgressMonitor officeProgressMonitor, InputStream inputStream, IDocumentDescriptor documentDescriptor) throws DocumentException {
        return this.loadDocument(officeProgressMonitor, null, inputStream, documentDescriptor);
    }

    @Override
    public IDocument loadDocument(IOfficeProgressMonitor officeProgressMonitor, IFrame frame, InputStream inputStream, IDocumentDescriptor documentDescriptor) throws DocumentException {
        IDocument document;
        XComponent xComponent = null;
        PropertyValue[] properties = new PropertyValue[1];
        try {
            if (inputStream == null) {
                throw new DocumentException("The submitted input stream is not valid.");
            }
            if (this.xComponentLoader == null || !this.officeConnection.isConnected()) {
                this.xComponentLoader = this.constructComponentLoader();
            }
            DocumentService.checkMaxOpenDocuments(this.serviceProvider);
            ByteArrayXInputStreamAdapter byteArrayToXInputStreamAdapter = new ByteArrayXInputStreamAdapter(inputStream, officeProgressMonitor);
            properties[0] = new PropertyValue("InputStream", -1, (Object)byteArrayToXInputStreamAdapter, PropertyState.DIRECT_VALUE);
            properties = DocumentDescriptorTransformer.documentDescriptor2PropertyValues(properties, documentDescriptor);
            xComponent = frame == null ? this.xComponentLoader.loadComponentFromURL("private:stream", "_blank", 0, properties) : this.xComponentLoader.loadComponentFromURL("private:stream", frame.getXFrame().getName(), 23, properties);
        }
        catch (Throwable throwable) {
            throw new DocumentException(throwable);
        }
        if (officeProgressMonitor != null) {
            officeProgressMonitor.beginSubTask(Messages.getString("DocumentService_monitor_investigating"));
        }
        if ((document = DocumentLoader.getDocument(xComponent, this.serviceProvider, properties)) != null) {
            if (officeProgressMonitor != null) {
                officeProgressMonitor.beginSubTask(Messages.getString("DocumentService_monitor_loading_completed"));
                officeProgressMonitor.done();
            }
            return document;
        }
        throw new DocumentException("The document can not be loaded.");
    }

    @Override
    public IDocument loadDocument(IFrame frame, String url) throws DocumentException {
        return this.loadDocument(frame, url, null);
    }

    @Override
    public IDocument loadDocument(IFrame frame, String url, IDocumentDescriptor documentDescriptor) throws DocumentException {
        System.out.println("DocumentService: loadDocument() begins");
        if (url == null) {
            throw new DocumentException("The submitted url is not valid.");
        }
        try {
            url = URLAdapter.adaptURL(url);
            IDocument document = null;
            if (frame == null) {
                document = DocumentLoader.loadDocument(this.serviceProvider, url, DocumentDescriptorTransformer.documentDescriptor2PropertyValues(documentDescriptor));
            } else {
                System.out.println("DocumentService: DocumentLoader.loadDocument()...");
                document = DocumentLoader.loadDocument(this.serviceProvider, frame.getXFrame(), url, 23, DocumentDescriptorTransformer.documentDescriptor2PropertyValues(documentDescriptor));
            }
            if (document != null) {
                System.out.println("DocumentService: DocumentLoader: SUCCESS: document=" + document.toString());
                System.out.println("DocumentService: DocumentLoader: About to return document...");
                return document;
            }
            System.out.println("DocumentService: DocumentLoader: WARNING: FAILED; document==null");
            System.out.println("DocumentService: DocumentLoader: About to throw DocumentException...");
            throw new DocumentException(Messages.getString("DocumentService_exception_url_invalid"));
        }
        catch (Exception exception) {
            System.out.println("DocumentService: DocumentLoader: WARNING: Caught document exception.");
            DocumentException documentException = new DocumentException(exception.getMessage());
            documentException.initCause(exception);
            throw documentException;
        }
    }

    @Override
    public IDocument[] getCurrentDocuments() throws DocumentException {
        return DocumentService.getCurrentDocuments(this.serviceProvider);
    }

    @Override
    public int getCurrentDocumentCount() throws DocumentException {
        return DocumentService.getCurrentDocumentCount(this.serviceProvider);
    }

    public static IDocument[] getCurrentDocuments(IServiceProvider serviceProvider) throws DocumentException {
        try {
            if (serviceProvider == null) {
                return new IDocument[0];
            }
            Object desktop = serviceProvider.createService("com.sun.star.frame.Desktop");
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            XEnumeration aktComponents = xDesktop.getComponents().createEnumeration();
            ArrayList<IDocument> arrayList = new ArrayList<IDocument>();
            while (aktComponents.hasMoreElements()) {
                Any a = (Any)aktComponents.nextElement();
                arrayList.add(DocumentLoader.getDocument((XComponent)a.getObject(), serviceProvider, null));
            }
            IDocument[] documents = new IDocument[arrayList.size()];
            documents = arrayList.toArray(documents);
            return documents;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    public static int getCurrentDocumentCount(IServiceProvider serviceProvider) throws DocumentException {
        try {
            int i = 0;
            if (serviceProvider == null) {
                return i;
            }
            Object desktop = serviceProvider.createService("com.sun.star.frame.Desktop");
            XDesktop xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            XEnumeration aktComponents = xDesktop.getComponents().createEnumeration();
            while (aktComponents.hasMoreElements()) {
                aktComponents.nextElement();
                ++i;
            }
            return i;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    public static void checkMaxOpenDocuments(IServiceProvider serviceProvider) throws NOAException {
        try {
            if (serviceProvider != null && DocumentService.getCurrentDocumentCount(serviceProvider) >= 50) {
                throw new NOAException("The maximum number of opend documents was reached (Maximum number is 50).");
            }
        }
        catch (DocumentException documentException) {
            throw new NOAException(documentException);
        }
    }

    @Override
    public void dispose() {
    }

    private IDatabaseDocument constructDatabaseDocument() throws NOAException {
        try {
            Object dataSource = this.officeConnection.getXMultiComponentFactory().createInstanceWithContext("com.sun.star.sdb.DataSource", this.officeConnection.getXComponentContext());
            XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)dataSource);
            propertySet.setPropertyValue("URL", (Object)"sdbc:embedded:hsqldb");
            XDocumentDataSource documentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(XDocumentDataSource.class, (Object)dataSource);
            XOfficeDatabaseDocument officeDatabaseDocument = documentDataSource.getDatabaseDocument();
            return new DatabaseDocument(officeDatabaseDocument, null);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    private XComponentLoader constructComponentLoader() throws Exception {
        Object oDesktop = this.officeConnection.getXMultiComponentFactory().createInstanceWithContext("com.sun.star.frame.Desktop", this.officeConnection.getXComponentContext());
        return (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
    }
}

