/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.document;

import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import com.sun.star.beans.PropertyValue;
import java.util.ArrayList;
import java.util.Arrays;

public class DocumentDescriptorTransformer {
    public static PropertyValue[] documentDescriptor2PropertyValues(IDocumentDescriptor documentDescriptor) {
        return DocumentDescriptorTransformer.documentDescriptor2PropertyValues(null, documentDescriptor);
    }

    public static PropertyValue[] documentDescriptor2PropertyValues(PropertyValue[] propertyValues, IDocumentDescriptor documentDescriptor) {
        String filterDef;
        String URL2;
        String baseURL;
        String title;
        String comment;
        String author;
        if (documentDescriptor == null) {
            if (propertyValues == null) {
                return new PropertyValue[0];
            }
            return propertyValues;
        }
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>();
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "AsTemplate";
        propertyValue.Value = new Boolean(documentDescriptor.getAsTemplate());
        list.add(propertyValue);
        if (documentDescriptor.getHidden()) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "Hidden";
            propertyValue.Value = Boolean.TRUE;
            list.add(propertyValue);
        }
        if (documentDescriptor.getReadOnly()) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "ReadOnly";
            propertyValue.Value = Boolean.TRUE;
            list.add(propertyValue);
        }
        if (documentDescriptor.getAsPreview()) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "Preview";
            propertyValue.Value = Boolean.TRUE;
            list.add(propertyValue);
        }
        if ((author = documentDescriptor.getAuthor()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "Author";
            propertyValue.Value = author;
            list.add(propertyValue);
        }
        if ((comment = documentDescriptor.getComment()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "Comment";
            propertyValue.Value = comment;
            list.add(propertyValue);
        }
        if ((title = documentDescriptor.getTitle()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "DocumentTitle";
            propertyValue.Value = title;
            list.add(propertyValue);
        }
        if ((baseURL = documentDescriptor.getBaseURL()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "DocumentBaseURL";
            propertyValue.Value = baseURL;
            list.add(propertyValue);
        }
        if ((URL2 = documentDescriptor.getURL()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "URL";
            propertyValue.Value = URL2;
            list.add(propertyValue);
        }
        if ((filterDef = documentDescriptor.getFilterDefinition()) != null) {
            propertyValue = new PropertyValue();
            propertyValue.Name = "FilterName";
            propertyValue.Value = filterDef;
            list.add(propertyValue);
        }
        short macroExecMode = documentDescriptor.getMacroExecutionMode();
        propertyValue = new PropertyValue();
        propertyValue.Name = "MacroExecutionMode";
        propertyValue.Value = macroExecMode;
        list.add(propertyValue);
        if (propertyValues != null) {
            list.addAll(Arrays.asList(propertyValues));
        }
        return list.toArray(new PropertyValue[list.size()]);
    }
}

