/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application.connection;

import ag.ion.bion.officelayer.OSHelper;
import ag.ion.bion.officelayer.internal.application.connection.LocalOfficeConnection;
import ag.ion.bion.officelayer.internal.application.connection.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.sun.star.comp.beans.ContainerFactory;
import com.sun.star.comp.beans.LocalOfficeWindow;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import ooo.connector.BootstrapSocketConnector;

public class LocalOfficeConnectionGhost
implements OfficeConnection {
    private static final String OFFICE_APP_NAME = "soffice";
    private static final String OFFICE_LIB_NAME = "officebean";
    private static final String OFFICE_ID_SUFFIX = "_Office";
    private static boolean msvcrLoaded = false;
    private static boolean uwinapiLoaded = false;
    private static boolean jawtLoaded = false;
    private static boolean officebeanLoaded = false;
    private static String mProgramPath = null;
    private BootstrapSocketConnector bootstrapSocketConnector = null;
    private Process process = null;
    private ContainerFactory containerFactory = null;
    private XComponentContext context = null;
    private String url = null;
    private String connType = null;
    private String pipe = null;
    private String port = null;
    private String protocol = null;
    private String initialObject = null;
    private List components = new Vector();
    private OfficeConnectionWrapper officeConnectionWrapper = null;
    private IOfficeProgressMonitor officeProgressMonitor = null;

    public LocalOfficeConnectionGhost(IOfficeProgressMonitor officeProgressMonitor) {
        this.loadNativeLibraries();
        this.officeProgressMonitor = officeProgressMonitor;
        try {
            this.setUnoUrl("uno:pipe,name=" + this.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setUnoUrl(String url) throws MalformedURLException {
        this.url = null;
        String prefix = "uno:localoffice";
        if (url.startsWith(prefix)) {
            this.parseUnoUrlWithOfficePath(url, prefix);
        } else {
            try {
                UnoUrl aURL = UnoUrl.parseUnoUrl((String)url);
                mProgramPath = null;
                this.connType = aURL.getConnection();
                this.pipe = (String)aURL.getConnectionParameters().get("pipe");
                this.port = (String)aURL.getConnectionParameters().get("port");
                this.protocol = aURL.getProtocol();
                this.initialObject = aURL.getRootOid();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException("Invalid UNO connection URL.");
            }
        }
        this.url = url;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    public synchronized XComponentContext getComponentContext() {
        if (this.officeProgressMonitor != null && this.officeProgressMonitor.isCanceled()) {
            return null;
        }
        if (this.context == null) {
            this.context = this.connect();
        }
        return this.context;
    }

    public synchronized XComponentContext getCurrentComponentContext() {
        if (this.officeProgressMonitor != null && this.officeProgressMonitor.isCanceled()) {
            return null;
        }
        return this.context;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        if (this.officeConnectionWrapper == null) {
            this.officeConnectionWrapper = new OfficeConnectionWrapper();
        }
        return new LocalOfficeWindowWrapper(this.officeConnectionWrapper);
    }

    public void dispose() {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            try {
                ((XEventListener)iterator.next()).disposing(null);
            }
            catch (java.lang.RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.components.clear();
        if (this.bootstrapSocketConnector != null) {
            this.bootstrapSocketConnector.disconnect();
        }
        this.containerFactory = null;
        this.context = null;
    }

    public void addEventListener(XEventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        this.components.add(eventListener);
    }

    public void removeEventListener(XEventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        this.components.remove(eventListener);
    }

    private XComponentContext connect() {
        try {
            if (this.officeProgressMonitor != null) {
                this.officeProgressMonitor.beginSubTask(Messages.getString("LocalOfficeConnectionGhost_monitor_constructing_initial_context_message"));
            }
            this.bootstrapSocketConnector = new BootstrapSocketConnector(this.getProgramPath());
            XComponentContext xContext = this.bootstrapSocketConnector.connect();
            return xContext;
        }
        catch (RuntimeException exception) {
            System.out.println("--- RuntimeException:");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.out.println("--- end.");
            throw exception;
        }
        catch (Exception exception) {
            System.out.println("java.lang.Exception: ");
            System.out.println(exception);
            exception.printStackTrace();
            System.out.println("--- end.");
            throw new RuntimeException(exception.toString());
        }
    }

    private String getProgramPath() {
        if (mProgramPath == null) {
            File path;
            String officeHomePath = System.getProperty("office.home");
            if (officeHomePath != null) {
                if (OSHelper.IS_MAC) {
                    officeHomePath = String.valueOf(officeHomePath) + "/Contents/MacOS";
                }
                return String.valueOf(officeHomePath) + File.separator + "program";
            }
            String exec = OFFICE_APP_NAME;
            if (OSHelper.IS_WINDOWS) {
                exec = "soffice.exe";
            }
            if ((path = NativeLibraryLoader.getResource((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)exec)) != null) {
                mProgramPath = path.getParent();
            }
            if (mProgramPath == null) {
                mProgramPath = "";
            }
        }
        return mProgramPath;
    }

    private void parseUnoUrlWithOfficePath(String url, String prefix) throws MalformedURLException {
        int index = url.indexOf(";urp;StarOffice.NamingService");
        if (index < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String params = url.substring(prefix.length(), index + 1);
        String name = null;
        String path = null;
        String pipe = null;
        int state = 0;
        StringBuffer buffer = new StringBuffer();
        index = 0;
        while (index < params.length()) {
            char ch = params.charAt(index);
            block0 : switch (state) {
                case 0: {
                    switch (ch) {
                        case ',': {
                            buffer.delete(0, buffer.length());
                            state = 1;
                            break block0;
                        }
                        case ';': {
                            state = 7;
                            break block0;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    break;
                }
                case 1: {
                    switch (ch) {
                        case ' ': 
                        case '=': {
                            name = buffer.toString();
                            state = ch == ' ' ? 2 : 3;
                            break block0;
                        }
                        case ',': 
                        case ';': {
                            state = -6;
                            break block0;
                        }
                    }
                    buffer.append(ch);
                    break;
                }
                case 2: {
                    switch (ch) {
                        case '=': {
                            state = 3;
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    switch (ch) {
                        case ' ': {
                            break block0;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 4;
                    break;
                }
                case 4: {
                    switch (ch) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --index;
                            state = 5;
                            if (name.equals("path")) {
                                if (path == null) {
                                    path = buffer.toString();
                                } else {
                                    state = -3;
                                }
                            } else if (name.equals("pipe")) {
                                if (pipe == null) {
                                    pipe = buffer.toString();
                                } else {
                                    state = -4;
                                }
                            } else {
                                state = -2;
                            }
                            buffer.delete(0, buffer.length());
                            break block0;
                        }
                    }
                    buffer.append(ch);
                    break;
                }
                case 5: {
                    switch (ch) {
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            state = 6;
                            break block0;
                        }
                        case ';': {
                            state = 7;
                            break block0;
                        }
                    }
                    state = -5;
                    break;
                }
                case 6: {
                    switch (ch) {
                        case ' ': {
                            break block0;
                        }
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append(ch);
                    state = 1;
                    break;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
            ++index;
        }
        if (state != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (path != null) {
            mProgramPath = path;
        }
        if (pipe != null) {
            this.pipe = pipe;
        }
    }

    private String replaceAll(String aString, String aSearch, String aReplace) {
        StringBuffer aBuffer = new StringBuffer(aString);
        int nPos = aString.length();
        int nOfs = aSearch.length();
        while ((nPos = aString.lastIndexOf(aSearch, nPos - 1)) > -1) {
            aBuffer.replace(nPos, nPos + nOfs, aReplace);
        }
        return aBuffer.toString();
    }

    private String getPipeName() {
        String aPipeName = String.valueOf(System.getProperty("user.name")) + OFFICE_ID_SUFFIX;
        aPipeName = this.replaceAll(aPipeName, "_", "%B7");
        return this.replaceAll(this.replaceAll(URLEncoder.encode(aPipeName), "\\+", "%20"), "%", "_");
    }

    private void loadNativeLibraries() {
        String officeHomePath = System.getProperty("office.home");
        if (OSHelper.IS_WINDOWS) {
            try {
                if (!msvcrLoaded) {
                    if (officeHomePath == null) {
                        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr70");
                    } else {
                        System.load(String.valueOf(officeHomePath) + File.separator + "program" + File.separator + System.mapLibraryName("msvcr70"));
                    }
                    msvcrLoaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (!msvcrLoaded) {
                    if (officeHomePath == null) {
                        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr71");
                    } else {
                        System.load(String.valueOf(officeHomePath) + File.separator + "program" + File.separator + System.mapLibraryName("msvcr71"));
                    }
                    msvcrLoaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (!uwinapiLoaded) {
                    if (officeHomePath == null) {
                        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"uwinapi");
                    } else {
                        System.load(String.valueOf(officeHomePath) + File.separator + "program" + File.separator + System.mapLibraryName("uwinapi"));
                    }
                    uwinapiLoaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (!jawtLoaded) {
                    if (officeHomePath == null) {
                        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"jawt");
                    } else {
                        System.load(String.valueOf(officeHomePath) + File.separator + "program" + File.separator + System.mapLibraryName("jawt"));
                    }
                    jawtLoaded = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (!officebeanLoaded) {
                if (officeHomePath == null) {
                    NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)OFFICE_LIB_NAME);
                } else {
                    System.load(String.valueOf(officeHomePath) + File.separator + "program" + File.separator + System.mapLibraryName(OFFICE_LIB_NAME));
                }
                officebeanLoaded = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class LocalOfficeWindowWrapper
    extends LocalOfficeWindow {
        protected LocalOfficeWindowWrapper(OfficeConnection officeConnection) {
            super(officeConnection);
        }
    }

    private class OfficeConnectionWrapper
    implements OfficeConnection {
        private OfficeConnectionWrapper() {
        }

        public void setUnoUrl(String url) throws MalformedURLException {
            LocalOfficeConnectionGhost.this.setUnoUrl(url);
        }

        public void setContainerFactory(ContainerFactory containerFactory) {
            LocalOfficeConnectionGhost.this.setContainerFactory(containerFactory);
        }

        public XComponentContext getComponentContext() {
            return LocalOfficeConnectionGhost.this.getComponentContext();
        }

        public OfficeWindow createOfficeWindow(Container container) {
            return LocalOfficeConnectionGhost.this.createOfficeWindow(container);
        }

        public void dispose() {
            LocalOfficeConnectionGhost.this.dispose();
        }

        public void addEventListener(XEventListener eventListener) {
            LocalOfficeConnectionGhost.this.addEventListener(eventListener);
        }

        public void removeEventListener(XEventListener eventListener) {
            LocalOfficeConnectionGhost.this.removeEventListener(eventListener);
        }
    }

    private class OfficeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            if (LocalOfficeConnectionGhost.this.pipe == null) {
                return LocalOfficeConnectionGhost.this.getPipeName();
            }
            return LocalOfficeConnectionGhost.this.pipe;
        }

        public void startupService() throws IOException {
            int nSizeCmdArray = 5;
            String sOption = null;
            try {
                sOption = System.getProperty("com.sun.star.officebean.Options");
                if (sOption != null) {
                    ++nSizeCmdArray;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            String[] cmdArray = new String[nSizeCmdArray];
            cmdArray[0] = new File(LocalOfficeConnectionGhost.this.getProgramPath(), LocalOfficeConnectionGhost.OFFICE_APP_NAME).getPath();
            cmdArray[1] = "-nologo";
            cmdArray[2] = "-nodefault";
            cmdArray[3] = "-norestore";
            if (LocalOfficeConnectionGhost.this.connType.equals("pipe")) {
                cmdArray[4] = "-accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnectionGhost.this.protocol + ";" + LocalOfficeConnectionGhost.this.initialObject;
            } else if (LocalOfficeConnectionGhost.this.connType.equals("socket")) {
                cmdArray[4] = "-accept=socket,port=" + LocalOfficeConnectionGhost.this.port + ";urp";
            } else {
                throw new IOException("No connection specified");
            }
            if (sOption != null) {
                cmdArray[5] = sOption;
            }
            LocalOfficeConnectionGhost.this.process = Runtime.getRuntime().exec(cmdArray);
            if (LocalOfficeConnectionGhost.this.process == null) {
                throw new java.lang.RuntimeException("Cannot start soffice: " + cmdArray);
            }
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

