/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.IOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.application.RemoteOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.internal.application.AbstractOfficeApplication;
import ag.ion.bion.officelayer.internal.application.connection.RemoteOfficeConnection;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import java.util.Map;

public class RemoteOfficeApplication
extends AbstractOfficeApplication
implements IOfficeApplication {
    private RemoteOfficeApplicationConfiguration remoteOfficeApplicationConfiguration = null;
    private String host = null;
    private String port = null;
    private boolean isConfigured = false;

    public RemoteOfficeApplication(Map map) {
        if (map != null) {
            try {
                this.initConfiguration(map);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void setConfiguration(IOfficeApplicationConfiguration officeApplicationConfiguration) throws OfficeApplicationException {
        if (!(officeApplicationConfiguration instanceof RemoteOfficeApplicationConfiguration)) {
            throw new OfficeApplicationException("The submitted configuration is not valid for a remote office application.");
        }
        this.remoteOfficeApplicationConfiguration = (RemoteOfficeApplicationConfiguration)officeApplicationConfiguration;
        this.setOfficeApplicationConfiguration(this.remoteOfficeApplicationConfiguration);
        this.host = this.remoteOfficeApplicationConfiguration.getHost();
        this.port = this.remoteOfficeApplicationConfiguration.getPort();
        this.isConfigured = true;
    }

    @Override
    public void setConfiguration(Map configuration) throws OfficeApplicationException {
        this.initConfiguration(configuration);
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    protected void openConnection(IOfficeProgressMonitor officeProgressMonitor) throws OfficeApplicationException {
        try {
            RemoteOfficeConnection remoteOfficeConnection = new RemoteOfficeConnection();
            remoteOfficeConnection.setPort(this.port);
            remoteOfficeConnection.setHost(this.host);
            remoteOfficeConnection.openConnection(officeProgressMonitor);
            this.setOfficeConnection(remoteOfficeConnection);
        }
        catch (Exception exception) {
            OfficeApplicationException officeApplicationException = new OfficeApplicationException(exception.getMessage());
            officeApplicationException.initCause(exception);
            throw officeApplicationException;
        }
    }

    private void initConfiguration(Map configuration) throws OfficeApplicationException {
        if (configuration == null) {
            throw new OfficeApplicationException("The submitted configuration is not valid.");
        }
        Object host = configuration.get("host");
        Object port = configuration.get("port");
        if (host == null) {
            throw new OfficeApplicationException("The host of the office application is missing.");
        }
        this.host = host.toString();
        if (port == null) {
            throw new OfficeApplicationException("The port of the office application is missing.");
        }
        this.port = port.toString();
        this.isConfigured = true;
    }

    @Override
    public String getApplicationType() {
        return "remote";
    }
}

