# TaskServiceV1Api

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateTask**](TaskServiceV1Api.md#activateTask) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task |
| [**activateTaskWithHttpInfo**](TaskServiceV1Api.md#activateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task |
| [**createTask**](TaskServiceV1Api.md#createTask) | **POST** /api/v1/services/task | Create a new task |
| [**createTaskWithHttpInfo**](TaskServiceV1Api.md#createTaskWithHttpInfo) | **POST** /api/v1/services/task | Create a new task |
| [**deactivateTask**](TaskServiceV1Api.md#deactivateTask) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task |
| [**deactivateTaskWithHttpInfo**](TaskServiceV1Api.md#deactivateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task |
| [**deleteTask**](TaskServiceV1Api.md#deleteTask) | **DELETE** /api/v1/services/task/{id} | Delete task |
| [**deleteTaskWithHttpInfo**](TaskServiceV1Api.md#deleteTaskWithHttpInfo) | **DELETE** /api/v1/services/task/{id} | Delete task |
| [**findRunnableExecutions**](TaskServiceV1Api.md#findRunnableExecutions) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable |
| [**findRunnableExecutionsWithHttpInfo**](TaskServiceV1Api.md#findRunnableExecutionsWithHttpInfo) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable |
| [**findTask**](TaskServiceV1Api.md#findTask) | **GET** /api/v1/services/task/{id} | Get task and its state |
| [**findTaskWithHttpInfo**](TaskServiceV1Api.md#findTaskWithHttpInfo) | **GET** /api/v1/services/task/{id} | Get task and its state |
| [**findTaskExecutions**](TaskServiceV1Api.md#findTaskExecutions) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25) |
| [**findTaskExecutionsWithHttpInfo**](TaskServiceV1Api.md#findTaskExecutionsWithHttpInfo) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25) |
| [**findTasks**](TaskServiceV1Api.md#findTasks) | **GET** /api/v1/services/task | List tasks |
| [**findTasksWithHttpInfo**](TaskServiceV1Api.md#findTasksWithHttpInfo) | **GET** /api/v1/services/task | List tasks |
| [**listRunnables**](TaskServiceV1Api.md#listRunnables) | **GET** /api/v1/services/runnable | List available runnables |
| [**listRunnablesWithHttpInfo**](TaskServiceV1Api.md#listRunnablesWithHttpInfo) | **GET** /api/v1/services/runnable | List available runnables |
| [**refreshTask**](TaskServiceV1Api.md#refreshTask) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it |
| [**refreshTaskWithHttpInfo**](TaskServiceV1Api.md#refreshTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it |
| [**triggerRunnable**](TaskServiceV1Api.md#triggerRunnable) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable |
| [**triggerRunnableWithHttpInfo**](TaskServiceV1Api.md#triggerRunnableWithHttpInfo) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable |
| [**triggerRunnableSync**](TaskServiceV1Api.md#triggerRunnableSync) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id |
| [**triggerRunnableSyncWithHttpInfo**](TaskServiceV1Api.md#triggerRunnableSyncWithHttpInfo) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id |
| [**triggerTask**](TaskServiceV1Api.md#triggerTask) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task |
| [**triggerTaskWithHttpInfo**](TaskServiceV1Api.md#triggerTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task |
| [**updateTask**](TaskServiceV1Api.md#updateTask) | **PUT** /api/v1/services/task/{id} | Update task |
| [**updateTaskWithHttpInfo**](TaskServiceV1Api.md#updateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id} | Update task |



## activateTask

> void activateTask(id)

Activate and possibly incur task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.activateTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#activateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## activateTaskWithHttpInfo

> ApiResponse<Void> activateTask activateTaskWithHttpInfo(id)

Activate and possibly incur task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.activateTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#activateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## createTask

> Task createTask(task)

Create a new task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Task task = new Task(); // Task | 
        try {
            Task result = apiInstance.createTask(task);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#createTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **task** | [**Task**](Task.md)|  | |

### Return type

[**Task**](Task.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## createTaskWithHttpInfo

> ApiResponse<Task> createTask createTaskWithHttpInfo(task)

Create a new task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Task task = new Task(); // Task | 
        try {
            ApiResponse<Task> response = apiInstance.createTaskWithHttpInfo(task);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#createTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **task** | [**Task**](Task.md)|  | |

### Return type

ApiResponse<[**Task**](Task.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## deactivateTask

> void deactivateTask(id)

Deactivate task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.deactivateTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deactivateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## deactivateTaskWithHttpInfo

> ApiResponse<Void> deactivateTask deactivateTaskWithHttpInfo(id)

Deactivate task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.deactivateTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deactivateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## deleteTask

> void deleteTask(id)

Delete task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.deleteTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deleteTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## deleteTaskWithHttpInfo

> ApiResponse<Void> deleteTask deleteTaskWithHttpInfo(id)

Delete task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.deleteTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#deleteTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findRunnableExecutions

> List<TaskResult> findRunnableExecutions(runnableId)

Find all current and past executions of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        try {
            List<TaskResult> result = apiInstance.findRunnableExecutions(runnableId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findRunnableExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |

### Return type

[**List&lt;TaskResult&gt;**](TaskResult.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findRunnableExecutionsWithHttpInfo

> ApiResponse<List<TaskResult>> findRunnableExecutions findRunnableExecutionsWithHttpInfo(runnableId)

Find all current and past executions of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        try {
            ApiResponse<List<TaskResult>> response = apiInstance.findRunnableExecutionsWithHttpInfo(runnableId);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findRunnableExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |

### Return type

ApiResponse<[**List&lt;TaskResult&gt;**](TaskResult.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTask

> Task findTask(id)

Get task and its state

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            Task result = apiInstance.findTask(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**Task**](Task.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findTaskWithHttpInfo

> ApiResponse<Task> findTask findTaskWithHttpInfo(id)

Get task and its state

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<Task> response = apiInstance.findTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

ApiResponse<[**Task**](Task.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTaskExecutions

> List<TaskResult> findTaskExecutions(id)

Get all task executions ordered by create time descending (limit 25)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            List<TaskResult> result = apiInstance.findTaskExecutions(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTaskExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**List&lt;TaskResult&gt;**](TaskResult.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findTaskExecutionsWithHttpInfo

> ApiResponse<List<TaskResult>> findTaskExecutions findTaskExecutionsWithHttpInfo(id)

Get all task executions ordered by create time descending (limit 25)

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<List<TaskResult>> response = apiInstance.findTaskExecutionsWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTaskExecutions");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

ApiResponse<[**List&lt;TaskResult&gt;**](TaskResult.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## findTasks

> List<Task> findTasks(system)

List tasks

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Boolean system = false; // Boolean | 
        try {
            List<Task> result = apiInstance.findTasks(system);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTasks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **system** | **Boolean**|  | [optional] [default to false] |

### Return type

[**List&lt;Task&gt;**](Task.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## findTasksWithHttpInfo

> ApiResponse<List<Task>> findTasks findTasksWithHttpInfo(system)

List tasks

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        Boolean system = false; // Boolean | 
        try {
            ApiResponse<List<Task>> response = apiInstance.findTasksWithHttpInfo(system);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#findTasks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **system** | **Boolean**|  | [optional] [default to false] |

### Return type

ApiResponse<[**List&lt;Task&gt;**](Task.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## listRunnables

> List<IdentifiedRunnable> listRunnables()

List available runnables

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        try {
            List<IdentifiedRunnable> result = apiInstance.listRunnables();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#listRunnables");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;IdentifiedRunnable&gt;**](IdentifiedRunnable.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## listRunnablesWithHttpInfo

> ApiResponse<List<IdentifiedRunnable>> listRunnables listRunnablesWithHttpInfo()

List available runnables

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        try {
            ApiResponse<List<IdentifiedRunnable>> response = apiInstance.listRunnablesWithHttpInfo();
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#listRunnables");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

ApiResponse<[**List&lt;IdentifiedRunnable&gt;**](IdentifiedRunnable.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## refreshTask

> void refreshTask(id)

Refreshes the info on this task, and acts on it

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            apiInstance.refreshTask(id);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#refreshTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## refreshTaskWithHttpInfo

> ApiResponse<Void> refreshTask refreshTaskWithHttpInfo(id)

Refreshes the info on this task, and acts on it

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.refreshTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#refreshTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## triggerRunnable

> Task triggerRunnable(runnableId, requestBody)

Trigger asynchronous execution of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            Task result = apiInstance.triggerRunnable(runnableId, requestBody);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnable");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

[**Task**](Task.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## triggerRunnableWithHttpInfo

> ApiResponse<Task> triggerRunnable triggerRunnableWithHttpInfo(runnableId, requestBody)

Trigger asynchronous execution of a runnable

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            ApiResponse<Task> response = apiInstance.triggerRunnableWithHttpInfo(runnableId, requestBody);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnable");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

ApiResponse<[**Task**](Task.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## triggerRunnableSync

> TaskResult triggerRunnableSync(runnableId, requestBody)

Trigger synchronous execution of a runnable by its id

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            TaskResult result = apiInstance.triggerRunnableSync(runnableId, requestBody);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnableSync");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

[**TaskResult**](TaskResult.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## triggerRunnableSyncWithHttpInfo

> ApiResponse<TaskResult> triggerRunnableSync triggerRunnableSyncWithHttpInfo(runnableId, requestBody)

Trigger synchronous execution of a runnable by its id

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String runnableId = "runnableId_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            ApiResponse<TaskResult> response = apiInstance.triggerRunnableSyncWithHttpInfo(runnableId, requestBody);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerRunnableSync");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **runnableId** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type

ApiResponse<[**TaskResult**](TaskResult.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## triggerTask

> TaskResult triggerTask(id)

Trigger task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            TaskResult result = apiInstance.triggerTask(id);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

[**TaskResult**](TaskResult.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## triggerTaskWithHttpInfo

> ApiResponse<TaskResult> triggerTask triggerTaskWithHttpInfo(id)

Trigger task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        try {
            ApiResponse<TaskResult> response = apiInstance.triggerTaskWithHttpInfo(id);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#triggerTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |

### Return type

ApiResponse<[**TaskResult**](TaskResult.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## updateTask

> Task updateTask(id, task)

Update task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        Task task = new Task(); // Task | 
        try {
            Task result = apiInstance.updateTask(id, task);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#updateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |
| **task** | [**Task**](Task.md)|  | |

### Return type

[**Task**](Task.md)


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## updateTaskWithHttpInfo

> ApiResponse<Task> updateTask updateTaskWithHttpInfo(id, task)

Update task

&lt;b&gt;Roles Required:&lt;/b&gt; api-access&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.TaskServiceV1Api;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        TaskServiceV1Api apiInstance = new TaskServiceV1Api(defaultClient);
        String id = "id_example"; // String | 
        Task task = new Task(); // Task | 
        try {
            ApiResponse<Task> response = apiInstance.updateTaskWithHttpInfo(id, task);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling TaskServiceV1Api#updateTask");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **id** | **String**|  | |
| **task** | [**Task**](Task.md)|  | |

### Return type

ApiResponse<[**Task**](Task.md)>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

