/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v2x.labitem;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ED;
import ca.uhn.hl7v2.model.v25.datatype.FN;
import ca.uhn.hl7v2.model.v25.datatype.FT;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.SN;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TX;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.model.v25.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.ORU_R01_PATIENT;
import ca.uhn.hl7v2.model.v25.group.ORU_R01_PATIENT_RESULT;
import ca.uhn.hl7v2.model.v25.message.ORU_R01;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.model.EncapsulatedData;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.elexis.hl7.util.HL7Helper;
import ch.elexis.hl7.v26.Messages;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ImportLabItemReader
extends HL7Reader {
    static Logger logger = LoggerFactory.getLogger(HL7ImportLabItemReader.class);

    public HL7ImportLabItemReader(Message message) {
        super(message);
    }

    @Override
    public String getSender() throws ElexisException {
        String sender;
        try {
            MSH msh = (MSH)this.message.get("MSH");
            sender = msh.getMsh4_SendingFacility().getNamespaceID().getValue();
            if (sender == null) {
                sender = "";
            }
        }
        catch (HL7Exception e) {
            throw new ElexisException(e.getMessage(), (Throwable)e);
        }
        return sender;
    }

    @Override
    public ObservationMessage readObservation(HL7PatientResolver patientResolver, boolean createIfNotFound) throws ElexisException {
        this.observation = null;
        ORU_R01 oru_r01 = (ORU_R01)this.message;
        try {
            this.patientResolver = patientResolver;
            this.setPatient(oru_r01, createIfNotFound);
            int oderObservationGroupCount = oru_r01.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            int idx = 0;
            while (idx < oderObservationGroupCount) {
                ORU_R01_ORDER_OBSERVATION orderObservationGroup = oru_r01.getPATIENT_RESULT().getORDER_OBSERVATION(idx);
                OBR obr = orderObservationGroup.getOBR();
                String obrObservationDateTime = obr.getObr7_ObservationDateTime().getTs1_Time().getValue();
                this.setOrderComment(oru_r01, idx, obrObservationDateTime);
                int observationGroupCount = orderObservationGroup.getOBSERVATIONReps();
                int i = 0;
                while (i < observationGroupCount) {
                    ORU_R01_OBSERVATION observationGroup = orderObservationGroup.getOBSERVATION(i);
                    String commentNTE = this.getComments(orderObservationGroup, i);
                    String group = "";
                    String sequence = "";
                    int k = 0;
                    while (k < 2) {
                        CE ce = obr.getObr47_FillerSupplementalServiceInformation(k);
                        if (ce != null) {
                            String code = "";
                            if (ce.getCe3_NameOfCodingSystem() != null) {
                                code = ce.getCe3_NameOfCodingSystem().getValue();
                            }
                            group = this.getGroup(code, ce);
                            sequence = this.getSequence(code, ce);
                        }
                        ++k;
                    }
                    this.readOBXResults(observationGroup, obr, commentNTE, group, sequence, obrObservationDateTime);
                    ++i;
                }
                ++idx;
            }
        }
        catch (HL7Exception | ParseException e) {
            throw new ElexisException(e.getMessage(), e);
        }
        return this.observation;
    }

    private void setPatient(ORU_R01 oru, boolean createIfNotFound) throws ParseException, HL7Exception {
        String sendingApplication = oru.getMSH().getMsh3_SendingApplication().getHd1_NamespaceID().getValue();
        String sendingFacility = oru.getMSH().getMsh4_SendingFacility().getHd1_NamespaceID().getValue();
        String dateTimeOfMessage = oru.getMSH().getMsh7_DateTimeOfMessage().getTs1_Time().getValue();
        PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
        String patid = pid.getPatientID().getIDNumber().getValue();
        String patid_alternative = pid.getPid4_AlternatePatientIDPID(0).getCx1_IDNumber().getValue();
        String lastName = "";
        String firstName = "";
        if (pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue() != null) {
            lastName = pid.getPid5_PatientName(0).getFamilyName().getFn1_Surname().getValue();
        }
        if (pid.getPid5_PatientName(0).getGivenName().getValue() != null) {
            firstName = pid.getPid5_PatientName(0).getGivenName().getValue();
        }
        String patientName = firstName + " " + lastName;
        String patientNotesAndComments = this.readPatientNotesAndComments(oru.getPATIENT_RESULT().getPATIENT());
        String orderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PlacerOrderNumber().getEi1_EntityIdentifier().getValue();
        this.observation = new ObservationMessage(sendingApplication, sendingFacility, dateTimeOfMessage, patid, patientName, patientNotesAndComments, patid_alternative, orderNumber);
    }

    private void setOrderComment(ORU_R01 oru, int idx, String obsDate) throws ParseException {
        String orderCommentNTE = this.getComments(oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx), -1);
        if (orderCommentNTE != null) {
            this.observation.add(new TextData("Kommentar", orderCommentNTE, obsDate, "00 Kommentar", null));
        }
    }

    private String readPatientNotesAndComments(ORU_R01_PATIENT patient) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < patient.getNTEReps()) {
            FT comment = patient.getNTE(i).getComment(0);
            sb.append(comment.toString());
            if (patient.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private String getComments(ORU_R01_ORDER_OBSERVATION oobs, int i) {
        Object commentNTE = null;
        int size = oobs.getNTEReps();
        if (i > -1) {
            size = oobs.getOBSERVATION(i).getNTEReps();
        }
        int n = 0;
        while (n < size) {
            FT comment;
            NTE nte = oobs.getNTE(n);
            if (i > -1) {
                nte = oobs.getOBSERVATION(i).getNTE(n);
            }
            if ((comment = nte.getNte3_Comment(0)) != null) {
                commentNTE = commentNTE != null ? commentNTE + "\n" : "";
                if (comment.getValue() != null) {
                    commentNTE = (String)commentNTE + comment.getValue();
                }
            }
            ++n;
        }
        return commentNTE;
    }

    private void readOBXResults(ORU_R01_OBSERVATION observationGroup, OBR obr, String commentNTE, String group, String sequence, String defaultDateTime) throws ParseException {
        OBX obx = observationGroup.getOBX();
        String valueType = obx.getObx2_ValueType().getValue();
        if (StringUtils.isBlank((CharSequence)valueType)) {
            logger.warn("OBX ValueType fehlt \u2013 verwende Fallback 'TX'");
            valueType = "TX";
        }
        String name = "";
        String itemCode = "";
        String unit = "";
        String range = "";
        String observationTime = "";
        String status = "";
        if (valueType != null && valueType.equals("ED")) {
            String observationId = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
            if (!"DOCUMENT".equals(observationId)) {
                logger.warn(MessageFormat.format(Messages.HL7_ORU_R01_Error_WrongObsIdentifier, observationId));
            }
            ED ed = (ED)obx.getObx5_ObservationValue(0).getData();
            String filename = ed.getEd3_DataSubtype().getValue();
            String encoding = ed.getEd4_Encoding().getValue();
            String data = ed.getEd5_Data().getValue();
            sequence = obx.getSetIDOBX().getValue();
            observationTime = obx.getObx14_DateTimeOfTheObservation().getTs1_Time().getValue();
            this.observation.add(new EncapsulatedData(filename, encoding, data, observationTime, commentNTE, group, sequence));
        } else if (valueType != null && this.isTextOrNumeric(valueType)) {
            name = this.determineName(obx, obr);
            String value = "";
            Type tmp = obx.getObx5_ObservationValue(0).getData();
            if (tmp instanceof ST) {
                value = ((ST)tmp).getValue();
            } else if (tmp instanceof TX) {
                value = ((TX)tmp).getValue();
                if (value.contains("\\.br")) {
                    value = this.parseTextValue(value);
                }
            } else if (tmp instanceof FT) {
                value = this.parseFormattedTextValue(((FT)tmp).getValue());
            } else if (tmp instanceof NM) {
                value = ((NM)tmp).getValue();
            } else if (tmp instanceof SN) {
                value = ((SN)tmp).getSn2_Num1().getValue();
            } else if (tmp instanceof CE) {
                value = ((CE)tmp).getCe2_Text().getValue();
            }
            itemCode = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
            unit = obx.getObx6_Units().getCe1_Identifier().getValue();
            range = obx.getObx7_ReferencesRange().getValue();
            String rawAbnormalFlags = obx.getObx8_AbnormalFlags(0).getValue();
            Boolean flag = this.isPathologic(rawAbnormalFlags);
            observationTime = obx.getObx14_DateTimeOfTheObservation().getTs1_Time().getValue();
            status = obx.getObx11_ObservationResultStatus().getValue();
            LabResultData lrd = new LabResultData(itemCode, name, unit, value, range, flag, rawAbnormalFlags, defaultDateTime, observationTime, commentNTE, group, sequence, status, this.extractName((Primitive)obx.getObx4_ObservationSubID()));
            if (valueType.equals("NM") || valueType.equals("SN")) {
                lrd.setIsNumeric(true);
            } else if (valueType.equals("TX")) {
                lrd.setIsPlainText(true);
            } else if (valueType.equals("FT")) {
                lrd.setIsFormatedText(true);
            }
            this.observation.add(lrd);
        } else {
            logger.error(MessageFormat.format("Value type {0} is not implemented!", valueType));
        }
    }

    private String determineName(OBX obx, OBR obr) {
        Object prefix = "";
        ST ce2_Text = obr.getUniversalServiceIdentifier().getCe2_Text();
        if (ce2_Text != null && StringUtils.isNotBlank((CharSequence)ce2_Text.toString())) {
            prefix = ce2_Text.toString() + " - ";
        }
        ArrayList<String> possibleNames = new ArrayList<String>();
        possibleNames.add((String)prefix + obx.getObx4_ObservationSubID().getValue());
        possibleNames.add((String)prefix + obx.getObx3_ObservationIdentifier().getCe2_Text().getValue());
        possibleNames.add((String)prefix + obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue());
        return HL7Helper.determineName(possibleNames);
    }

    @Override
    public OrcMessage getOrcMessage() {
        try {
            ORU_R01_ORDER_OBSERVATION oo;
            ORU_R01_PATIENT_RESULT pr;
            ORU_R01 oru = (ORU_R01)this.message;
            if (oru != null && (pr = oru.getPATIENT_RESULT()) != null && (oo = pr.getORDER_OBSERVATION()) != null) {
                return this.extractOrc(oo.getORC());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HL7Reader.class).warn("orc parsing failed", (Throwable)e);
        }
        return null;
    }

    private OrcMessage extractOrc(ORC orc) throws HL7Exception {
        if (orc != null) {
            XCN[] ops;
            OrcMessage orcMessage = new OrcMessage();
            XCN[] xCNArray = ops = orc.getOrderingProvider();
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                XCN op = xCNArray[n2];
                FN fn = op.getFamilyName();
                ST familyName = null;
                if (fn != null && (familyName = fn.getSurname()) == null) {
                    familyName = fn.getOwnSurname();
                }
                this.addNameValuesToOrcMessage((Primitive)op.getGivenName(), (Primitive)familyName, orcMessage);
                ++n2;
            }
            return orcMessage;
        }
        return null;
    }

    private String getGroup(String code, CE ce) {
        if ("99DGC".equalsIgnoreCase(code) && ce.getCe2_Text() != null) {
            return ce.getCe2_Text().getValue();
        }
        return "";
    }

    private String getSequence(String code, CE ce) {
        if ("99DGP".equalsIgnoreCase(code) && ce.getCe1_Identifier() != null) {
            return ce.getCe1_Identifier().getValue();
        }
        return "";
    }
}

