/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.internal.FindingsFormat;
import ch.elexis.core.findings.util.internal.JsonStructuralFeature;
import ch.elexis.core.findings.util.internal.JsonStructuralFeatureTransformation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class FindingsFormat24
extends FindingsFormat {
    public FindingsFormat24() {
        HashMap<String, JsonStructuralFeature> conditionFields = new HashMap<String, JsonStructuralFeature>();
        conditionFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("category", new JsonStructuralFeature("category", JsonStructuralFeature.Type.ARRAY));
        conditionFields.put("code", new JsonStructuralFeature("code", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("assertedDate", new JsonStructuralFeature("assertedDate", JsonStructuralFeature.Type.PRIMITIVE));
        this.resourceFieldsMap.put("Condition", conditionFields);
        HashMap<String, JsonStructuralFeature> encounterFields = new HashMap<String, JsonStructuralFeature>();
        encounterFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        encounterFields.put("diagnosis", new JsonStructuralFeature("diagnosis", JsonStructuralFeature.Type.ARRAY));
        encounterFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("Encounter", encounterFields);
        HashMap<String, JsonStructuralFeature> procedureRequestFields = new HashMap<String, JsonStructuralFeature>();
        procedureRequestFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        procedureRequestFields.put("context", new JsonStructuralFeature("context", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("ProcedureRequest", procedureRequestFields);
    }

    @Override
    public int isFindingsFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.checkFindingsFormatProperties(resourceType, jsonObject);
    }

    private int checkFindingsFormatProperties(JsonElement resourceType, JsonObject jsonObject) {
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Condition"), jsonObject);
            }
            case "Encounter": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Encounter"), jsonObject);
            }
            case "ProcedureRequest": {
                return this.checkFields((Map)this.resourceFieldsMap.get("ProcedureRequest"), jsonObject);
            }
        }
        return 0;
    }

    @Override
    public Optional<String> convertToCurrentFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.convertToCurrentFormat(resourceType, jsonObject);
    }

    private Optional<String> convertToCurrentFormat(JsonElement resourceType, JsonObject jsonObject) {
        HashMap<String, JsonStructuralFeatureTransformation> conditionTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        conditionTransformations.put("assertedDate", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return element;
            }

            @Override
            public String transformKey(String key) {
                return "recordedDate";
            }
        });
        conditionTransformations.put("clinicalStatus", new JsonStructuralFeatureTransformation(){

            @Override
            public String transformKey(String key) {
                return key;
            }

            @Override
            public JsonElement transformValue(JsonElement element) {
                JsonArray coding = new JsonArray();
                JsonPrimitive value = (JsonPrimitive)element;
                if (StringUtils.isNotBlank((CharSequence)value.getAsString())) {
                    JsonObject newCoding = new JsonObject();
                    newCoding.add("system", (JsonElement)new JsonPrimitive("http://terminology.hl7.org/CodeSystem/condition-clinical"));
                    newCoding.add("code", (JsonElement)new JsonPrimitive(value.getAsString()));
                    coding.add((JsonElement)newCoding);
                }
                JsonObject ret = new JsonObject();
                ret.add("coding", (JsonElement)coding);
                return ret;
            }
        });
        HashMap<String, JsonStructuralFeatureTransformation> encounterTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        encounterTransformations.put("!addAfter!identifier", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                ((JsonObject)element).add("status", (JsonElement)new JsonPrimitive("finished"));
                return element;
            }

            @Override
            public String transformKey(String key) {
                throw new UnsupportedOperationException();
            }
        });
        HashMap<String, JsonStructuralFeatureTransformation> procedureRequestTransformations = new HashMap<String, JsonStructuralFeatureTransformation>();
        procedureRequestTransformations.put("resourceType", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return new JsonPrimitive("ServiceRequest");
            }

            @Override
            public String transformKey(String key) {
                return key;
            }
        });
        procedureRequestTransformations.put("context", new JsonStructuralFeatureTransformation(){

            @Override
            public JsonElement transformValue(JsonElement element) {
                return element;
            }

            @Override
            public String transformKey(String key) {
                return "encounter";
            }
        });
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.convert(conditionTransformations, jsonObject);
            }
            case "Encounter": {
                return this.convert(encounterTransformations, jsonObject);
            }
            case "ProcedureRequest": {
                return this.convert(procedureRequestTransformations, jsonObject);
            }
        }
        return Optional.empty();
    }
}

