/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ca.uhn.fhir.rest.param.DateRangeParam;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Period;

public class DateRangeParamUtil {
    public static boolean isPeriodInRange(Period period, DateRangeParam dates) {
        if (dates == null) {
            return true;
        }
        if (period == null) {
            return false;
        }
        Date lower = dates.getLowerBoundAsInstant();
        Date upper = dates.getUpperBoundAsInstant();
        Date start = period.getStart();
        Date end = period.getEnd();
        if (start != null && upper != null && start.after(upper)) {
            return false;
        }
        return end == null || lower == null || !end.before(lower);
    }

    public static boolean isDateInRange(DateTimeType dateTime, DateRangeParam dates) {
        if (dates == null) {
            return true;
        }
        if (dateTime == null) {
            return false;
        }
        LocalDate lower = LocalDate.parse(dates.getLowerBound().getValueAsString());
        LocalDate upper = LocalDate.parse(dates.getUpperBound().getValueAsString());
        LocalDateTime date = LocalDateTime.parse(dateTime.asStringValue(), DateTimeFormatter.ISO_DATE_TIME);
        if (upper != null && date.isAfter(upper.atTime(23, 59, 59))) {
            return false;
        }
        return lower == null || !date.isBefore(lower.atStartOfDay());
    }
}

