/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.ITextTemplate;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.TextTemplateCategory;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MailTextTemplate {
    public static List<ITextTemplate> load() {
        IQuery query = CoreModelServiceHolder.get().getQuery(ITextTemplate.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__CATEGORY, IQuery.COMPARATOR.EQUALS, (Object)TextTemplateCategory.MAIL);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__NAME, IQuery.ORDER.ASC);
        List allTemplates = query.execute();
        if (ContextServiceHolder.get().getActiveUser().isPresent() && !((IUser)ContextServiceHolder.get().getActiveUser().get()).isAdministrator()) {
            allTemplates = allTemplates.stream().filter(b -> MailTextTemplate.isAllOrCurrentMandator(b)).collect(Collectors.toList());
        }
        return allTemplates;
    }

    private static boolean isAllOrCurrentMandator(ITextTemplate template) {
        if (template.getMandator() == null) {
            return true;
        }
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return template.getMandator().equals(ContextServiceHolder.get().getActiveMandator().get());
        }
        return false;
    }

    public static Optional<ITextTemplate> load(String templateName) {
        Optional<ITextTemplate> mandatorTemplate;
        if (ContextServiceHolder.get().getActiveMandator().isPresent() && (mandatorTemplate = MailTextTemplate.getTemplate((IMandator)ContextServiceHolder.get().getActiveMandator().get(), templateName)).isPresent()) {
            return mandatorTemplate;
        }
        Optional<ITextTemplate> allTemplate = MailTextTemplate.getTemplate(null, templateName);
        return allTemplate;
    }

    private static Optional<ITextTemplate> getTemplate(IMandator mandator, String name) {
        IQuery query = CoreModelServiceHolder.get().getQuery(ITextTemplate.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__CATEGORY, IQuery.COMPARATOR.EQUALS, (Object)TextTemplateCategory.MAIL);
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)mandator);
        query.and((EStructuralFeature)ModelPackage.Literals.ITEXT_TEMPLATE__NAME, IQuery.COMPARATOR.EQUALS, (Object)name);
        return query.executeSingleResult();
    }

    public static class Builder
    extends AbstractBuilder<ITextTemplate> {
        public Builder() {
            super(CoreModelServiceHolder.get());
            this.object = (ITextTemplate)this.modelService.create(ITextTemplate.class);
            ((ITextTemplate)this.object).setCategory(TextTemplateCategory.MAIL);
        }

        public Builder name(String string) {
            ((ITextTemplate)this.object).setName(string);
            return this;
        }

        public Builder text(String string) {
            ((ITextTemplate)this.object).setTemplate(string);
            return this;
        }

        public Builder mandator(IMandator mandator) {
            ((ITextTemplate)this.object).setMandator(mandator);
            return this;
        }
    }
}

