/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.syntactic;

import ch.elexis.core.ui.dbcheck.CheckExec;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.core.ui.dbcheck.model.TableDescriptor;
import ch.elexis.core.ui.dbcheck.syntactic.SyntacticCheck;
import ch.rgw.tools.JdbcLink;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class SyntacticCheckPGSQL
extends SyntacticCheck {
    public SyntacticCheckPGSQL() {
        this.oklog = new StringBuilder();
        this.errlog = new StringBuilder();
    }

    @Override
    public String checkCoreTables(JdbcLink j, IProgressMonitor monitor) {
        block17: {
            String version = CheckExec.getDBVersion();
            String[] tables = DBModel.getTableModel(version);
            Connection conn = j.getConnection();
            try {
                try {
                    int i = 0;
                    while (i < tables.length) {
                        String status = "\u00dcberpr\u00fcfe Tabelle " + tables[i];
                        if (monitor != null) {
                            monitor.subTask(status);
                        }
                        this.oklog.append(status + ":\n");
                        TableDescriptor tableDetail = DBModel.getTableDescription(tables[i]);
                        String[] fields = tableDetail.getFields(version);
                        String[] fieldType = tableDetail.getFieldTypes(version);
                        int k = 0;
                        while (k < fields.length) {
                            boolean ok = false;
                            this.oklog.append(tables[i] + ": Erwarte " + fields[k] + " " + fieldType[k] + "...");
                            ResultSet rs = conn.getMetaData().getColumns(conn.getCatalog(), "%", tables[i].toLowerCase(), fields[k].toLowerCase());
                            while (rs.next()) {
                                ok = true;
                                String dataType = rs.getString(6) + "(" + rs.getString(7) + ")";
                                if (rs.getString(4).equalsIgnoreCase(fields[k]) && SyntacticCheckPGSQL.isCompatible(dataType, fieldType[k])) {
                                    this.oklog.append(" OK\n");
                                    continue;
                                }
                                this.oklog.append(" erhalte " + rs.getString(4) + " " + dataType + "\n");
                                this.errlog.append(tables[i] + ": SynErr: FeldTyp " + rs.getString(4) + " " + dataType + " inkorrekt, erwarte " + fields[k] + " " + fieldType[k] + "\n");
                            }
                            if (!ok) {
                                this.oklog.append(" nicht gefunden\n");
                                this.errlog.append(tables[i] + ": SynErr: Feld " + fields[k] + " " + fieldType[k] + " nicht gefunden!\n");
                            }
                            rs.close();
                            ++k;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
                    StatusManager.getManager().handle((IStatus)status, 2);
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.oklog.toString();
    }
}

