/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.PersistentObject;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.JdbcLink;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixBestellungen217
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        int invalidArt;
        int updateCnt;
        int oldCnt;
        StringBuilder output;
        block23: {
            JdbcLink.Stm stm;
            block24: {
                output = new StringBuilder();
                pm.beginTask("Bitte warten, Bestellungen werden reparieren ...", -1);
                stm = null;
                ResultSet resultSet = null;
                oldCnt = 0;
                updateCnt = 0;
                invalidArt = 0;
                try {
                    stm = PersistentObject.getConnection().getStatement();
                    resultSet = stm.query("SELECT * FROM HEAP2");
                    while (resultSet.next()) {
                        byte[] compressed;
                        byte[] decompressed;
                        pm.worked(1);
                        String ID = resultSet.getString("id");
                        String[] entry = ID.split(":");
                        if (entry.length != 3) continue;
                        ++oldCnt;
                        Bestellung existingBestellung = Bestellung.load((String)ID);
                        if (!existingBestellung.exists() || (decompressed = CompEx.expand((byte[])(compressed = resultSet.getBytes("Contents")))) == null) continue;
                        String content = new String(decompressed, "utf-8");
                        if (!content.isEmpty()) {
                            if (!this.testLoad(content)) {
                                ++invalidArt;
                                continue;
                            }
                            existingBestellung.set("Liste", content);
                            ++updateCnt;
                            continue;
                        }
                        existingBestellung.set("Liste", "");
                        ++updateCnt;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    if (stm != null) {
                        PersistentObject.getConnection().releaseStatement(stm);
                    }
                    break block23;
                }
                catch (SQLException e) {
                    try {
                        e.printStackTrace();
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (stm != null) {
                            PersistentObject.getConnection().releaseStatement(stm);
                        }
                    }
                }
                if (resultSet == null) break block24;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (stm != null) {
                PersistentObject.getConnection().releaseStatement(stm);
            }
        }
        output.append(oldCnt + " alte Bestellungen gefunden.\n");
        output.append(invalidArt + " alte Bestellungen mit nicht mehr existenten Artikeln.\n");
        output.append(updateCnt + " neue Bestellungen repariert.\n");
        pm.done();
        return output.toString();
    }

    private boolean testLoad(String items) {
        String[] it;
        String[] stringArray = it = items.split(";");
        int n = it.length;
        int n2 = 0;
        while (n2 < n) {
            Artikel art;
            String i = stringArray[n2];
            String[] fld = i.split(",");
            if (fld.length == 2 && (art = Artikel.load((String)fld[0])) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String getMaintenanceDescription() {
        return "Bestellungen ohne Inhalt nach upgrade auf 2.1.7 reparieren";
    }
}

