/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public enum TaskState {
    DRAFT("DRAFT"),
    QUEUED("QUEUED"),
    READY("READY"),
    IN_PROGRESS("IN_PROGRESS"),
    CANCELLED("CANCELLED"),
    ON_HOLD("ON_HOLD"),
    COMPLETED("COMPLETED"),
    COMPLETED_WARN("COMPLETED_WARN"),
    COMPLETED_MANUAL("COMPLETED_MANUAL"),
    FAILED("FAILED");

    private String value;

    private TaskState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TaskState fromValue(String value) {
        TaskState[] taskStateArray = TaskState.values();
        int n = taskStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskState b = taskStateArray[n2];
            if (b.value.equals(value)) {
                return b;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format(Locale.ROOT, "%s=%s", prefix, this.toString());
    }
}

