/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.model;

import ch.myelexis.server.client.ApiClient;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "singleton", "description", "defaultRunContext"})
public class IdentifiedRunnable {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_SINGLETON = "singleton";
    @Nullable
    private Boolean singleton;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_DEFAULT_RUN_CONTEXT = "defaultRunContext";
    @Nullable
    private Map<String, String> defaultRunContext = new HashMap<String, String>();

    public IdentifiedRunnable id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public IdentifiedRunnable singleton(@Nullable Boolean singleton) {
        this.singleton = singleton;
        return this;
    }

    @Nullable
    @JsonProperty(value="singleton", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSingleton() {
        return this.singleton;
    }

    @JsonProperty(value="singleton", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleton(@Nullable Boolean singleton) {
        this.singleton = singleton;
    }

    public IdentifiedRunnable description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public IdentifiedRunnable defaultRunContext(@Nullable Map<String, String> defaultRunContext) {
        this.defaultRunContext = defaultRunContext;
        return this;
    }

    public IdentifiedRunnable putDefaultRunContextItem(String key, String defaultRunContextItem) {
        if (this.defaultRunContext == null) {
            this.defaultRunContext = new HashMap<String, String>();
        }
        this.defaultRunContext.put(key, defaultRunContextItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultRunContext", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getDefaultRunContext() {
        return this.defaultRunContext;
    }

    @JsonProperty(value="defaultRunContext", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRunContext(@Nullable Map<String, String> defaultRunContext) {
        this.defaultRunContext = defaultRunContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifiedRunnable identifiedRunnable = (IdentifiedRunnable)o;
        return Objects.equals(this.id, identifiedRunnable.id) && Objects.equals(this.singleton, identifiedRunnable.singleton) && Objects.equals(this.description, identifiedRunnable.description) && Objects.equals(this.defaultRunContext, identifiedRunnable.defaultRunContext);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.singleton, this.description, this.defaultRunContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentifiedRunnable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    singleton: ").append(this.toIndentedString(this.singleton)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    defaultRunContext: ").append(this.toIndentedString(this.defaultRunContext)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format(Locale.ROOT, "%sid%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getId()))));
        }
        if (this.getSingleton() != null) {
            joiner.add(String.format(Locale.ROOT, "%ssingleton%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getSingleton()))));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format(Locale.ROOT, "%sdescription%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getDescription()))));
        }
        if (this.getDefaultRunContext() != null) {
            for (String _key : this.getDefaultRunContext().keySet()) {
                joiner.add(String.format(Locale.ROOT, "%sdefaultRunContext%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, _key, containerSuffix), this.getDefaultRunContext().get(_key), ApiClient.urlEncode(ApiClient.valueToString(this.getDefaultRunContext().get(_key)))));
            }
        }
        return joiner.toString();
    }
}

