/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.tasks.internal;

import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.tasks.BillLabResultOnCreationIdentifiedRunnable;
import ch.elexis.core.importer.div.tasks.BillLabResultOnCreationTemplateTaskDescriptor;
import ch.elexis.core.importer.div.tasks.internal.HL7ImporterIIdentifiedRunnable;
import ch.elexis.core.importer.div.tasks.internal.HL7ImporterTemplateTaskDescriptor;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.model.ITaskService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true)
public class HL7ImporterIdentifiedRunnableFactory
implements IIdentifiedRunnableFactory {
    @Inject
    @Reference
    ITaskService taskService;
    @Inject
    IModelService coreModelService;
    @Inject
    @Reference
    ILabImportUtil labimportUtil;
    @Inject
    @Reference
    IVirtualFilesystemService vfsService;
    @Inject
    @Reference
    IAccessControlService accessControlService;

    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private void setModelService(IModelService modelService) {
        this.coreModelService = modelService;
    }

    @PostConstruct
    @Activate
    void activate() {
        this.accessControlService.doPrivileged(() -> {
            try {
                HL7ImporterTemplateTaskDescriptor.assertTemplate(this.taskService);
                BillLabResultOnCreationTemplateTaskDescriptor.assertTemplate(this.taskService);
            }
            catch (TaskException e) {
                LoggerFactory.getLogger(this.getClass()).error("initialize", (Throwable)e);
                throw new ComponentException((Throwable)e);
            }
            this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
        });
    }

    @PreDestroy
    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new HL7ImporterIIdentifiedRunnable(this.coreModelService, this.labimportUtil, this.vfsService));
        ret.add(new BillLabResultOnCreationIdentifiedRunnable(this.coreModelService, null));
        return ret;
    }
}

