/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import org.cef.browser.CefBrowser_N;
import org.cef.callback.CefDragData;
import org.cef.misc.Point;

class CefDropTargetListener
implements DropTargetListener {
    private CefBrowser_N browser_;
    private CefDragData dragData_ = null;
    private int dragOperations_ = 1;
    private int dragModifiers_ = 0;
    private int acceptOperations_ = 1;

    CefDropTargetListener(CefBrowser_N browser) {
        this.browser_ = browser;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        this.CreateDragData(event);
        this.browser_.dragTargetDragEnter(this.dragData_, new Point(event.getLocation().x, event.getLocation().y), this.dragModifiers_, this.dragOperations_);
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.AssertDragData();
        this.browser_.dragTargetDragLeave();
        this.ClearDragData();
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.AssertDragData();
        this.browser_.dragTargetDragOver(new Point(event.getLocation().x, event.getLocation().y), this.dragModifiers_, this.dragOperations_);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        this.AssertDragData();
        this.acceptOperations_ = event.getDropAction();
        switch (this.acceptOperations_) {
            case 0x40000000: {
                this.dragOperations_ = 2;
                this.dragModifiers_ = 6;
                break;
            }
            case 1: {
                this.dragOperations_ = 1;
                this.dragModifiers_ = 4;
                break;
            }
            case 2: {
                this.dragOperations_ = 16;
                this.dragModifiers_ = 2;
                break;
            }
            case 0: {
                this.dragOperations_ = 1;
                this.dragModifiers_ = 0;
                this.acceptOperations_ = 1;
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        this.AssertDragData();
        this.browser_.dragTargetDrop(new Point(event.getLocation().x, event.getLocation().y), this.dragModifiers_);
        event.acceptDrop(this.acceptOperations_);
        event.dropComplete(true);
        this.ClearDragData();
    }

    private void CreateDragData(DropTargetDragEvent event) {
        assert (this.dragData_ == null);
        this.dragData_ = CefDropTargetListener.createDragData(event);
        this.dropActionChanged(event);
    }

    private void AssertDragData() {
        assert (this.dragData_ != null);
    }

    private void ClearDragData() {
        this.dragData_ = null;
    }

    private static CefDragData createDragData(DropTargetDragEvent event) {
        DataFlavor[] flavors;
        CefDragData dragData = CefDragData.create();
        Transferable transferable = event.getTransferable();
        DataFlavor[] dataFlavorArray = flavors = transferable.getTransferDataFlavors();
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            try {
                if (flavor.isFlavorTextType()) {
                    Object ob = transferable.getTransferData(flavor);
                    if (ob instanceof String) {
                        dragData.setFragmentText((String)ob);
                    }
                } else if (flavor.isFlavorJavaFileListType()) {
                    List files = (List)transferable.getTransferData(flavor);
                    for (File file : files) {
                        dragData.addFile(file.getPath(), file.getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return dragData;
    }
}

