/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Messages;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabMapping
extends PersistentObject {
    private static Logger logger = LoggerFactory.getLogger(LabMapping.class);
    public static final String TABLENAME = "at_medevit_elexis_labmap";
    public static final String VERSIONID = "VERSION";
    public static final String FLD_ORIGINID = "originid";
    public static final String FLD_ITEMNAME = "itemname";
    public static final String FLD_LABITEMID = "labitemid";
    public static final String FLD_CHARGE = "charge";
    private static StringBuilder notImported = new StringBuilder();
    private static int importerLabItemsCreated = 0;

    static {
        LabMapping.addMapping(TABLENAME, FLD_ITEMNAME, FLD_ORIGINID, FLD_LABITEMID, FLD_CHARGE);
    }

    public LabMapping() {
    }

    public LabMapping(String id) {
        super(id);
    }

    public static LabMapping load(String id) {
        return new LabMapping(id);
    }

    public LabMapping(String contactId, String itemName, String labItemId, boolean charge) {
        LabMapping existing = LabMapping.getByContactAndItemName(contactId, itemName);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", contactId, itemName));
        }
        this.create(null);
        this.set(FLD_ORIGINID, contactId);
        this.set(FLD_ITEMNAME, itemName);
        this.set(FLD_LABITEMID, labItemId);
        this.setCharge(charge);
    }

    public void setCharge(boolean charge) {
        this.set(FLD_CHARGE, charge ? "1" : "0");
    }

    public boolean isCharge() {
        String chargeStr = LabMapping.checkNull(this.get(FLD_CHARGE));
        if (chargeStr.isEmpty()) {
            return false;
        }
        return chargeStr.equals("1");
    }

    public LabItem getLabItem() {
        String labItemId = LabMapping.checkNull(this.get(FLD_LABITEMID));
        if (labItemId.isEmpty()) {
            return null;
        }
        LabItem ret = LabItem.load(labItemId);
        if (ret.exists()) {
            return ret;
        }
        logger.error(String.format("LabItem [%s] does not exist.", this.get(FLD_LABITEMID)));
        return ret;
    }

    public Kontakt getOrigin() {
        String originId = LabMapping.checkNull(this.get(FLD_ORIGINID));
        if (originId.isEmpty()) {
            return null;
        }
        Kontakt ret = Kontakt.load(originId);
        if (ret.exists()) {
            return ret;
        }
        logger.error(String.format("Kontakt [%s] does not exist.", this.get(FLD_ORIGINID)));
        return ret;
    }

    public String getItemName() {
        return LabMapping.checkNull(this.get(FLD_ITEMNAME));
    }

    public void setItemName(String itemName) {
        this.set(FLD_ITEMNAME, itemName);
    }

    @Override
    public String getLabel() {
        LabItem item = LabItem.load(this.get(FLD_LABITEMID));
        if (item.exists()) {
            return String.format("%s - %s -> %s", this.get(FLD_ORIGINID), this.get(FLD_ITEMNAME), item.getLabel());
        }
        return String.format("%s - %s -> item [%s] does not exist.", this.get(FLD_ORIGINID), this.get(FLD_ITEMNAME), this.get(FLD_LABITEMID));
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public boolean isMappingValid() {
        LabItem item = this.getLabItem();
        if (item == null || !item.exists()) {
            return false;
        }
        String itemName = this.getItemName();
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        Kontakt origin = this.getOrigin();
        return origin != null && origin.exists();
    }

    public static LabMapping getByContactAndItemName(String contactId, String itemName) {
        Query qbe = new Query(LabMapping.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add(FLD_ORIGINID, "=", contactId);
        qbe.add(FLD_ITEMNAME, "=", itemName);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("Found more then 1 mapping for origin id [%s] - [%s]", contactId, itemName));
        }
        return (LabMapping)res.get(0);
    }

    public static LabMapping getByContactAndItemId(String contactId, String itemId) {
        Query qbe = new Query(LabMapping.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add(FLD_ORIGINID, "=", contactId);
        qbe.add(FLD_LABITEMID, "=", itemId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            logger.warn(String.format("Found [%s] mappings for origin id [%s] and item id [%s]", res.size(), contactId, itemId));
            logger.info(String.format("Using mapping with item name [%s]", ((LabMapping)res.get(0)).getItemName()));
        }
        return (LabMapping)res.get(0);
    }

    public static List<LabMapping> getByLabItemId(String labItemId) {
        Query qbe = new Query(LabMapping.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add(FLD_LABITEMID, "=", labItemId);
        return qbe.execute();
    }

    public static void importMappingFromCsv(InputStream csv) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(csv));
        notImported.setLength(0);
        importerLabItemsCreated = 0;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(";", -1);
            if (parts.length < 10) {
                String reason = String.format(Messages.LabMapping_reasonLineNotValid, line, parts.length);
                logger.warn(reason);
                notImported.append(line);
                notImported.append(" -> ");
                notImported.append(reason);
                notImported.append("\n");
                continue;
            }
            if (parts[0].equalsIgnoreCase("CONTACT_NAME")) continue;
            Labor labor = null;
            List<Labor> origins = LabMapping.lookupLabor(parts[0]);
            if (origins.isEmpty()) {
                logger.warn(String.format("Could not find labor with name [%s]", parts[0]));
                labor = LabMapping.createLabor(parts[0]);
            } else {
                if (origins.size() > 1) {
                    String reason = String.format(Messages.LabMapping_reasonMoreContacts, parts[0]);
                    logger.warn(reason);
                    notImported.append(line);
                    notImported.append(" -> ");
                    notImported.append(reason);
                    notImported.append("\n");
                    continue;
                }
                labor = origins.get(0);
            }
            String laborItemName = parts[1];
            String labItemLoinc = parts[2];
            String labItemName = parts[3];
            String labItemShort = parts[4];
            String labItemRefM = parts[5];
            String labItemRefF = parts[6];
            String labItemUnit = parts[7];
            String labItemTyp = parts[8];
            String labItemGroup = parts[9];
            String labItemBillingCode = "";
            if (parts.length > 10) {
                labItemBillingCode = parts[10];
            }
            if (laborItemName == null || laborItemName.isEmpty() || labItemName == null || labItemName.isEmpty() || labItemShort == null || labItemShort.isEmpty()) {
                String reason = Messages.LabMapping_reasonDefinitionNotValid;
                logger.warn(reason);
                notImported.append(line);
                notImported.append(" -> ");
                notImported.append(reason);
                notImported.append("\n");
                continue;
            }
            LabItem labItem = null;
            List<LabItem> items = LabMapping.lookupLabItem(labItemLoinc, labor.getId(), labItemShort, labItemRefM, labItemRefF, labItemUnit);
            if (items.isEmpty()) {
                logger.warn(String.format("Could not find labor item with loinc [%s] and shortname [%s]", labItemLoinc, labItemShort));
                labItem = LabMapping.createLabItem(labor.getId(), labItemName, labItemShort, labItemRefM, labItemRefF, labItemUnit, labItemTyp, labItemGroup, labItemLoinc, labItemBillingCode);
            } else {
                if (origins.size() > 1) {
                    String reason = String.format(Messages.LabMapping_reasonMoreLabItems, labItemLoinc, labItemShort);
                    logger.warn(reason);
                    notImported.append(line);
                    notImported.append(" -> ");
                    notImported.append(reason);
                    notImported.append("\n");
                    continue;
                }
                labItem = items.get(0);
            }
            LabMapping existing = LabMapping.getByContactAndItemName(labor.getId(), laborItemName);
            if (existing != null) {
                logger.info(String.format("Merging mapping [%s] - [%s] -> [%s] - [%s]", labor.getKuerzel(), laborItemName, labItemLoinc, labItemShort));
                LabMapping.mergeMapping(labor, laborItemName, labItem);
                continue;
            }
            logger.info(String.format("Creating mapping [%s] - [%s] -> [%s] - [%s]", labor.getKuerzel(), laborItemName, labItemLoinc, labItemShort));
            LabMapping.createMapping(labor, parts[1], labItem);
        }
        if (notImported.length() > 0) {
            throw new IOException(notImported.toString());
        }
    }

    private static LabItem createLabItem(String laborId, String labItemName, String labItemShort, String labItemRefM, String labItemRefF, String labItemUnit, String labItemTyp, String labItemGroup, String labItemLoinc, String labItemBillingCode) {
        logger.warn(String.format("Creating new labor item with name [%s] and shortname [%s] loinc [%s]", labItemName, labItemShort, labItemLoinc));
        LabItem item = new LabItem(labItemShort, labItemName, Labor.load(laborId), labItemRefM, labItemRefF, labItemUnit, LabMapping.getLabItemTyp(labItemTyp), labItemGroup, Integer.toString(importerLabItemsCreated++));
        if (labItemLoinc != null && !labItemLoinc.isEmpty()) {
            item.setLoincCode(labItemLoinc);
        }
        if (labItemBillingCode != null && !labItemBillingCode.isEmpty()) {
            item.setBillingCode(labItemBillingCode);
        }
        return item;
    }

    private static LabItemTyp getLabItemTyp(String labItemTyp) {
        if (labItemTyp.equalsIgnoreCase("numeric")) {
            return LabItemTyp.NUMERIC;
        }
        if (labItemTyp.equalsIgnoreCase("absolute")) {
            return LabItemTyp.ABSOLUTE;
        }
        if (labItemTyp.equalsIgnoreCase("text")) {
            return LabItemTyp.TEXT;
        }
        return LabItemTyp.NUMERIC;
    }

    private static Labor createLabor(String labName) {
        logger.warn("Creating new labor with name [" + labName + "]");
        return new Labor(labName, "Labor " + labName);
    }

    private static List<Labor> lookupLabor(String labName) {
        Query qbe = new Query(Labor.class);
        qbe.add("Bezeichnung1", "LIKE", "%" + labName + "%");
        List<Labor> list = qbe.execute();
        return list;
    }

    private static List<LabItem> lookupLabItem(String loinc, String laborId, String shortDesc, String refM, String refW, String unit) {
        List<LabItem> labItems = null;
        if (loinc != null && !loinc.isEmpty()) {
            Query qli = new Query(LabItem.class);
            qli.add("loinccode", "=", loinc.trim());
            labItems = qli.execute();
            if (labItems.size() == 1) {
                return labItems;
            }
        }
        return LabMapping.lookupLabItem(laborId, shortDesc, refM, refW, unit);
    }

    private static List<LabItem> lookupLabItem(String laborId, String shortDesc, String refM, String refW, String unit) {
        List<LabItem> items = LabItem.getLabItems(null, shortDesc, refM, refW, unit);
        if (!items.isEmpty()) {
            ArrayList<LabItem> ret = new ArrayList<LabItem>();
            for (LabItem labItem : items) {
                List<LabMapping> mappings = LabMapping.getByLabItemId(labItem.getId());
                for (LabMapping labMapping : mappings) {
                    if (!labMapping.get(FLD_ORIGINID).equals(laborId)) continue;
                    ret.add(labItem);
                }
            }
            return ret;
        }
        return items;
    }

    private static void createMapping(Kontakt origin, String itemName, LabItem item) {
        new LabMapping(origin.getId(), itemName, item.getId(), false);
    }

    private static void mergeMapping(Kontakt origin, String itemName, LabItem item) {
        LabMapping mapping = LabMapping.getByContactAndItemName(origin.getId(), itemName);
        mapping.set(FLD_LABITEMID, item.getId());
    }
}

