/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.types.RelationshipType;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Query;
import java.util.List;
import java.util.UUID;

public class BezugsKontaktRelation {
    public static String VALUE_SEPERATOR = ";";
    private String name;
    private RelationshipType srcRelationType;
    private RelationshipType destRelationType;
    private final String id;

    public BezugsKontaktRelation(BezugsKontaktRelation bezugsKontaktRelation) {
        this.id = bezugsKontaktRelation.getId();
        this.name = bezugsKontaktRelation.getName();
        this.srcRelationType = bezugsKontaktRelation.getSrcRelationType();
        this.destRelationType = bezugsKontaktRelation.getDestRelationType();
    }

    public BezugsKontaktRelation(BezugsKontakt bezugsKontakt) {
        if (bezugsKontakt != null && bezugsKontakt.exists()) {
            this.id = bezugsKontakt.getId();
            try {
                this.name = bezugsKontakt.getBezug();
                this.srcRelationType = RelationshipType.get((int)Integer.parseInt(bezugsKontakt.get("otherRType")));
                this.destRelationType = RelationshipType.get((int)Integer.parseInt(bezugsKontakt.get("myRType")));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.id = UUID.randomUUID().toString();
        }
    }

    public BezugsKontaktRelation() {
        this.id = UUID.randomUUID().toString();
    }

    public BezugsKontaktRelation(String name, RelationshipType srcRelationType, RelationshipType destRelationType) {
        this();
        this.name = name;
        this.srcRelationType = srcRelationType;
        this.destRelationType = destRelationType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSrcRelationType(RelationshipType srcRelationType) {
        this.srcRelationType = srcRelationType;
    }

    public RelationshipType getSrcRelationType() {
        return this.srcRelationType;
    }

    public void setDestRelationType(RelationshipType destRelationType) {
        this.destRelationType = destRelationType;
    }

    public RelationshipType getDestRelationType() {
        return this.destRelationType;
    }

    public BezugsKontaktRelation loadValuesByCfg(String cfgKey) {
        String[] cfgParts = cfgKey.split(VALUE_SEPERATOR);
        int length = cfgParts.length;
        if (length > 0) {
            this.setName(cfgParts[0]);
            if (length > 1) {
                this.setSrcRelationType(RelationshipType.get((int)this.getIntValue(cfgParts[1])));
                if (length > 2) {
                    this.setDestRelationType(RelationshipType.get((int)this.getIntValue(cfgParts[2])));
                }
            } else {
                this.setSrcRelationType(RelationshipType.AGENERIC);
                this.setDestRelationType(RelationshipType.AGENERIC);
            }
        }
        return this;
    }

    public String getCfgString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append(VALUE_SEPERATOR);
        buffer.append(this.srcRelationType != null ? this.srcRelationType.getValue() : 0);
        buffer.append(VALUE_SEPERATOR);
        buffer.append(this.destRelationType != null ? this.destRelationType.getValue() : 0);
        return buffer.toString();
    }

    private int getIntValue(String txt) {
        try {
            return Integer.parseInt(txt);
        }
        catch (NumberFormatException numberFormatException) {
            return RelationshipType.AGENERIC.getValue();
        }
    }

    public void updateToNewBezugKontakt(BezugsKontaktRelation newBezugKontaktRelation) {
        List<BezugsKontakt> bezugsKontakts = this.findAllBezugKontaksByName(this.getName(), true);
        for (BezugsKontakt bezugsKontakt : bezugsKontakts) {
            bezugsKontakt.updateRelation(newBezugKontaktRelation);
        }
    }

    public List<BezugsKontakt> findAllBezugKontaksByName(String name, boolean ignoreCase) {
        Query query = new Query(BezugsKontakt.class);
        query.add("Bezug", "=", name, ignoreCase);
        return query.execute();
    }

    public String getId() {
        return this.id;
    }
}

