/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.events.ElexisStatusProgressMonitor;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRunner {
    static Logger log = LoggerFactory.getLogger((String)SqlRunner.class.getName());
    private List<String> sqlStrings = new ArrayList<String>();
    private List<UpdateDbSql> sql;
    private String pluginId;
    private JdbcLink jdbcl;

    public SqlRunner(String[] sql, String pluginId) {
        int i = 0;
        while (i < sql.length) {
            this.sqlStrings.add(sql[i]);
            ++i;
        }
        this.pluginId = pluginId;
    }

    public SqlRunner(String[] sql, String pluginId, @Nullable JdbcLink jdbcl) {
        this(sql, pluginId);
        this.jdbcl = jdbcl;
    }

    public boolean runSql() {
        this.sql = new ArrayList<UpdateDbSql>();
        for (String sqlString : this.sqlStrings) {
            this.sql.add(new UpdateDbSql(sqlString));
        }
        ElexisStatusProgressMonitor ipm = new ElexisStatusProgressMonitor("Running DB Script", this.sql.size());
        ElexisEvent progress = new ElexisEvent(ipm, ElexisStatusProgressMonitor.class, 512, 1000);
        ElexisEventDispatcher.getInstance().fire(progress);
        for (UpdateDbSql update : this.sql) {
            ipm.subTask(update.getSql());
            update.run();
            ipm.worked(1);
        }
        ipm.done();
        for (UpdateDbSql update : this.sql) {
            if (update.getStatus() != SqlStatus.FAIL) continue;
            return false;
        }
        return true;
    }

    static enum SqlStatus {
        NONE,
        EXECUTE,
        SUCCESS,
        FAIL;

    }

    protected class UpdateDbSql
    implements Runnable {
        private String sql;
        private SqlStatus status;

        protected UpdateDbSql(String sql) {
            this.sql = sql;
            this.status = SqlStatus.NONE;
        }

        @Override
        public void run() {
            JdbcLink.Stm statement = null;
            JdbcLink link = null;
            try {
                try {
                    String sqlString;
                    link = SqlRunner.this.jdbcl == null ? PersistentObject.getConnection() : SqlRunner.this.jdbcl;
                    statement = link.getStatement();
                    this.setStatus(SqlStatus.EXECUTE);
                    ByteArrayInputStream scriptStream = new ByteArrayInputStream(this.sql.getBytes("UTF-8"));
                    while ((sqlString = JdbcLink.readStatement((InputStream)scriptStream)) != null) {
                        try {
                            statement.exec(link.translateFlavor(sqlString));
                        }
                        catch (JdbcLinkException e) {
                            this.setStatus(SqlStatus.FAIL);
                            log.error("Error " + e.getMessage() + " during db update", (Throwable)e);
                            e.printStackTrace();
                            try {
                                ElexisStatus status = new ElexisStatus(4, SqlRunner.this.pluginId, 0, "Error " + e.getMessage() + " during db update", (Exception)((Object)e));
                                ElexisStatus.fire((ElexisStatus)status);
                            }
                            catch (AssertionFailedException assertionFailedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.setStatus(SqlStatus.FAIL);
                    try {
                        ElexisStatus status = new ElexisStatus(4, SqlRunner.this.pluginId, 0, "Error " + e.getMessage() + " during db update", (Exception)e);
                        ElexisStatus.fire((ElexisStatus)status);
                    }
                    catch (AssertionFailedException appnotinit) {
                        log.error("Error " + e.getMessage() + " during db update", (Throwable)appnotinit);
                    }
                    if (link != null && statement != null) {
                        link.releaseStatement(statement);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (link != null && statement != null) {
                    link.releaseStatement(statement);
                }
                throw throwable;
            }
            if (link != null && statement != null) {
                link.releaseStatement(statement);
            }
            if (this.getStatus() == SqlStatus.EXECUTE) {
                this.setStatus(SqlStatus.SUCCESS);
            }
        }

        public void setStatus(SqlStatus status) {
            this.status = status;
        }

        public SqlStatus getStatus() {
            return this.status;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

