/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.events.MessageEvent;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ResultAdapter {
    private static final String PLUGIN_ID = "ch.elexis";

    public static IStatus getResultAsStatus(Result result) {
        if (result.isOK()) {
            return Status.OK_STATUS;
        }
        List list = result.getMessages();
        if (list.size() == 1) {
            Result.msg r = (Result.msg)list.get(0);
            return new Status(ResultAdapter.getSeverityAsStatus(r.getSeverity()), PLUGIN_ID, r.getCode(), r.getText() == null ? "?" : r.getText(), null);
        }
        ArrayList<Status> as = new ArrayList<Status>();
        Result.msg r = (Result.msg)list.get(0);
        for (Result.msg m : list) {
            as.add(new Status(ResultAdapter.getSeverityAsStatus(m.getSeverity()), PLUGIN_ID, m.getCode(), m.getText(), null));
            if (m.getSeverity().ordinal() <= r.getSeverity().ordinal()) continue;
            r = m;
        }
        return new MultiStatus(PLUGIN_ID, r.getCode(), as.toArray(new IStatus[0]), r.getText() == null ? "?" : r.getText(), null);
    }

    public static int getSeverityAsStatus(Result.SEVERITY severity) {
        switch (severity.ordinal()) {
            case 0: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 1;
            }
        }
        return 4;
    }

    public static void displayResult(Result result, String title) {
        MessageEvent.fireError((String)title, (String)result.toString());
    }
}

