/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.events.ClassToModelInterfaceService;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class NoPoUtil {
    private static PersistentObjectFactory poFactory = new PersistentObjectFactory();
    private static ClassToModelInterfaceService classToModelInterfaceService;

    public static <T> T loadAsPersistentObject(Identifiable identifiable, Class<T> clazz) {
        PersistentObject loaded = NoPoUtil.loadAsPersistentObject(identifiable);
        if (loaded != null && !clazz.isAssignableFrom(loaded.getClass())) {
            return NoPoUtil.load(loaded, clazz);
        }
        return (T)loaded;
    }

    private static <T> T load(PersistentObject loaded, Class<T> clazz) {
        try {
            Method load = clazz.getMethod("load", String.class);
            return (T)load.invoke(null, loaded.getId());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(NoPoUtil.class).warn("Could not load [" + String.valueOf(loaded) + "] as [" + String.valueOf(clazz) + "]", (Throwable)e);
            return null;
        }
    }

    public static PersistentObject loadAsPersistentObject(Identifiable identifiable) {
        return NoPoUtil.loadAsPersistentObject(identifiable, true);
    }

    public static PersistentObject loadAsPersistentObject(Identifiable identifiable, boolean throwException) {
        if (identifiable != null) {
            PersistentObject ret;
            Optional storeToString = StoreToStringServiceHolder.get().storeToString(identifiable);
            if (storeToString.isPresent() && (ret = poFactory.createFromString((String)storeToString.get())) != null) {
                return ret;
            }
            if (throwException) {
                throw new IllegalStateException("Could not load [" + String.valueOf(identifiable) + "] [" + storeToString.orElse("?") + "] as PersistentObject");
            }
        }
        return null;
    }

    public static <T> List<T> loadAsPersistentObject(List<Identifiable> identifiables, Class<T> type) {
        if (identifiables != null && !identifiables.isEmpty()) {
            ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>();
            for (Identifiable identifiable : identifiables) {
                ret.add(NoPoUtil.loadAsPersistentObject(identifiable, true));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static <T> T[] loadAsPersistentObject(Identifiable[] identifiables, Class<T> type) {
        if (identifiables != null && identifiables.length > 0) {
            Object[] ret = (Object[])Array.newInstance(type, identifiables.length);
            int i = 0;
            while (i < identifiables.length) {
                ret[i] = NoPoUtil.loadAsPersistentObject(identifiables[i], true);
                ++i;
            }
            return ret;
        }
        return (Object[])Array.newInstance(type, 0);
    }

    public static <T> List<T> loadAsIdentifiable(List<? extends PersistentObject> persistentObjects, Class<T> type) {
        if (persistentObjects != null && !persistentObjects.isEmpty()) {
            ArrayList ret = new ArrayList();
            for (PersistentObject persistentObject : persistentObjects) {
                NoPoUtil.loadAsIdentifiable(persistentObject, type).ifPresent(identifiable -> ret.add(identifiable));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static <T> Optional<T> loadAsIdentifiable(PersistentObject persistentObject, Class<T> type) {
        if (persistentObject != null) {
            Optional loaded = CoreModelServiceHolder.get().load(persistentObject.getId(), type);
            if (loaded.isPresent()) {
                return loaded;
            }
            loaded = StoreToStringServiceHolder.get().loadFromString(persistentObject.storeToString());
            if (loaded.isPresent()) {
                return loaded;
            }
        }
        return Optional.empty();
    }

    public static void refreshIdentifiable(PersistentObject persistentObject) {
        Optional loaded = StoreToStringServiceHolder.get().loadFromString(persistentObject.storeToString());
        loaded.ifPresent(i -> CoreModelServiceHolder.get().refresh(i, true));
    }

    public static String getElexisDateSearchString(String value) {
        StringBuilder sb = null;
        Object ret = value.replaceAll("%", "");
        String filler = "%%%%%%%%";
        if (((String)ret).matches("[0-9]{3,}")) {
            sb = new StringBuilder((String)ret);
            sb.append("%%%%%%%%");
            ret = sb.substring(0, 8);
        } else {
            int dotCount = StringUtils.countMatches((CharSequence)ret, (CharSequence)".");
            String[] parts = ((String)ret).split("\\.");
            StringJoiner sj = new StringJoiner("");
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.length() == 1 && Character.isDigit(string.charAt(0))) {
                    sj.add("0" + string);
                } else {
                    sj.add(string);
                }
                ++n2;
            }
            sb = new StringBuilder(sj.toString());
            int lengthNoDots = sb.length();
            sb.append("%%%%%%%%");
            ret = dotCount == 1 && lengthNoDots == 6 ? sb.substring(2, 6) + sb.substring(0, 2) + sb.substring(6, 8) : sb.substring(4, 8) + sb.substring(2, 4) + sb.substring(0, 2);
        }
        return ret;
    }

    public static IPersistentObject getSelected(Class<?> template) {
        Optional<Class<?>> ciOpt = NoPoUtil.getClassToModelInterfaceService().getCoreModelInterfaceForElexisClass(template);
        if (ciOpt.isPresent()) {
            Optional selected = Optional.empty();
            selected = Anwender.class == template ? ContextServiceHolder.get().getActiveUserContact() : ContextServiceHolder.get().getTyped(ciOpt.get());
            if (selected.isPresent() && selected.get() instanceof Identifiable) {
                return (IPersistentObject)NoPoUtil.loadAsPersistentObject((Identifiable)selected.get(), template);
            }
        } else {
            LoggerFactory.getLogger(NoPoUtil.class).warn("Unknown code model interface for [" + String.valueOf(template) + "]");
            Optional selected = ContextServiceHolder.get().getTyped(template);
            if (selected.isPresent() && selected.get() instanceof IPersistentObject) {
                return (IPersistentObject)selected.get();
            }
        }
        return null;
    }

    private static ClassToModelInterfaceService getClassToModelInterfaceService() {
        if (classToModelInterfaceService == null) {
            classToModelInterfaceService = (ClassToModelInterfaceService)OsgiServiceUtil.getService(ClassToModelInterfaceService.class).orElseThrow(() -> new IllegalStateException("No ClassToModelInterfaceService"));
        }
        return classToModelInterfaceService;
    }
}

