/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.events;

import ch.elexis.core.data.activator.CoreHub;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat {
    public static final int FREQUENCY_HIGH = 1;
    public static final int FREQUENCY_MEDIUM = 2;
    public static final int FREQUENCY_LOW = 3;
    private beat theBeat = new beat();
    private Timer pacer;
    private boolean isSuspended;
    private static Heartbeat theHeartbeat;
    private CopyOnWriteArrayList<HeartListener> highFrequencyListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<HeartListener> mediumFrequencyListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<HeartListener> lowFrequencyListeners = new CopyOnWriteArrayList();
    private static Logger log;

    static {
        log = LoggerFactory.getLogger(Heartbeat.class);
    }

    private Heartbeat() {
        this.pacer = new Timer("Heartbeat", true);
        int interval = CoreHub.localCfg.get("ablauf/heartrate", 30);
        this.isSuspended = true;
        this.pacer.schedule((TimerTask)this.theBeat, 0L, (long)interval * 1000L);
    }

    public static Heartbeat getInstance() {
        if (theHeartbeat == null) {
            theHeartbeat = new Heartbeat();
        }
        return theHeartbeat;
    }

    public void resume(boolean immediately) {
        this.isSuspended = false;
        log.debug("resume");
        if (immediately) {
            this.theBeat.run();
        }
    }

    public void suspend() {
        log.debug("suspending");
        this.isSuspended = true;
    }

    public void stop() {
        log.debug("stopping");
        this.pacer.cancel();
    }

    public void addListener(HeartListener listen) {
        this.addListener(listen, 1);
    }

    public void addListener(HeartListener listen, int frequency) {
        if (!(this.highFrequencyListeners.contains(listen) || this.mediumFrequencyListeners.contains(listen) || this.lowFrequencyListeners.contains(listen))) {
            switch (frequency) {
                case 1: {
                    this.highFrequencyListeners.add(listen);
                    break;
                }
                case 2: {
                    this.mediumFrequencyListeners.add(listen);
                    break;
                }
                case 3: {
                    this.lowFrequencyListeners.add(listen);
                }
            }
        }
    }

    public void removeListener(HeartListener listen) {
        this.highFrequencyListeners.remove(listen);
        this.mediumFrequencyListeners.remove(listen);
        this.lowFrequencyListeners.remove(listen);
    }

    public static interface HeartListener {
        public void heartbeat();
    }

    private class beat
    extends TimerTask {
        private static final int FREQUENCY_HIGH_MULTIPLIER = 1;
        private static final int FREQUENCY_MEDIUM_MULTIPLIER = 4;
        private static final int FREQUENCY_LOW_MULTIPLIER = 16;
        private static final int RESET_MULTIPLIER = 16;
        private int counter = 0;

        private beat() {
        }

        @Override
        public void run() {
            if (!Heartbeat.this.isSuspended) {
                if (this.counter % 16 == 0) {
                    log.debug("Heartbeat low");
                    for (HeartListener l : Heartbeat.this.lowFrequencyListeners) {
                        l.heartbeat();
                    }
                }
                if (this.counter % 4 == 0) {
                    log.debug("Heartbeat medium");
                    for (HeartListener l : Heartbeat.this.mediumFrequencyListeners) {
                        l.heartbeat();
                    }
                }
                if (this.counter % 1 == 0) {
                    log.debug("Heartbeat high");
                    for (HeartListener l : Heartbeat.this.highFrequencyListeners) {
                        l.heartbeat();
                    }
                }
            }
            ++this.counter;
            this.counter %= 16;
        }
    }
}

