/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service;

import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;

public class LogProgressMonitor
implements IProgressMonitor {
    private Logger logger;
    private String name;
    private int totalWork;
    private int worked;
    private boolean cancelled;

    public LogProgressMonitor(Logger logger) {
        this.logger = logger;
        this.worked = 0;
        this.cancelled = false;
    }

    public void beginTask(String name, int totalWork) {
        this.name = name;
        this.totalWork = totalWork == -1 ? 9999 : totalWork;
        this.log();
    }

    private void log() {
        if (this.logger.isDebugEnabled()) {
            String msg = this.name + " [" + this.worked + "/" + this.totalWork + "]";
            if (this.cancelled) {
                msg = "-CNCLD- " + msg;
            }
            this.logger.debug(msg);
        }
    }

    public void done() {
        this.worked = this.totalWork;
        this.log();
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void setCanceled(boolean value) {
        this.cancelled = value;
        if (value) {
            this.log();
        }
    }

    public void setTaskName(String name) {
        this.name = name;
    }

    public void subTask(String name) {
        this.name = this.name + "/" + name;
    }

    public void worked(int work) {
        this.worked += work;
        this.log();
    }
}

