/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.es;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=remote/info/elexis/service/task/*"})
public class RemoteTaskEventHandler
implements EventHandler {
    @Reference
    private ITaskService taskService;
    @Reference(target="(service.model.name=ch.elexis.core.tasks.model)")
    private IModelService taskModelService;

    public void handleEvent(Event event) {
        String taskDescriptorId = (String)event.getProperty("id");
        ITaskDescriptor taskDescriptor = this.taskModelService.load(taskDescriptorId, ITaskDescriptor.class, true, true).orElse(null);
        String topic = event.getTopic();
        try {
            if (topic.endsWith("trigger")) {
                this.taskService.trigger(taskDescriptor, null, TaskTriggerType.MANUAL, null);
            } else if (topic.endsWith("refresh")) {
                this.taskService.refresh(taskDescriptor);
            }
        }
        catch (TaskException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error refreshing taskDescriptor [{}]", (Object)taskDescriptorId, (Object)e);
        }
    }
}

