/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.fhir.model.impl;

import ch.elexis.core.fhir.model.IFhirModelService;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.BaseResource;

public abstract class AbstractFhirModelAdapter<T extends BaseResource>
implements Identifiable {
    private T fhirResource;

    public AbstractFhirModelAdapter(T fhirResource) {
        this.fhirResource = fhirResource;
    }

    public T getFhirResource() {
        return this.fhirResource;
    }

    public String getId() {
        return this.fhirResource.getIdElement().getIdPart();
    }

    public String getLabel() {
        return this.fhirResource.getId();
    }

    public Long getLastupdate() {
        if (this.fhirResource.getMeta() != null && StringUtils.isNotBlank((CharSequence)this.fhirResource.getMeta().getVersionId())) {
            return Long.valueOf(this.fhirResource.getMeta().getVersionId());
        }
        return 0L;
    }

    public IXid getXid(String domain) {
        throw new UnsupportedOperationException();
    }

    public abstract Class<T> getFhirType();

    public abstract Class<?> getModelType();

    public Identifiable toEntityModelAdapter() {
        return CoreModelServiceHolder.get().load(this.getId(), this.getModelType()).orElse(null);
    }

    public Class<?> getModelServiceClass() {
        return IFhirModelService.class;
    }
}

