/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class AdressatTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Adressat";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(AdressatAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IContact adressat = this.getIdentifiable(context).orElse(null);
        if (adressat != null) {
            return Optional.ofNullable(this.replace(adressat, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        return context.getNamed(this.getSupportedType());
    }

    private String replace(IContact addressat, String lcAttribute) {
        AdressatAttribute patientAttribut = (AdressatAttribute)this.searchEnum(AdressatAttribute.class, lcAttribute);
        if (patientAttribut != null) {
            switch (patientAttribut) {
                case Anrede: {
                    if (addressat.isPerson()) {
                        return PersonFormatUtil.getSalutation((IPerson)addressat.asIPerson());
                    }
                    return "";
                }
                case Name: {
                    if (addressat.isPerson()) {
                        return addressat.asIPerson().getLastName();
                    }
                    return addressat.getDescription1();
                }
                case Vorname: {
                    if (addressat.isPerson()) {
                        return addressat.asIPerson().getFirstName();
                    }
                    return "";
                }
                case Anschrift: {
                    return AddressFormatUtil.getPostalAddress((IContact)addressat, (boolean)true);
                }
                case Anschriftzeile: {
                    return AddressFormatUtil.getPostalAddress((IContact)addressat, (boolean)false);
                }
            }
        }
        return null;
    }

    private static enum AdressatAttribute implements ILocalizedEnum
    {
        Name("Nachname des Adressat"),
        Vorname("Vorname des Adressat"),
        Anrede("Anrede des Adressat"),
        Anschrift("Mehrzeilige Anschrift"),
        Anschriftzeile("Einzeilige Anschrift");

        final String description;

        private AdressatAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

