/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.AccessControlList;
import ch.elexis.core.ac.AccessControlListUtil;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.ac.SystemCommandEvaluatableACE;
import ch.elexis.core.constants.ElexisSystemPropertyConstants;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RoleBasedAccessControlService
implements IAccessControlService {
    private Logger logger;
    private final boolean logDenials;
    @Reference
    Gson gson;
    @Reference
    HttpClient httpClient;
    @Reference
    IContextService contextService;
    private ThreadLocal<Boolean> privileged;
    private Map<Integer, AccessControlList> combinedRolesAclMap;
    private Map<String, AccessControlList> roleAclMap;
    private IUserService userService;
    private final String[] aoboObjects = new String[]{"IEncounter", "IInvoice"};

    public RoleBasedAccessControlService() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logDenials = ElexisSystemPropertyConstants.VERBOSE_ACL_NOTIFICATION;
        this.combinedRolesAclMap = Collections.synchronizedMap(new HashMap());
        this.roleAclMap = Collections.synchronizedMap(new HashMap());
        this.privileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    public boolean evaluate(EvaluatableACE evaluatableAce) {
        if (this.isPrivileged()) {
            return true;
        }
        String activeUserId = this.contextService.getActiveUser().map(Identifiable::getId).orElse(null);
        if (activeUserId != null) {
            int combinedRolesHashCode = this.contextService.getActiveUser().map(IUser::getRoleIds).get().hashCode();
            if (!this.combinedRolesAclMap.containsKey(combinedRolesHashCode)) {
                this.refresh(activeUserId, this.contextService.getActiveUser().map(IUser::getRoleIds).get());
            }
            boolean result = this.evaluateACE(this.combinedRolesAclMap.get(combinedRolesHashCode), evaluatableAce);
            if (this.logDenials && !result) {
                this.logger.info("User %s denied %s ", (Object)activeUserId, (Object)evaluatableAce.toString());
                this.logger.info("Combined Roles: %s", (Object)this.gson.toJson((Object)this.combinedRolesAclMap.get(combinedRolesHashCode)));
            }
            return result;
        }
        this.logger.warn("No active user to evalute");
        return false;
    }

    public void refresh(IUser user) {
        this.refresh(user.getId(), user.getRoleIds());
    }

    public void refresh(String userId, List<String> roles) {
        AccessControlList userAccessControlList = this.determineUserAccessControlList(roles);
        this.combinedRolesAclMap.put(roles.hashCode(), userAccessControlList);
        if (userAccessControlList.getRolesRepresented().isEmpty()) {
            this.logger.warn("ACE User=[{}] Empty Role Set", (Object)userId);
        } else {
            this.logger.info("Refresh ACE User=[{}] Roles={}", (Object)userId, (Object)userAccessControlList.getRolesRepresented());
        }
    }

    public boolean isPrivileged() {
        return this.privileged.get() != false || CoreUtil.isTestMode() && this.contextService.getNamed("testAccessControl").isEmpty();
    }

    private AccessControlList determineUserAccessControlList(List<String> roles) {
        if (roles.isEmpty()) {
            return new AccessControlList();
        }
        AccessControlList accessControlList = null;
        for (String roleId : roles) {
            if (accessControlList == null) {
                accessControlList = this.getOrLoadRoleAccessControlList(roleId);
                continue;
            }
            AccessControlList _accessControlList = this.roleAclMap.get(roleId.toLowerCase());
            if (_accessControlList == null) {
                _accessControlList = this.getOrLoadRoleAccessControlList(roleId);
            }
            if (_accessControlList != null) {
                accessControlList = AccessControlListUtil.merge((AccessControlList)accessControlList, (AccessControlList)_accessControlList);
                continue;
            }
            this.logger.warn("Unknown role [" + roleId + "]");
        }
        if (accessControlList == null) {
            accessControlList = new AccessControlList();
        }
        return accessControlList;
    }

    public AccessControlList getOrLoadRoleAccessControlList(String roleId) {
        if (!this.roleAclMap.containsKey(roleId)) {
            if (ElexisSystemPropertyConstants.IS_EE_DEPENDENT_OPERATION_MODE) {
                this.loadRoleAccessControlListDependent(roleId);
            } else {
                this.doPrivileged(() -> {
                    IRole role = (IRole)CoreModelServiceHolder.get().load(roleId, IRole.class).orElseThrow();
                    this.loadRoleAccessControlListLegacy(role);
                });
            }
        }
        return this.roleAclMap.get(roleId);
    }

    private void loadRoleAccessControlListDependent(String roleId) {
        String accessToken = ((AccessToken)this.contextService.getTyped(AccessToken.class).get()).getToken();
        HttpRequest request = HttpRequest.newBuilder(URI.create("https://" + ElexisSystemPropertyConstants.GET_EE_HOSTNAME + "/api/v1/ops/elexis-rcp/acl/" + roleId)).header("Authorization", "Bearer " + accessToken).header("accept", "application/json").build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (204 == response.statusCode()) {
                this.logger.info("No acl file for role [{}]", (Object)roleId);
                return;
            }
            AccessControlList acl = (AccessControlList)this.gson.fromJson(response.body(), AccessControlList.class);
            this.roleAclMap.put(roleId, acl);
        }
        catch (Exception e) {
            this.logger.error("Error loading role acl [{}]", (Object)roleId, (Object)e);
        }
    }

    private void loadRoleAccessControlListLegacy(IRole iRole) {
        String _role = iRole.getId().toLowerCase();
        if (!this.roleAclMap.containsKey(_role)) {
            InputStream jsonStream = null;
            if (iRole.isSystemRole()) {
                jsonStream = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/" + _role + ".json");
            } else {
                String jsonValue = (String)iRole.getExtInfo((Object)"json");
                if (StringUtils.isNotBlank((CharSequence)jsonValue)) {
                    try {
                        jsonStream = new ByteArrayInputStream(jsonValue.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("Invalid role custom json acl [{}]", (Object)_role, (Object)e);
                    }
                }
            }
            if (jsonStream != null) {
                Optional<AccessControlList> acl = this.readAccessControlList(jsonStream);
                if (acl.isPresent()) {
                    this.roleAclMap.put(_role, acl.get());
                } else {
                    this.logger.error("Error loading role acl [{}]", (Object)_role);
                }
            } else {
                this.logger.warn("No role acl [{}] file", (Object)_role);
            }
        }
    }

    public Optional<AccessControlList> readAccessControlList(InputStream jsonStream) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(jsonStream);){
                AccessControlList acl = (AccessControlList)this.gson.fromJson((Reader)inputStreamReader, AccessControlList.class);
                return Optional.of(acl);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.error("Error reading acl json", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean evaluateACE(AccessControlList acl, EvaluatableACE ace) {
        if (ace instanceof ObjectEvaluatableACE) {
            ObjectEvaluatableACE _ace = (ObjectEvaluatableACE)ace;
            ACEAccessBitMap useracebm = (ACEAccessBitMap)acl.getObject().get(_ace.getObject());
            if (useracebm != null) {
                byte[] aceBitMap = useracebm.getAccessRightMap();
                byte[] requested = _ace.getRequestedRightMap();
                byte[] evaluated = new byte[Right.values().length];
                short flattenedbitmap = 0;
                int i = 0;
                while (i < evaluated.length) {
                    if (aceBitMap[i] == 4) {
                        aceBitMap[i] = 1;
                        flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                    } else if (aceBitMap[i] == 2 || aceBitMap[i] == 1) {
                        if (StringUtils.isNotEmpty((CharSequence)_ace.getStoreToString()) && this.isAoboObject(_ace.getObject())) {
                            List<String> aoboMandatorIds = this.getAoboMandatorIds();
                            if (this.evaluateAobo(aoboMandatorIds, _ace)) {
                                aceBitMap[i] = 1;
                                flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                            } else {
                                aceBitMap[i] = 0;
                            }
                        } else {
                            aceBitMap[i] = 1;
                            flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                        }
                    }
                    evaluated[i] = (byte)(aceBitMap[i] & requested[i]);
                    ++i;
                }
                boolean result = (flattenedbitmap & _ace.getRequested()) == _ace.getRequested();
                return result;
            }
        } else if (ace instanceof SystemCommandEvaluatableACE) {
            SystemCommandEvaluatableACE _ace = (SystemCommandEvaluatableACE)ace;
            return this.evaluateSystemCommandACE(acl, _ace);
        }
        return false;
    }

    private boolean evaluateAobo(List<String> aoboMandatorIds, ObjectEvaluatableACE _ace) {
        Optional object = StoreToStringServiceHolder.get().loadFromString(_ace.getStoreToString());
        if (object.isPresent()) {
            String id = null;
            if (object.get() instanceof IEncounter) {
                if (((IEncounter)object.get()).getMandator() != null) {
                    id = ((IEncounter)object.get()).getMandator().getId();
                }
            } else if (object.get() instanceof IInvoice) {
                if (((IInvoice)object.get()).getMandator() != null) {
                    id = ((IInvoice)object.get()).getMandator().getId();
                }
            } else {
                this.logger.warn("Unknown aobo object [{}]", (Object)_ace.getStoreToString());
            }
            return id != null ? aoboMandatorIds.contains(id) : true;
        }
        this.logger.warn("Could not load aobo object [{}]", (Object)_ace.getStoreToString());
        return false;
    }

    public String getSelfMandatorId() {
        return this.contextService.getActiveUser().map(IUser::getAssociatedContactId).orElse("-1");
    }

    public List<String> getAoboMandatorIds() {
        if (this.userService == null) {
            this.userService = (IUserService)OsgiServiceUtil.getService(IUserService.class).get();
        }
        ArrayList<String> ret = new ArrayList<String>();
        this.contextService.getActiveUser().ifPresent(user -> {
            ret.add(user.getAssociatedContactId());
            this.userService.getExecutiveDoctorsWorkingFor(user, true).stream().forEach(m -> {
                boolean bl = ret.add(m.getId());
            });
        });
        return ret;
    }

    public List<String> getAoboMandatorIdsForSqlIn() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("-1");
        ret.addAll(this.getAoboMandatorIds());
        return ret;
    }

    private boolean isAoboObject(String object) {
        return Arrays.asList(this.aoboObjects).stream().filter(aobo -> object.endsWith((String)aobo)).findFirst().isPresent();
    }

    private boolean evaluateSystemCommandACE(AccessControlList acl, SystemCommandEvaluatableACE _ace) {
        if (acl.getSystemCommand().containsKey(_ace.getSystemCommandId())) {
            ACEAccessBitMap aceAccessBitMap = (ACEAccessBitMap)acl.getSystemCommand().get(_ace.getSystemCommandId());
            return aceAccessBitMap.grants(Right.EXECUTE);
        }
        return false;
    }

    public void doPrivileged(Runnable runnable) {
        try {
            this.privileged.set(Boolean.TRUE);
            this.logger.trace("Executing priviledged [" + String.valueOf(runnable) + "]");
            runnable.run();
        }
        finally {
            this.privileged.set(Boolean.FALSE);
        }
    }

    public Optional<ACEAccessBitMapConstraint> isAoboOrSelf(ObjectEvaluatableACE evaluatableAce) {
        AccessControlList acl;
        ACEAccessBitMap useracebm;
        if (this.isPrivileged()) {
            return Optional.empty();
        }
        if (!this.isAoboObject(evaluatableAce.getObject())) {
            return Optional.empty();
        }
        int combinedRolesHashCode = this.contextService.getActiveUser().map(IUser::getRoleIds).get().hashCode();
        if (!this.combinedRolesAclMap.containsKey(combinedRolesHashCode)) {
            this.refresh(this.contextService.getActiveUser().map(Identifiable::getId).get(), this.contextService.getActiveUser().map(IUser::getRoleIds).get());
        }
        if ((useracebm = (ACEAccessBitMap)(acl = this.combinedRolesAclMap.get(combinedRolesHashCode)).getObject().get(evaluatableAce.getObject())) != null) {
            byte[] aceBitMap = useracebm.getAccessRightMap();
            byte[] requested = evaluatableAce.getRequestedRightMap();
            int i = 0;
            while (i < requested.length) {
                if (requested[i] == 1 && aceBitMap[i] == 1) {
                    return Optional.of(ACEAccessBitMapConstraint.SELF);
                }
                if (requested[i] == 1 && aceBitMap[i] == 2) {
                    return Optional.of(ACEAccessBitMapConstraint.AOBO);
                }
                ++i;
            }
        }
        return Optional.empty();
    }
}

