/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class EncounterService
implements IEncounterService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private ICodeElementService codeElementService;
    @Reference
    private IBillingService billingService;
    @Reference
    private IConfigService configService;
    @Reference
    private IStoreToStringService storeToStringService;
    @Reference
    private ICoverageService coverageService;

    public boolean isEditable(IEncounter encounter) {
        boolean editable = false;
        if (encounter != null) {
            boolean hasRight = this.accessControlService.evaluate(EvACE.of(IEncounter.class, (Right)Right.UPDATE, (String)((String)this.storeToStringService.storeToString((Identifiable)encounter).get())));
            editable = hasRight ? this.isEditableInternal(encounter) : this.billingService.isEditable(encounter).isOK();
        }
        return editable;
    }

    public Result<IEncounter> transferToMandator(IEncounter encounter, IMandator mandator, boolean ignoreEditable) {
        if (encounter.getMandator().equals(mandator)) {
            return Result.OK();
        }
        Result editableResult = this.billingService.isEditable(encounter);
        if (!editableResult.isOK() && !ignoreEditable) {
            return editableResult;
        }
        Result<IEncounter> result = new Result<IEncounter>((Object)encounter);
        encounter.setMandator(mandator);
        CoreModelServiceHolder.get().save((Identifiable)encounter);
        result = this.reBillEncounter(encounter);
        this.coreModelService.save((Identifiable)encounter);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
        return result;
    }

    public Result<IEncounter> transferToCoverage(IEncounter encounter, ICoverage coverage, boolean ignoreEditable) {
        if (encounter.getCoverage().equals(coverage)) {
            return Result.OK();
        }
        Result editableResult = this.billingService.isEditable(encounter);
        if (!editableResult.isOK() && !ignoreEditable) {
            return editableResult;
        }
        Result<IEncounter> result = new Result<IEncounter>((Object)encounter);
        ICoverage encounterCovearage = encounter.getCoverage();
        encounter.setCoverage(coverage);
        this.coreModelService.save((Identifiable)encounter);
        if (encounterCovearage != null) {
            result = this.reBillEncounter(encounter);
        }
        encounter.addUpdated((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE);
        this.coreModelService.save((Identifiable)encounter);
        ContextServiceHolder.get().setActiveCoverage(coverage);
        return result;
    }

    public Result<IEncounter> reBillEncounter(IEncounter encounter) {
        IBillable billable;
        Result result = new Result((Object)encounter);
        ICodeElementService codeElementService = CodeElementServiceHolder.get();
        HashMap<Object, Object> context = this.getCodeElementServiceContext(encounter);
        List encounterBilled = encounter.getBilled();
        for (IBilled billed : encounterBilled) {
            billable = billed.getBillable();
            if (billable != null) continue;
            String message = "Could not resolve billable for billed [" + String.valueOf(billed) + "]";
            return new Result(Result.SEVERITY.ERROR, 0, message, (Object)encounter, false);
        }
        for (IBilled billed : encounterBilled) {
            billable = billed.getBillable();
            if ("Tarmed".equals(billable.getCodeSystemName())) {
                Optional matchingIBillable = codeElementService.loadFromString(billable.getCodeSystemName(), billable.getCode(), context);
                if (matchingIBillable.isPresent()) {
                    double amount = billed.getAmount();
                    encounter.removeBilled(billed);
                    int i = 0;
                    while ((double)i < amount) {
                        this.billingService.bill((IBillable)matchingIBillable.get(), encounter, 1.0);
                        ++i;
                    }
                    continue;
                }
                encounter.removeBilled(billed);
                String message = "Achtung: durch den Fall wechsel wurde die Position " + billable.getCode() + " automatisch entfernt, da diese im neuen Fall nicht vorhanden ist.";
                result.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
                continue;
            }
            Optional billableFactor = billable.getOptifier().getFactor(encounter);
            if (billableFactor.isPresent()) {
                billed.setFactor(((IBillingSystemFactor)billableFactor.get()).getFactor());
            } else {
                billed.setFactor(1.0);
            }
            this.coreModelService.save((Identifiable)billed);
        }
        return result;
    }

    private HashMap<Object, Object> getCodeElementServiceContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
        ICoverage coverage = encounter.getCoverage();
        if (coverage != null) {
            ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
        }
        return ret;
    }

    private boolean isEditableInternal(IEncounter encounter) {
        boolean mandatorLoggedIn;
        ICoverage coverage = encounter.getCoverage();
        if (coverage != null && !coverage.isOpen()) {
            return false;
        }
        IMandator encounterMandator = encounter.getMandator();
        boolean checkMandant = !this.accessControlService.evaluate(EvACE.of((String)"LSTG_CHARGE_FOR_ALL"));
        boolean mandatorOK = true;
        IMandator activeMandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        boolean bl = mandatorLoggedIn = activeMandator != null;
        if (encounterMandator != null && activeMandator != null && checkMandant && !encounterMandator.getId().equals(activeMandator.getId())) {
            mandatorOK = false;
        }
        boolean ok = mandatorOK && mandatorLoggedIn;
        return ok;
    }

    public Optional<IEncounter> getLatestEncounter(IPatient patient, boolean create) {
        List coverages;
        if (!ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return Optional.empty();
        }
        IMandator activeMandator = (IMandator)ContextServiceHolder.get().getActiveMandator().get();
        IContact userContact = (IContact)ContextServiceHolder.get().getActiveUserContact().get();
        IQuery encounterQuery = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        if (!ConfigServiceHolder.get().get(userContact, "fall/load_consall", false)) {
            encounterQuery.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)activeMandator);
        }
        if ((coverages = patient.getCoverages()) == null || coverages.isEmpty()) {
            return create ? this.createCoverageAndEncounter(patient) : Optional.empty();
        }
        encounterQuery.startGroup();
        boolean termInserted = false;
        for (ICoverage coverage : coverages) {
            if (!coverage.isOpen()) continue;
            encounterQuery.or((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.EQUALS, (Object)coverage);
            termInserted = true;
        }
        if (!termInserted) {
            return create ? this.createCoverageAndEncounter(patient) : Optional.empty();
        }
        encounterQuery.andJoinGroups();
        encounterQuery.orderBy((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.ORDER.DESC);
        List list = encounterQuery.execute();
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((IEncounter)list.get(0));
    }

    private Optional<IEncounter> createCoverageAndEncounter(IPatient patient) {
        ICoverage coverage = CoverageServiceHolder.get().createDefaultCoverage(patient);
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (activeMandator.isPresent()) {
            return Optional.of((IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)activeMandator.get()).buildAndSave());
        }
        return Optional.empty();
    }

    public Optional<IEncounter> getLatestEncounter(IPatient patient) {
        List result = null;
        Optional aoboOrSelf = this.accessControlService.isAoboOrSelf(EvACE.of(IEncounter.class, (Right)Right.READ));
        if (aoboOrSelf.isPresent()) {
            INamedQuery query = CoreModelServiceHolder.get().getNamedQueryByName(IEncounter.class, IEncounter.class, "Behandlung.patient.last.aobo");
            if (aoboOrSelf.get() == ACEAccessBitMapConstraint.AOBO) {
                result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient, "aoboids", this.accessControlService.getAoboMandatorIdsForSqlIn()}));
            } else if (aoboOrSelf.get() == ACEAccessBitMapConstraint.SELF) {
                result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient, "aoboids", Collections.singletonList(this.accessControlService.getSelfMandatorId())}));
            }
        } else {
            INamedQuery query = CoreModelServiceHolder.get().getNamedQueryByName(IEncounter.class, IEncounter.class, "Behandlung.patient.last");
            result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient}));
        }
        if (result != null && !result.isEmpty()) {
            return Optional.of((IEncounter)result.get(0));
        }
        return Optional.empty();
    }

    private String getVersionRemark() {
        String remark = "edit";
        Optional activeUser = ContextServiceHolder.get().getActiveUser();
        if (activeUser.isPresent()) {
            remark = ((IUser)activeUser.get()).getLabel();
        }
        return remark;
    }

    public synchronized void updateVersionedEntry(IEncounter encounter, Samdas samdas) {
        this.updateVersionedEntry(encounter, samdas.toString(), this.getVersionRemark());
    }

    public synchronized void updateVersionedEntry(IEncounter encounter, String entryXml, String remark) {
        this.coreModelService.refresh((Identifiable)encounter, true);
        encounter.getVersionedEntry().update(entryXml, remark);
        this.coreModelService.save((Identifiable)encounter);
    }

    public Money getSales(IEncounter encounter) {
        Money ret = new Money();
        for (IBilled billed : encounter.getBilled()) {
            ret.addMoney(billed.getTotal());
        }
        return ret;
    }

    public List<IEncounter> getAllEncountersForPatient(IPatient patient) {
        IQuery query = CoreModelServiceHolder.get().getQuery(ICoverage.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        List coverages = query.execute();
        List<IEncounter> collect = coverages.stream().flatMap(cv -> cv.getEncounters().stream()).sorted((c1, c2) -> c2.getDate().compareTo(c1.getDate())).collect(Collectors.toList());
        return collect;
    }

    public List<IBilled> getBilledByBillable(IEncounter encounter, IBillable billable) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IBilled.class, new String[]{"behandlung", "leistungenCode"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"behandlung", encounter, "leistungenCode", billable.getId()}));
    }

    public void addDefaultDiagnosis(IEncounter encounter) {
        Optional diagnose;
        String diagnosisSts = this.configService.getActiveUserContact("fall/std_diagnose", "");
        if (diagnosisSts.length() > 1 && (diagnose = StoreToStringServiceHolder.get().loadFromString(diagnosisSts)).isPresent()) {
            encounter.addDiagnosis((IDiagnosis)diagnose.get());
            this.coreModelService.save((Identifiable)encounter);
        }
    }

    public void addXRef(IEncounter encounter, String provider, String id, int pos, String text) {
        ContextServiceHolder.get().sendEvent("info/elexis/locking/prerelease", (Object)encounter);
        VersionedResource vr = encounter.getVersionedEntry();
        String ntext = vr.getHead();
        Samdas samdas = new Samdas(ntext);
        Samdas.Record record = samdas.getRecord();
        Object recText = record.getText();
        if (pos == -1 || pos > ((String)recText).length()) {
            pos = ((String)recText).length();
            recText = (String)recText + "\n" + text;
        } else {
            recText = ((String)recText).substring(0, pos) + "\n" + text + ((String)recText).substring(pos);
        }
        record.setText((String)recText);
        Samdas.XRef xref = new Samdas.XRef(provider, id, ++pos, text.length());
        record.add((Samdas.Range)xref);
        this.updateVersionedEntry(encounter, samdas);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
    }

    public Result<IEncounter> setEncounterDate(IEncounter encounter, LocalDate newDate) {
        Result result;
        encounter.setDate(newDate);
        CoreModelServiceHolder.get().save((Identifiable)encounter);
        Result ret = new Result((Object)encounter);
        IBillableVerifier verifier = null;
        for (IBilled billed : encounter.getBilled()) {
            IBillable billable = billed.getBillable();
            if (!"Tarmed".equals(billable.getCodeSystemName())) continue;
            verifier = billable.getVerifier();
            break;
        }
        if (verifier != null && !(result = verifier.verify(encounter)).isOK()) {
            List messages = result.getMessages();
            for (Result.msg msg2 : messages) {
                IBilled billed;
                IBillable billable;
                if (!(msg2.getObject() instanceof IBilled) || (billable = (billed = (IBilled)msg2.getObject()).getBillable()) == null) continue;
                encounter.removeBilled(billed);
                String message = "Achtung: durch die \u00c4nderung wurde die Position " + billable.getCode() + " automatisch entfernt.\nLimitation: " + msg2.getText();
                ret.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
            }
        }
        return ret;
    }

    public boolean canDelete(IEncounter element) {
        if (element != null) {
            return element.getBilled().isEmpty() && element.getDiagnoses().isEmpty();
        }
        return false;
    }
}

