/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.cons;

import ch.elexis.core.mail.ui.handlers.EncounterUtil;
import ch.elexis.core.mail.ui.handlers.TaskServiceHolder;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;
    public static final String EXTENSION_ID = "ch.elexis.core.mail.ui.cons";

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        return EXTENSION_ID;
    }

    public boolean doLayout(StyleRange styleRange, String provider, String id) {
        styleRange.background = CoreUiUtil.getColorForString((String)"a6ffaa");
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        Optional taskDescriptor = TaskServiceHolder.get().findTaskDescriptorByIdOrReferenceId(refID);
        taskDescriptor.ifPresent(descriptor -> {
            try {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command sendMailTaskCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMailTask");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ch.elexis.core.mail.ui.sendMailTaskDescriptorId", refID);
                ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailTaskCommand, params);
                ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).warn("Send mail Task command not available", (Throwable)ex);
            }
        });
        return true;
    }

    public String updateXRef(String provider, String refID) {
        Optional taskDescriptor = TaskServiceHolder.get().findTaskDescriptorByIdOrReferenceId(refID);
        if (taskDescriptor.isPresent()) {
            return EncounterUtil.getTaskDescriptorText((ITaskDescriptor)taskDescriptor.get());
        }
        return null;
    }

    public void insert(Object o, int pos) {
    }

    public IAction[] getActions() {
        return null;
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

