/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.supplier;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.ui.reminder.part.nattable.ReminderColumn;
import ch.elexis.core.ui.reminder.supplier.AllSupplier;
import ch.elexis.core.ui.reminder.supplier.ContactSupplier;
import ch.elexis.core.ui.reminder.supplier.FhirAllSupplier;
import ch.elexis.core.ui.reminder.supplier.FhirContactSupplier;
import ch.elexis.core.ui.reminder.supplier.FhirGroupSupplier;
import ch.elexis.core.ui.reminder.supplier.FhirModelServiceHolder;
import ch.elexis.core.ui.reminder.supplier.FhirPatientSupplier;
import ch.elexis.core.ui.reminder.supplier.FhirPopupSupplier;
import ch.elexis.core.ui.reminder.supplier.GroupSupplier;
import ch.elexis.core.ui.reminder.supplier.PatientSupplier;
import ch.elexis.core.ui.reminder.supplier.PopupSupplier;
import java.util.List;
import java.util.function.Supplier;

public class ReminderSupplierFactory {
    public static Supplier<List<IReminder>> get(ReminderColumn.Type type, String search, boolean showCompleted, int limit) {
        if (type == ReminderColumn.Type.ALL) {
            if (FhirModelServiceHolder.isAvailable()) {
                return new FhirAllSupplier(search, showCompleted, limit);
            }
            return new AllSupplier(search, showCompleted, limit);
        }
        if (type == ReminderColumn.Type.POPUP) {
            if (FhirModelServiceHolder.isAvailable()) {
                return new FhirPopupSupplier(search, showCompleted, limit);
            }
            return new PopupSupplier(search, showCompleted, limit);
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf((Object)type));
    }

    public static Supplier<List<IReminder>> get(IPatient patient, String search, boolean showCompleted, int limit) {
        if (FhirModelServiceHolder.isAvailable()) {
            return new FhirPatientSupplier(patient, search, showCompleted, limit);
        }
        return new PatientSupplier(patient, search, showCompleted, limit);
    }

    public static Supplier<List<IReminder>> get(IContact contact, String search, boolean showCompleted, int limit) {
        if (FhirModelServiceHolder.isAvailable()) {
            return new FhirContactSupplier(contact, search, showCompleted, limit);
        }
        return new ContactSupplier(contact, search, showCompleted, limit);
    }

    public static Supplier<List<IReminder>> get(IUserGroup group, String search, boolean showCompleted, int limit) {
        if (FhirModelServiceHolder.isAvailable()) {
            return new FhirGroupSupplier(group, search, showCompleted, limit);
        }
        return new GroupSupplier(group, search, showCompleted, limit);
    }
}

