/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.supplier;

import ca.uhn.fhir.rest.gclient.IQuery;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.ui.reminder.supplier.FhirModelServiceHolder;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class FhirContactSupplier
implements Supplier<List<IReminder>> {
    private IContact contact;
    private String search;
    private boolean showCompleted;
    private int limit;

    public FhirContactSupplier(IContact contact, String search, boolean showCompleted, int limit) {
        this.contact = contact;
        this.search = search;
        this.showCompleted = showCompleted;
        this.limit = limit;
    }

    @Override
    public List<IReminder> get() {
        long start = System.currentTimeMillis();
        IQuery query = FhirModelServiceHolder.get().getQuery("Task?owner=" + this.contact.getId() + "&status" + (this.showCompleted ? "" : ":not") + "=COMPLETED");
        query.count(this.limit);
        List<IReminder> ret = FhirModelServiceHolder.get().getQueryResults(query, IReminder.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.search})) {
            ret = ret.stream().filter(r -> r.getSubject() != null && r.getSubject().contains(this.search)).toList();
        }
        LoggerFactory.getLogger(this.getClass()).info("Supply [" + String.valueOf(this.contact) + "] took " + (System.currentTimeMillis() - start) + "[ms]");
        return ret;
    }
}

