/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ReminderCellPainterDecorator
extends CellPainterDecorator {
    public ReminderCellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, ICellPainter decoratorCellPainter) {
        super(baseCellPainter, cellEdge, decoratorCellPainter);
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle painterBounds = new Rectangle(adjustedCellBounds.x + 2, adjustedCellBounds.y + 2, adjustedCellBounds.width - 4, adjustedCellBounds.height - 4);
        Rectangle baseCellPainterBounds = this.getBaseCellPainterBounds(cell, gc, painterBounds, configRegistry);
        Rectangle decoratorCellPainterBounds = this.getDecoratorCellPainterBounds(cell, gc, painterBounds, configRegistry);
        Color originalBg = gc.getBackground();
        gc.setBackground(this.brighten((Color)CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR)));
        gc.fillRectangle(adjustedCellBounds);
        gc.setBackground(originalBg);
        if (this.getBaseCellPainter() != null) {
            this.getBaseCellPainter().paintCell(cell, gc, baseCellPainterBounds, configRegistry);
        }
        if (this.getDecoratorCellPainter() != null) {
            this.getDecoratorCellPainter().paintCell(cell, gc, decoratorCellPainterBounds, configRegistry);
        }
        gc.setClipping(adjustedCellBounds);
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        int originalLineStyle = gc.getLineStyle();
        Integer gridLineWidth = (Integer)configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, DisplayMode.NORMAL, (List)cell.getConfigLabels());
        int adjustment = gridLineWidth == null || gridLineWidth == 1 ? 0 : Math.round(gridLineWidth.floatValue() / 2.0f);
        int borderThickness = 2;
        gc.setLineWidth(2);
        Rectangle borderArea = new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, adjustedCellBounds.width, adjustedCellBounds.height);
        if (borderThickness >= 1) {
            int shift = 0;
            int areaShift = 0;
            if (borderThickness % 2 == 0) {
                shift = borderThickness / 2;
                areaShift = shift * 2;
            } else {
                shift = borderThickness / 2;
                areaShift = shift * 2 + 1;
            }
            borderArea.x += shift + adjustment;
            borderArea.y += shift + adjustment;
            borderArea.width -= areaShift + adjustment;
            borderArea.height -= areaShift + adjustment;
        }
        gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT((BorderStyle.LineStyleEnum)BorderStyle.LineStyleEnum.SOLID));
        gc.setForeground(GUIHelper.COLOR_BLACK);
        gc.drawRectangle(borderArea);
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
        gc.setLineStyle(originalLineStyle);
    }

    private Color brighten(Color attributeValue) {
        RGB rgb = attributeValue.getRGB();
        if (rgb.red < 220) {
            rgb.red += 25;
        }
        if (rgb.green < 220) {
            rgb.green += 25;
        }
        if (rgb.blue < 220) {
            rgb.blue += 25;
        }
        String colorString = rgb.toString();
        JFaceResources.getColorRegistry().put(colorString, rgb);
        return JFaceResources.getColorRegistry().get(colorString);
    }

    public Rectangle getDecoratorCellPainterBounds(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle ret = super.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        ret.y = adjustedCellBounds.y;
        ret.height = adjustedCellBounds.height;
        return ret;
    }
}

