/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.slf4j;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.slf4j.LoggerFactoryTracker;
import org.osgi.slf4j.SLF4JLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

class SLF4JLoggerFactory
implements ILoggerFactory {
    private final ConcurrentMap<String, SLF4JLogger> loggers = new ConcurrentHashMap<String, SLF4JLogger>();
    private final Bundle bundle;

    static SLF4JLoggerFactory getSLF4JLoggerFactory() {
        return Central.getSLF4JLoggerFactory();
    }

    static LoggerFactoryTracker getTracker() {
        return Central.getTracker();
    }

    SLF4JLoggerFactory(Bundle bundle) {
        this.bundle = bundle;
    }

    public Logger getLogger(String name) {
        SLF4JLogger logger = (SLF4JLogger)((Object)this.loggers.get(name));
        if (logger != null) {
            return logger;
        }
        logger = this.loggers.computeIfAbsent(name, n -> new SLF4JLogger(this.bundle, (String)n, SLF4JLoggerFactory.getTracker()));
        return logger;
    }

    static class Central
    extends SecurityManager
    implements SynchronousBundleListener {
        private static final Bundle self = FrameworkUtil.getBundle(SLF4JLoggerFactory.class);
        static final BundleContext systemBundleContext;
        static final LoggerFactoryTracker tracker;
        private static final Central central;
        private static final ConcurrentMap<Bundle, SLF4JLoggerFactory> factories;
        private final PrivilegedAction<Void> selfRemove = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                systemBundleContext.removeBundleListener((BundleListener)this);
                tracker.close();
                return null;
            }
        };

        private static BundleContext getSystemBundleContext(Bundle bundle) {
            BundleContext bc = bundle.getBundleContext();
            if (bc != null) {
                return bc.getBundle(0L).getBundleContext();
            }
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List wires = wiring.getRequiredWires("osgi.wiring.package");
            for (BundleWire wire : wires) {
                if (!"org.osgi.framework".equals(wire.getCapability().getAttributes().get("osgi.wiring.package"))) continue;
                return wire.getProviderWiring().getBundle().getBundleContext();
            }
            return null;
        }

        private static Bundle getCallerBundle() {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            boolean foundGetLogger = false;
            for (int i = 5; i < stack.length; ++i) {
                StackTraceElement trace = stack[i];
                if (trace.getClassName().equals("org.slf4j.LoggerFactory") && trace.getMethodName().equals("getLogger")) {
                    foundGetLogger = true;
                    continue;
                }
                if (!foundGetLogger) continue;
                Class<?>[] callers = central.getClassContext();
                Class<?> caller = callers[i - 1];
                Bundle b = FrameworkUtil.getBundle(caller);
                return b != null ? b : self;
            }
            return self;
        }

        static SLF4JLoggerFactory getSLF4JLoggerFactory() {
            Bundle callerBundle = Central.getCallerBundle();
            SLF4JLoggerFactory factory = (SLF4JLoggerFactory)factories.get(callerBundle);
            if (factory != null) {
                return factory;
            }
            SLF4JLoggerFactory newFactory = new SLF4JLoggerFactory(callerBundle);
            factory = factories.putIfAbsent(callerBundle, newFactory);
            return factory != null ? factory : newFactory;
        }

        static LoggerFactoryTracker getTracker() {
            return tracker;
        }

        Central() {
        }

        public void bundleChanged(BundleEvent event) {
            switch (event.getType()) {
                case 64: {
                    Bundle b = event.getBundle();
                    if (b.equals(self)) {
                        factories.clear();
                        AccessController.doPrivileged(this.selfRemove);
                        break;
                    }
                    factories.remove(b);
                }
            }
        }

        static {
            assert (self != null);
            systemBundleContext = Central.getSystemBundleContext(self);
            assert (systemBundleContext != null);
            tracker = new LoggerFactoryTracker(systemBundleContext);
            factories = new ConcurrentHashMap<Bundle, SLF4JLoggerFactory>();
            central = AccessController.doPrivileged(new PrivilegedAction<Central>(){

                @Override
                public Central run() {
                    Central c = new Central();
                    systemBundleContext.addBundleListener((BundleListener)c);
                    tracker.open(true);
                    return c;
                }
            });
        }
    }
}

