/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.provider;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.ui.editors.ContactSelectionDialogCellEditor;
import ch.elexis.core.ui.views.OrderManagementView;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class GenericOrderEditingSupport
extends EditingSupport {
    private final TableViewer viewer;
    private final EditingColumnType columnType;
    private final IOrder order;
    private final IOrderService orderService;
    private final OrderManagementView orderManagementView;
    private final int columnIndex;

    public GenericOrderEditingSupport(OrderManagementView orderManagementView, TableViewer viewer, EditingColumnType columnType, IOrder order, int columnIndex, IOrderService orderService) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.columnType = columnType;
        this.order = order;
        this.orderService = orderService;
        this.orderManagementView = orderManagementView;
        this.columnIndex = columnIndex;
    }

    protected CellEditor getCellEditor(Object element) {
        switch (this.columnType) {
            case SUPPLIER: {
                return new ContactSelectionDialogCellEditor((Composite)this.viewer.getTable(), Messages.OrderManagement_SelectSupplier_Title, Messages.OrderManagement_SelectSupplier_Message);
            }
        }
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.viewer.getTable(), 0);
        Text text = (Text)textCellEditor.getControl();
        text.setBackground(Display.getDefault().getSystemColor(1));
        final Runnable goNext = () -> {
            int total = this.viewer.getTable().getItemCount();
            int row = this.viewer.getTable().getSelectionIndex();
            while (++row < total && !this.canEdit(this.viewer.getElementAt(row))) {
            }
            if (row < total) {
                this.viewer.getTable().setSelection(row);
                this.viewer.editElement(this.viewer.getElementAt(row), this.columnIndex);
            } else {
                this.orderManagementView.handleOrderButtonClick();
            }
        };
        final Runnable goPrev = () -> {
            int row = this.viewer.getTable().getSelectionIndex();
            while (--row >= 0 && !this.canEdit(this.viewer.getElementAt(row))) {
            }
            if (row >= 0) {
                this.viewer.getTable().setSelection(row);
                this.viewer.editElement(this.viewer.getElementAt(row), this.columnIndex);
            }
        };
        text.addTraverseListener(e -> {
            if (e.detail == 4 || e.detail == 16) {
                e.doit = false;
                Display.getDefault().asyncExec(goNext);
            } else if (e.detail == 8) {
                e.doit = false;
                Display.getDefault().asyncExec(goPrev);
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    goNext.run();
                } else if (e.keyCode == 0x1000001) {
                    goPrev.run();
                }
            }
        });
        return textCellEditor;
    }

    protected boolean canEdit(Object element) {
        if (!(element instanceof IOrderEntry)) {
            return false;
        }
        IOrderEntry iOrderEntry = (IOrderEntry)element;
        return switch (this.columnType) {
            case EditingColumnType.ORDERED -> {
                void entry;
                if (entry.getState() == OrderEntryState.OPEN) {
                    yield true;
                }
                yield false;
            }
            case EditingColumnType.DELIVERED -> {
                void entry;
                if (this.orderManagementView.isDeliveryEditMode() && (entry.getState() == OrderEntryState.ORDERED || entry.getState() == OrderEntryState.PARTIAL_DELIVER)) {
                    yield true;
                }
                yield false;
            }
            case EditingColumnType.SUPPLIER -> true;
            default -> throw new MatchException(null, null);
        };
    }

    protected Object getValue(Object element) {
        if (!(element instanceof IOrderEntry)) {
            return null;
        }
        IOrderEntry iOrderEntry = (IOrderEntry)element;
        return switch (this.columnType) {
            case EditingColumnType.ORDERED -> {
                void entry;
                int amount = entry.getAmount();
                if (amount > 0) {
                    yield String.valueOf(amount);
                }
                yield "";
            }
            case EditingColumnType.DELIVERED -> String.valueOf("");
            case EditingColumnType.SUPPLIER -> {
                void entry;
                yield entry.getProvider();
            }
            default -> throw new MatchException(null, null);
        };
    }

    /*
     * WARNING - void declaration
     */
    protected void setValue(Object element, Object value) {
        if (!(element instanceof IOrderEntry)) {
            return;
        }
        IOrderEntry iOrderEntry = (IOrderEntry)element;
        try {
            switch (this.columnType) {
                case ORDERED: {
                    void entry;
                    int newAmount = Integer.parseInt(value.toString().trim());
                    int oldAmount = entry.getAmount();
                    if (oldAmount != newAmount) {
                        entry.setAmount(newAmount);
                        CoreModelServiceHolder.get().save((Identifiable)entry);
                        this.viewer.refresh((Object)entry);
                        if (this.orderService.getHistoryService() != null && this.order != null) {
                            this.orderService.getHistoryService().logChangedAmount(this.order, (IOrderEntry)entry, oldAmount, newAmount);
                        }
                    }
                    break;
                }
                case DELIVERED: {
                    void entry;
                    int part = Integer.parseInt(value.toString().trim());
                    this.orderManagementView.getPendingDeliveredValues().put((IOrderEntry)entry, part);
                    this.viewer.update((Object)entry, null);
                    break;
                }
                case SUPPLIER: {
                    void entry;
                    if (!(value instanceof IContact)) break;
                    IContact contact = (IContact)value;
                    entry.setProvider(contact);
                    if (this.orderService.getHistoryService() != null && this.order != null) {
                        this.orderService.getHistoryService().logSupplierAdded(this.order, (IOrderEntry)entry, contact.getLabel());
                    }
                    CoreModelServiceHolder.get().save((Identifiable)entry);
                    this.viewer.refresh((Object)entry);
                    this.orderManagementView.refresh();
                }
                default: {
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static enum EditingColumnType {
        ORDERED,
        DELIVERED,
        SUPPLIER;

    }
}

